/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.stack;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class StackTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(StackTemplateRegistry.class);
    public static final Version MIN_NODE_VERSION = Version.V_8_9_0;
    public static final int REGISTRY_VERSION = 3;
    public static final String TEMPLATE_VERSION_VARIABLE = "xpack.stack.template.version";
    public static final Setting<Boolean> STACK_TEMPLATES_ENABLED = Setting.boolSetting((String)"stack.templates.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private volatile boolean stackTemplateEnabled;
    public static final String DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "data-streams-mappings";
    public static final String ECS_DYNAMIC_MAPPINGS_COMPONENT_TEMPLATE_NAME = "ecs@dynamic_templates";
    public static final String ILM_7_DAYS_POLICY_NAME = "7-days-default";
    public static final String ILM_30_DAYS_POLICY_NAME = "30-days-default";
    public static final String ILM_90_DAYS_POLICY_NAME = "90-days-default";
    public static final String ILM_180_DAYS_POLICY_NAME = "180-days-default";
    public static final String ILM_365_DAYS_POLICY_NAME = "365-days-default";
    public static final String LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "logs-mappings";
    public static final String LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME = "logs-settings";
    public static final String LOGS_ILM_POLICY_NAME = "logs";
    public static final String LOGS_INDEX_TEMPLATE_NAME = "logs";
    public static final String METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "metrics-mappings";
    public static final String METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics-settings";
    public static final String METRICS_TSDB_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics-tsdb-settings";
    public static final String METRICS_ILM_POLICY_NAME = "metrics";
    public static final String METRICS_INDEX_TEMPLATE_NAME = "metrics";
    public static final String SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "synthetics-mappings";
    public static final String SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "synthetics-settings";
    public static final String SYNTHETICS_ILM_POLICY_NAME = "synthetics";
    public static final String SYNTHETICS_INDEX_TEMPLATE_NAME = "synthetics";
    public static final String KIBANA_REPORTING_INDEX_TEMPLATE_NAME = ".kibana-reporting";
    private static final List<LifecyclePolicyConfig> LIFECYCLE_POLICY_CONFIGS = List.of(new LifecyclePolicyConfig("logs", "/logs-policy.json"), new LifecyclePolicyConfig("metrics", "/metrics-policy.json"), new LifecyclePolicyConfig("synthetics", "/synthetics-policy.json"), new LifecyclePolicyConfig("7-days-default", "/7-days-default.json"), new LifecyclePolicyConfig("30-days-default", "/30-days-default.json"), new LifecyclePolicyConfig("90-days-default", "/90-days-default.json"), new LifecyclePolicyConfig("180-days-default", "/180-days-default.json"), new LifecyclePolicyConfig("365-days-default", "/365-days-default.json"));
    private static final Map<String, ComponentTemplate> COMPONENT_TEMPLATE_CONFIGS;
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
    private static final List<IngestPipelineConfig> INGEST_PIPELINE_CONFIGS;

    public StackTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.clusterService = clusterService;
        this.stackTemplateEnabled = (Boolean)STACK_TEMPLATES_ENABLED.get(nodeSettings);
    }

    public void initialize() {
        super.initialize();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(STACK_TEMPLATES_ENABLED, this::updateEnabledSetting);
    }

    private void updateEnabledSetting(boolean newValue) {
        if (newValue) {
            this.stackTemplateEnabled = true;
        } else {
            logger.info("stack composable templates [{}] and component templates [{}] will not be installed or reinstalled", (Object)String.join((CharSequence)",", this.getComposableTemplateConfigs().keySet()), (Object)String.join((CharSequence)",", this.getComponentTemplateConfigs().keySet()));
            this.stackTemplateEnabled = false;
        }
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return LIFECYCLE_POLICY_CONFIGS;
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.stackTemplateEnabled) {
            return this.lifecyclePolicies;
        }
        return Collections.emptyList();
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return COMPONENT_TEMPLATE_CONFIGS;
        }
        return Map.of();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
        }
        return Map.of();
    }

    protected List<IngestPipelineConfig> getIngestPipelines() {
        return INGEST_PIPELINE_CONFIGS;
    }

    protected String getOrigin() {
        return "stack";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        Version minNodeVersion = event.state().nodes().getMinNodeVersion();
        return minNodeVersion.onOrAfter((VersionId)MIN_NODE_VERSION);
    }

    static {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig(DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/data-streams-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/logs-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(ECS_DYNAMIC_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/ecs-dynamic-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/logs-settings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/metrics-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/metrics-settings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(METRICS_TSDB_SETTINGS_COMPONENT_TEMPLATE_NAME, "/metrics-tsdb-settings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/synthetics-mappings.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/synthetics-settings.json", 3, TEMPLATE_VERSION_VARIABLE))) {
            try {
                componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes())));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        COMPONENT_TEMPLATE_CONFIGS = Map.copyOf(componentTemplates);
        COMPOSABLE_INDEX_TEMPLATE_CONFIGS = StackTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig("logs", "/logs-template.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("metrics", "/metrics-template.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig("synthetics", "/synthetics-template.json", 3, TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(KIBANA_REPORTING_INDEX_TEMPLATE_NAME, "/kibana-reporting-template.json", 3, TEMPLATE_VERSION_VARIABLE)});
        INGEST_PIPELINE_CONFIGS = List.of(new IngestPipelineConfig("logs@json-message", "/logs-json-message-pipeline.json", 3, TEMPLATE_VERSION_VARIABLE), new IngestPipelineConfig("logs-default-pipeline", "/logs-default-pipeline.json", 3, TEMPLATE_VERSION_VARIABLE, Collections.singletonList("logs@json-message")));
    }
}

