/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.packageloader.action;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.AuditMlNotificationAction;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.packageloader.action.LoadTrainedModelPackageAction;
import org.elasticsearch.xpack.ml.packageloader.action.ModelImporter;

public class TransportLoadTrainedModelPackage
extends TransportMasterNodeAction<LoadTrainedModelPackageAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportLoadTrainedModelPackage.class);
    private final Client client;

    @Inject
    public TransportLoadTrainedModelPackage(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super("cluster:internal/xpack/ml/trained_models/package_loader/load", transportService, clusterService, threadPool, actionFilters, LoadTrainedModelPackageAction.Request::new, indexNameExpressionResolver, NodeAcknowledgedResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "ml");
    }

    protected ClusterBlockException checkBlock(LoadTrainedModelPackageAction.Request request, ClusterState state) {
        return null;
    }

    protected void masterOperation(Task task, LoadTrainedModelPackageAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        CancellableTask downloadTask = this.createDownloadTask(request);
        try {
            ParentTaskAssigningClient parentTaskAssigningClient = this.getParentTaskAssigningClient((Task)downloadTask);
            ModelImporter modelImporter = new ModelImporter((Client)parentTaskAssigningClient, request.getModelId(), request.getModelPackageConfig(), downloadTask);
            this.threadPool.executor("ml_utility").execute(() -> TransportLoadTrainedModelPackage.importModel(this.client, this.taskManager, request, modelImporter, listener, (Task)downloadTask));
        }
        catch (Exception e) {
            this.taskManager.unregister((Task)downloadTask);
            throw e;
        }
        if (!request.isWaitForCompletion()) {
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }
    }

    private ParentTaskAssigningClient getParentTaskAssigningClient(Task originTask) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), originTask.getId());
        return new ParentTaskAssigningClient(this.client, parentTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void importModel(Client auditClient, TaskManager taskManager, LoadTrainedModelPackageAction.Request request, ModelImporter modelImporter, ActionListener<AcknowledgedResponse> listener, Task task) {
        String modelId = request.getModelId();
        AtomicReference<Exception> exceptionRef = new AtomicReference<Exception>();
        try {
            long relativeStartNanos = System.nanoTime();
            modelImporter.doImport();
            long totalRuntimeNanos = System.nanoTime() - relativeStartNanos;
            TransportLoadTrainedModelPackage.logAndWriteNotificationAtInfo(auditClient, modelId, Strings.format((String)"finished model import after [%d] seconds", (Object[])new Object[]{TimeUnit.NANOSECONDS.toSeconds(totalRuntimeNanos)}));
        }
        catch (ElasticsearchException e) {
            TransportLoadTrainedModelPackage.recordError(auditClient, modelId, exceptionRef, (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            TransportLoadTrainedModelPackage.recordError(auditClient, modelId, "an invalid URL", exceptionRef, e, RestStatus.INTERNAL_SERVER_ERROR);
        }
        catch (URISyntaxException e) {
            TransportLoadTrainedModelPackage.recordError(auditClient, modelId, "an invalid URL syntax", exceptionRef, e, RestStatus.INTERNAL_SERVER_ERROR);
        }
        catch (IOException e) {
            TransportLoadTrainedModelPackage.recordError(auditClient, modelId, "an IOException", exceptionRef, e, RestStatus.SERVICE_UNAVAILABLE);
        }
        catch (Exception e) {
            TransportLoadTrainedModelPackage.recordError(auditClient, modelId, "an Exception", exceptionRef, e, RestStatus.INTERNAL_SERVER_ERROR);
        }
        finally {
            taskManager.unregister(task);
            if (request.isWaitForCompletion()) {
                if (exceptionRef.get() != null) {
                    listener.onFailure(exceptionRef.get());
                } else {
                    listener.onResponse((Object)AcknowledgedResponse.TRUE);
                }
            }
        }
    }

    private CancellableTask createDownloadTask(final LoadTrainedModelPackageAction.Request request) {
        return (CancellableTask)this.taskManager.register("model_import", "xpack/ml/model_import[n]", new TaskAwareRequest(){

            public void setParentTask(TaskId taskId) {
                request.setParentTask(taskId);
            }

            public void setRequestId(long requestId) {
                request.setRequestId(requestId);
            }

            public TaskId getParentTask() {
                return request.getParentTask();
            }

            public CancellableTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                return new CancellableTask(id, type, action, MlTasks.downloadModelTaskDescription((String)request.getModelId()), parentTaskId, headers);
            }
        }, false);
    }

    private static void recordError(Client client, String modelId, AtomicReference<Exception> exceptionRef, Exception e) {
        TransportLoadTrainedModelPackage.logAndWriteNotificationAtError(client, modelId, e.toString());
        exceptionRef.set(e);
    }

    private static void recordError(Client client, String modelId, String failureType, AtomicReference<Exception> exceptionRef, Exception e, RestStatus status) {
        String message = Strings.format((String)"Model importing failed due to %s [%s]", (Object[])new Object[]{failureType, e});
        TransportLoadTrainedModelPackage.logAndWriteNotificationAtError(client, modelId, message);
        exceptionRef.set((Exception)new ElasticsearchStatusException(message, status, (Throwable)e, new Object[0]));
    }

    private static void logAndWriteNotificationAtError(Client client, String modelId, String message) {
        TransportLoadTrainedModelPackage.writeNotification(client, modelId, message, Level.ERROR);
        logger.error(Strings.format((String)"[%s] %s", (Object[])new Object[]{modelId, message}));
    }

    private static void logAndWriteNotificationAtInfo(Client client, String modelId, String message) {
        TransportLoadTrainedModelPackage.writeNotification(client, modelId, message, Level.INFO);
        logger.info(Strings.format((String)"[%s] %s", (Object[])new Object[]{modelId, message}));
    }

    private static void writeNotification(Client client, String modelId, String message, Level level) {
        client.execute((ActionType)AuditMlNotificationAction.INSTANCE, (ActionRequest)new AuditMlNotificationAction.Request(AuditMlNotificationAction.AuditType.INFERENCE, modelId, message, level), ActionListener.noop());
    }
}

