/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.sql.expression.function.scalar.CastProcessor;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;

public class Cast
extends UnaryScalarFunction {
    private final DataType dataType;

    public Cast(Source source, Expression field, DataType dataType) {
        super(source, field);
        this.dataType = dataType;
    }

    protected NodeInfo<Cast> info() {
        return NodeInfo.create((Node)this, Cast::new, (Object)this.field(), (Object)this.dataType);
    }

    protected UnaryScalarFunction replaceChild(Expression newChild) {
        return new Cast(this.source(), newChild, this.dataType);
    }

    public DataType from() {
        return this.field().dataType();
    }

    public DataType to() {
        return this.dataType;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public boolean foldable() {
        return this.field().foldable();
    }

    public Object fold() {
        return SqlDataTypeConverter.convert(this.field().fold(), this.dataType);
    }

    public Nullability nullable() {
        return Expressions.isNull((Expression)this.field()) ? Nullability.TRUE : Nullability.UNKNOWN;
    }

    protected Expression.TypeResolution resolveType() {
        return SqlDataTypeConverter.canConvert(this.from(), this.to()) ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution("Cannot cast [" + this.from() + "] to [" + this.to() + "]");
    }

    protected Processor makeProcessor() {
        return new CastProcessor(SqlDataTypeConverter.converterFor(this.from(), this.to()));
    }

    public ScriptTemplate asScript() {
        ScriptTemplate fieldAsScript = this.asScript(this.field());
        return new ScriptTemplate(this.formatTemplate(LoggerMessageFormat.format((String)"{sql}.", (String)"cast({},{})", (Object[])new Object[]{fieldAsScript.template()})), ParamsBuilder.paramsBuilder().script(fieldAsScript.params()).variable((Object)this.dataType.name()).build(), this.dataType());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Cast other = (Cast)((Object)obj);
        return Objects.equals(this.dataType, other.dataType()) && Objects.equals(this.field(), other.field());
    }
}

