/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.rest;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.xpack.vectortile.feature.FeatureFactory;
import org.elasticsearch.xpack.vectortile.rest.GridAggregation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum GridType {
    GRID{

        @Override
        public byte[] toFeature(GridAggregation gridAggregation, InternalGeoGridBucket bucket, String key, FeatureFactory featureFactory) throws IOException {
            return gridAggregation.toGrid(key, featureFactory);
        }
    }
    ,
    POINT{

        @Override
        public byte[] toFeature(GridAggregation gridAggregation, InternalGeoGridBucket bucket, String key, FeatureFactory featureFactory) throws IOException {
            GeoPoint point = (GeoPoint)bucket.getKey();
            return featureFactory.point(point.lon(), point.lat());
        }
    }
    ,
    CENTROID{

        @Override
        public byte[] toFeature(GridAggregation gridAggregation, InternalGeoGridBucket bucket, String key, FeatureFactory featureFactory) throws IOException {
            Rectangle r = gridAggregation.toRectangle(key);
            InternalGeoCentroid centroid = (InternalGeoCentroid)bucket.getAggregations().get("_mvt_centroid");
            double featureLon = Math.min(Math.max(centroid.centroid().getX(), r.getMinLon()), r.getMaxLon());
            double featureLat = Math.min(Math.max(centroid.centroid().getY(), r.getMinLat()), r.getMaxLat());
            return featureFactory.point(featureLon, featureLat);
        }
    };


    public abstract byte[] toFeature(GridAggregation var1, InternalGeoGridBucket var2, String var3, FeatureFactory var4) throws IOException;

    public static GridType fromString(String type) {
        return switch (type.toLowerCase(Locale.ROOT)) {
            case "grid" -> GRID;
            case "point" -> POINT;
            case "centroid" -> CENTROID;
            default -> throw new IllegalArgumentException("Invalid grid type [" + type + "]");
        };
    }
}

