/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.CcrRequests;
import org.elasticsearch.xpack.ccr.action.ShardChangesAction;
import org.elasticsearch.xpack.ccr.action.ShardFollowNodeTask;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsAction;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsRequest;
import org.elasticsearch.xpack.ccr.action.bulk.BulkShardOperationsResponse;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;

public class ShardFollowTasksExecutor
extends PersistentTasksExecutor<ShardFollowTask> {
    private static final Logger logger = LogManager.getLogger(ShardFollowTasksExecutor.class);
    private final Client client;
    private final ThreadPool threadPool;
    private final Executor ccrExecutor;
    private final ClusterService clusterService;
    private final IndexScopedSettings indexScopedSettings;
    private final TimeValue retentionLeaseRenewInterval;
    private volatile TimeValue waitForMetadataTimeOut;
    private static final PersistentTasksCustomMetadata.Assignment NO_ASSIGNMENT = new PersistentTasksCustomMetadata.Assignment(null, "no nodes found with data and remote cluster client roles");

    public ShardFollowTasksExecutor(Client client, ThreadPool threadPool, ClusterService clusterService, SettingsModule settingsModule) {
        super("xpack/ccr/shard_follow_task", "ccr");
        this.client = client;
        this.threadPool = threadPool;
        this.ccrExecutor = threadPool.executor(this.getExecutor());
        this.clusterService = clusterService;
        this.indexScopedSettings = settingsModule.getIndexScopedSettings();
        this.retentionLeaseRenewInterval = (TimeValue)CcrRetentionLeases.RETENTION_LEASE_RENEW_INTERVAL_SETTING.get(settingsModule.getSettings());
        this.waitForMetadataTimeOut = (TimeValue)CcrSettings.CCR_WAIT_FOR_METADATA_TIMEOUT.get(settingsModule.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CcrSettings.CCR_WAIT_FOR_METADATA_TIMEOUT, newVal -> {
            this.waitForMetadataTimeOut = newVal;
        });
    }

    public void validate(ShardFollowTask params, ClusterState clusterState) {
        IndexRoutingTable routingTable = clusterState.getRoutingTable().index(params.getFollowShardId().getIndex());
        ShardRouting primaryShard = routingTable.shard(params.getFollowShardId().id()).primaryShard();
        if (!primaryShard.active()) {
            throw new IllegalArgumentException("The primary shard of a follower index " + primaryShard + " is not active");
        }
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(ShardFollowTask params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        DiscoveryNode node = this.selectLeastLoadedNode(clusterState, candidateNodes, ((Predicate<DiscoveryNode>)DiscoveryNode::canContainData).and(DiscoveryNode::isRemoteClusterClient));
        if (node == null) {
            return NO_ASSIGNMENT;
        }
        return new PersistentTasksCustomMetadata.Assignment(node.getId(), "node is the least loaded data node and remote cluster client");
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<ShardFollowTask> taskInProgress, Map<String, String> headers) {
        final ShardFollowTask params = (ShardFollowTask)taskInProgress.getParams();
        final Client followerClient = CcrLicenseChecker.wrapClient(this.client, params.getHeaders(), this.clusterService.state());
        BiConsumer<TimeValue, Runnable> scheduler = (delay, command) -> this.threadPool.scheduleUnlessShuttingDown(delay, this.ccrExecutor, command);
        final String recordedLeaderShardHistoryUUID = this.getLeaderShardHistoryUUID(params);
        return new ShardFollowNodeTask(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers, params, scheduler, System::nanoTime){

            @Override
            protected void innerUpdateMapping(long minRequiredMappingVersion, LongConsumer handler, Consumer<Exception> errorHandler) {
                Index followerIndex = params.getFollowShardId().getIndex();
                Index leaderIndex = params.getLeaderShardId().getIndex();
                Supplier<TimeValue> timeout = () -> this.isStopped() ? TimeValue.MINUS_ONE : ShardFollowTasksExecutor.this.waitForMetadataTimeOut;
                ActionListener listener = ActionListener.wrap(indexMetadata -> {
                    if (indexMetadata.mapping() == null) {
                        assert (indexMetadata.getMappingVersion() == 1L);
                        handler.accept(indexMetadata.getMappingVersion());
                        return;
                    }
                    MappingMetadata mappingMetadata = indexMetadata.mapping();
                    PutMappingRequest putMappingRequest = CcrRequests.putMappingRequest(followerIndex.getName(), mappingMetadata);
                    followerClient.admin().indices().putMapping(putMappingRequest, ActionListener.wrap(putMappingResponse -> handler.accept(indexMetadata.getMappingVersion()), (Consumer)errorHandler));
                }, errorHandler);
                try {
                    CcrRequests.getIndexMetadata(ShardFollowTasksExecutor.this.remoteClient(params), leaderIndex, minRequiredMappingVersion, 0L, timeout, (ActionListener<IndexMetadata>)listener);
                }
                catch (NoSuchRemoteClusterException e) {
                    errorHandler.accept((Exception)((Object)e));
                }
            }

            @Override
            protected void innerUpdateSettings(LongConsumer finalHandler, Consumer<Exception> errorHandler) {
                Index leaderIndex = params.getLeaderShardId().getIndex();
                Index followIndex = params.getFollowShardId().getIndex();
                CheckedConsumer onResponse = clusterStateResponse -> {
                    Settings settings;
                    IndexMetadata leaderIMD = clusterStateResponse.getState().metadata().getIndexSafe(leaderIndex);
                    IndexMetadata followerIMD = ShardFollowTasksExecutor.this.clusterService.state().metadata().getIndexSafe(followIndex);
                    Settings existingSettings = TransportResumeFollowAction.filter(followerIMD.getSettings());
                    if (existingSettings.equals((Object)(settings = TransportResumeFollowAction.filter(leaderIMD.getSettings())))) {
                        finalHandler.accept(leaderIMD.getSettingsVersion());
                    } else {
                        Settings updatedSettings = settings.filter(s -> {
                            Setting indexSettings = ShardFollowTasksExecutor.this.indexScopedSettings.get(s);
                            if (indexSettings == null || indexSettings.isPrivateIndex() || indexSettings.isInternalIndex()) {
                                return false;
                            }
                            return existingSettings.get(s) == null || !existingSettings.get(s).equals(settings.get(s));
                        });
                        if (updatedSettings.isEmpty()) {
                            finalHandler.accept(leaderIMD.getSettingsVersion());
                            return;
                        }
                        if (updatedSettings.keySet().stream().allMatch(arg_0 -> ((IndexScopedSettings)ShardFollowTasksExecutor.this.indexScopedSettings).isDynamicSetting(arg_0))) {
                            UpdateSettingsRequest updateSettingsRequest = ((UpdateSettingsRequest)new UpdateSettingsRequest(new String[]{followIndex.getName()}).masterNodeTimeout(TimeValue.MAX_VALUE)).settings(updatedSettings);
                            followerClient.admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> finalHandler.accept(leaderIMD.getSettingsVersion()), (Consumer)errorHandler));
                        } else {
                            Runnable handler = () -> finalHandler.accept(leaderIMD.getSettingsVersion());
                            this.closeIndexUpdateSettingsAndOpenIndex(followIndex.getName(), updatedSettings, handler, errorHandler);
                        }
                    }
                };
                try {
                    ShardFollowTasksExecutor.this.remoteClient(params).admin().cluster().state(CcrRequests.metadataRequest(leaderIndex.getName()), ActionListener.wrap((CheckedConsumer)onResponse, errorHandler));
                }
                catch (NoSuchRemoteClusterException e) {
                    errorHandler.accept((Exception)((Object)e));
                }
            }

            @Override
            protected void innerUpdateAliases(LongConsumer handler, Consumer<Exception> errorHandler) {
                Index leaderIndex = params.getLeaderShardId().getIndex();
                Index followerIndex = params.getFollowShardId().getIndex();
                CheckedConsumer onResponse = clusterStateResponse -> {
                    IndexMetadata leaderIndexMetadata = clusterStateResponse.getState().metadata().getIndexSafe(leaderIndex);
                    IndexMetadata followerIndexMetadata = ShardFollowTasksExecutor.this.clusterService.state().metadata().getIndexSafe(followerIndex);
                    HashSet<String> aliasesOnLeaderNotOnFollower = new HashSet<String>();
                    HashSet<String> aliasesInCommon = new HashSet<String>();
                    HashSet aliasesOnFollowerNotOnLeader = new HashSet();
                    for (Iterator aliasName : leaderIndexMetadata.getAliases().keySet()) {
                        if (followerIndexMetadata.getAliases().containsKey(aliasName)) {
                            aliasesInCommon.add((String)((Object)aliasName));
                            continue;
                        }
                        aliasesOnLeaderNotOnFollower.add((String)((Object)aliasName));
                    }
                    for (Iterator aliasName : followerIndexMetadata.getAliases().keySet()) {
                        if (leaderIndexMetadata.getAliases().containsKey(aliasName)) {
                            assert (aliasesInCommon.contains(aliasName)) : aliasName;
                            continue;
                        }
                        aliasesOnFollowerNotOnLeader.add(aliasName);
                    }
                    ArrayList<IndicesAliasesRequest.AliasActions> aliasActions = new ArrayList<IndicesAliasesRequest.AliasActions>();
                    for (String string : aliasesOnLeaderNotOnFollower) {
                        AliasMetadata alias = (AliasMetadata)leaderIndexMetadata.getAliases().get(string);
                        aliasActions.add(IndicesAliasesRequest.AliasActions.add().index(followerIndex.getName()).alias(alias.alias()).filter(alias.filter() == null ? null : alias.filter().toString()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(Boolean.valueOf(false)));
                    }
                    for (String string : aliasesInCommon) {
                        AliasMetadata followerAliasMetadata;
                        AliasMetadata leaderAliasMetadata;
                        AliasMetadata leaderAliasMetadataWithoutWriteIndex = new AliasMetadata.Builder(string).filter((leaderAliasMetadata = (AliasMetadata)leaderIndexMetadata.getAliases().get(string)).filter()).indexRouting(leaderAliasMetadata.indexRouting()).searchRouting(leaderAliasMetadata.searchRouting()).writeIndex(Boolean.valueOf(false)).build();
                        if (leaderAliasMetadataWithoutWriteIndex.equals((Object)(followerAliasMetadata = (AliasMetadata)followerIndexMetadata.getAliases().get(string)))) continue;
                        aliasActions.add(IndicesAliasesRequest.AliasActions.add().index(followerIndex.getName()).alias(leaderAliasMetadata.alias()).filter(leaderAliasMetadata.filter() == null ? null : leaderAliasMetadata.filter().toString()).indexRouting(leaderAliasMetadata.indexRouting()).searchRouting(leaderAliasMetadata.searchRouting()).writeIndex(Boolean.valueOf(false)));
                    }
                    for (String string : aliasesOnFollowerNotOnLeader) {
                        aliasActions.add(IndicesAliasesRequest.AliasActions.remove().index(followerIndex.getName()).alias(string));
                    }
                    if (aliasActions.isEmpty()) {
                        handler.accept(leaderIndexMetadata.getAliasesVersion());
                    } else {
                        IndicesAliasesRequest request = (IndicesAliasesRequest)new IndicesAliasesRequest().masterNodeTimeout(TimeValue.MAX_VALUE);
                        request.origin("ccr");
                        aliasActions.forEach(arg_0 -> ((IndicesAliasesRequest)request).addAliasAction(arg_0));
                        followerClient.admin().indices().aliases(request, ActionListener.wrap(r -> handler.accept(leaderIndexMetadata.getAliasesVersion()), (Consumer)errorHandler));
                    }
                };
                try {
                    ShardFollowTasksExecutor.this.remoteClient(params).admin().cluster().state(CcrRequests.metadataRequest(leaderIndex.getName()), ActionListener.wrap((CheckedConsumer)onResponse, errorHandler));
                }
                catch (NoSuchRemoteClusterException e) {
                    errorHandler.accept((Exception)((Object)e));
                }
            }

            private void closeIndexUpdateSettingsAndOpenIndex(String followIndex, Settings updatedSettings, Runnable handler, Consumer<Exception> onFailure) {
                CloseIndexRequest closeRequest = (CloseIndexRequest)new CloseIndexRequest(new String[]{followIndex}).masterNodeTimeout(TimeValue.MAX_VALUE);
                CheckedConsumer onResponse = response -> this.updateSettingsAndOpenIndex(followIndex, updatedSettings, handler, onFailure);
                followerClient.admin().indices().close(closeRequest, ActionListener.wrap((CheckedConsumer)onResponse, onFailure));
            }

            private void updateSettingsAndOpenIndex(String followIndex, Settings updatedSettings, Runnable handler, Consumer<Exception> onFailure) {
                UpdateSettingsRequest updateSettingsRequest = (UpdateSettingsRequest)new UpdateSettingsRequest(new String[]{followIndex}).masterNodeTimeout(TimeValue.MAX_VALUE);
                updateSettingsRequest.settings(updatedSettings);
                CheckedConsumer onResponse = response -> this.openIndex(followIndex, handler, onFailure);
                followerClient.admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap((CheckedConsumer)onResponse, onFailure));
            }

            private void openIndex(String followIndex, Runnable handler, Consumer<Exception> onFailure) {
                OpenIndexRequest openIndexRequest = (OpenIndexRequest)new OpenIndexRequest(new String[]{followIndex}).masterNodeTimeout(TimeValue.MAX_VALUE);
                CheckedConsumer onResponse = response -> handler.run();
                followerClient.admin().indices().open(openIndexRequest, ActionListener.wrap((CheckedConsumer)onResponse, onFailure));
            }

            @Override
            protected void innerSendBulkShardOperationsRequest(String followerHistoryUUID, List<Translog.Operation> operations, long maxSeqNoOfUpdatesOrDeletes, Consumer<BulkShardOperationsResponse> handler, Consumer<Exception> errorHandler) {
                BulkShardOperationsRequest request = new BulkShardOperationsRequest(params.getFollowShardId(), followerHistoryUUID, operations, maxSeqNoOfUpdatesOrDeletes);
                followerClient.execute((ActionType)BulkShardOperationsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(handler::accept, errorHandler));
            }

            @Override
            protected void innerSendShardChangesRequest(long from, int maxOperationCount, Consumer<ShardChangesAction.Response> handler, Consumer<Exception> errorHandler) {
                ShardChangesAction.Request request = new ShardChangesAction.Request(params.getLeaderShardId(), recordedLeaderShardHistoryUUID);
                request.setFromSeqNo(from);
                request.setMaxOperationCount(maxOperationCount);
                request.setMaxBatchSize(params.getMaxReadRequestSize());
                request.setPollTimeout(params.getReadPollTimeout());
                try {
                    ShardFollowTasksExecutor.this.remoteClient(params).execute((ActionType)ShardChangesAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(handler::accept, errorHandler));
                }
                catch (NoSuchRemoteClusterException e) {
                    errorHandler.accept((Exception)((Object)e));
                }
            }

            @Override
            protected Scheduler.Cancellable scheduleBackgroundRetentionLeaseRenewal(LongSupplier followerGlobalCheckpoint) {
                String retentionLeaseId = CcrRetentionLeases.retentionLeaseId(ShardFollowTasksExecutor.this.clusterService.getClusterName().value(), params.getFollowShardId().getIndex(), params.getRemoteCluster(), params.getLeaderShardId().getIndex());
                ActionListener listener = ActionListener.wrap(r -> {}, e -> {
                    if (this.isCancelled() || this.isCompleted()) {
                        return;
                    }
                    Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    this.logRetentionLeaseFailure(retentionLeaseId, cause);
                    if (cause instanceof RetentionLeaseNotFoundException) {
                        logger.trace("{} background adding retention lease [{}] while following", (Object)params.getFollowShardId(), (Object)retentionLeaseId);
                        try {
                            ActionListener wrappedListener = ActionListener.wrap(r -> {}, inner -> {
                                Throwable innerCause = ExceptionsHelper.unwrapCause((Throwable)inner);
                                this.logRetentionLeaseFailure(retentionLeaseId, innerCause);
                            });
                            CcrRetentionLeases.asyncAddRetentionLease(params.getLeaderShardId(), retentionLeaseId, followerGlobalCheckpoint.getAsLong() + 1L, ShardFollowTasksExecutor.this.remoteClient(params), (ActionListener<ActionResponse.Empty>)wrappedListener);
                        }
                        catch (NoSuchRemoteClusterException rce) {
                            this.logRetentionLeaseFailure(retentionLeaseId, rce);
                        }
                    }
                });
                return ShardFollowTasksExecutor.this.threadPool.scheduleWithFixedDelay(() -> {
                    logger.trace("{} background renewing retention lease [{}] while following", (Object)params.getFollowShardId(), (Object)retentionLeaseId);
                    CcrRetentionLeases.asyncRenewRetentionLease(params.getLeaderShardId(), retentionLeaseId, followerGlobalCheckpoint.getAsLong() + 1L, ShardFollowTasksExecutor.this.remoteClient(params), (ActionListener<ActionResponse.Empty>)listener);
                }, ShardFollowTasksExecutor.this.retentionLeaseRenewInterval, ShardFollowTasksExecutor.this.ccrExecutor);
            }

            private void logRetentionLeaseFailure(String retentionLeaseId, Throwable cause) {
                assert (!(cause instanceof ElasticsearchSecurityException)) : cause;
                if (!(cause instanceof RetentionLeaseInvalidRetainingSeqNoException)) {
                    logger.warn(() -> Strings.format((String)"%s background management of retention lease [%s] failed while following", (Object[])new Object[]{params.getFollowShardId(), retentionLeaseId}), cause);
                }
            }
        };
    }

    private String getLeaderShardHistoryUUID(ShardFollowTask params) {
        IndexMetadata followIndexMetadata = this.clusterService.state().metadata().index(params.getFollowShardId().getIndex());
        Map ccrIndexMetadata = followIndexMetadata.getCustomData("ccr");
        String[] recordedLeaderShardHistoryUUIDs = TransportResumeFollowAction.extractLeaderShardHistoryUUIDs(ccrIndexMetadata);
        return recordedLeaderShardHistoryUUIDs[params.getLeaderShardId().id()];
    }

    private Client remoteClient(ShardFollowTask params) {
        return CcrLicenseChecker.wrapClient(this.client.getRemoteClusterClient(params.getRemoteCluster(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE), params.getHeaders(), this.clusterService.state());
    }

    protected void nodeOperation(AllocatedPersistentTask task, ShardFollowTask params, PersistentTaskState state) {
        Client followerClient = CcrLicenseChecker.wrapClient(this.client, params.getHeaders(), this.clusterService.state());
        ShardFollowNodeTask shardFollowNodeTask = (ShardFollowNodeTask)task;
        logger.info("{} Starting to track leader shard {}", (Object)params.getFollowShardId(), (Object)params.getLeaderShardId());
        FollowerStatsInfoHandler handler = (followerHistoryUUID, followerGCP, maxSeqNo) -> shardFollowNodeTask.start(followerHistoryUUID, followerGCP, maxSeqNo, followerGCP, maxSeqNo);
        Consumer<Exception> errorHandler = e -> {
            if (shardFollowNodeTask.isStopped()) {
                return;
            }
            if (ShardFollowNodeTask.shouldRetry(e)) {
                logger.debug(() -> Strings.format((String)"failed to fetch follow shard global %s checkpoint and max sequence number", (Object[])new Object[]{shardFollowNodeTask}), (Throwable)e);
                try {
                    this.threadPool.schedule(() -> this.nodeOperation(task, params, state), params.getMaxRetryDelay(), this.ccrExecutor);
                }
                catch (EsRejectedExecutionException rex) {
                    rex.addSuppressed((Throwable)e);
                    shardFollowNodeTask.onFatalFailure((Exception)((Object)rex));
                }
            } else {
                shardFollowNodeTask.onFatalFailure((Exception)e);
            }
        };
        this.fetchFollowerShardInfo(followerClient, params.getFollowShardId(), handler, errorHandler);
    }

    private void fetchFollowerShardInfo(Client followerClient, ShardId shardId, FollowerStatsInfoHandler handler, Consumer<Exception> errorHandler) {
        followerClient.admin().indices().stats((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{shardId.getIndexName()}), ActionListener.wrap(r -> {
            IndexStats indexStats = r.getIndex(shardId.getIndexName());
            if (indexStats == null) {
                IndexMetadata indexMetadata = this.clusterService.state().metadata().index(shardId.getIndex());
                if (indexMetadata != null) {
                    errorHandler.accept((Exception)new ShardNotFoundException(shardId));
                } else {
                    errorHandler.accept((Exception)new IndexNotFoundException(shardId.getIndex()));
                }
                return;
            }
            Optional<ShardStats> filteredShardStats = Arrays.stream(indexStats.getShards()).filter(shardStats -> shardStats.getShardRouting().shardId().equals((Object)shardId)).filter(shardStats -> shardStats.getShardRouting().primary()).findAny();
            if (filteredShardStats.isPresent()) {
                ShardStats shardStats2 = filteredShardStats.get();
                CommitStats commitStats = shardStats2.getCommitStats();
                if (commitStats == null) {
                    errorHandler.accept((Exception)new AlreadyClosedException(shardId + " commit_stats are missing"));
                    return;
                }
                SeqNoStats seqNoStats = shardStats2.getSeqNoStats();
                if (seqNoStats == null) {
                    errorHandler.accept((Exception)new AlreadyClosedException(shardId + " seq_no_stats are missing"));
                    return;
                }
                String historyUUID = (String)commitStats.getUserData().get("history_uuid");
                long globalCheckpoint = seqNoStats.getGlobalCheckpoint();
                long maxSeqNo = seqNoStats.getMaxSeqNo();
                handler.accept(historyUUID, globalCheckpoint, maxSeqNo);
            } else {
                errorHandler.accept((Exception)new ShardNotFoundException(shardId));
            }
        }, errorHandler));
    }

    static interface FollowerStatsInfoHandler {
        public void accept(String var1, long var2, long var4);
    }
}

