/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.core.enrich.EnrichMetadata;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.EnrichPolicyRunner;

public final class EnrichStore {
    private EnrichStore() {
    }

    public static void putPolicy(String name, EnrichPolicy policy, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, Consumer<Exception> handler) {
        assert (clusterService.localNode().isMasterNode());
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name is missing or empty");
        }
        if (policy == null) {
            throw new IllegalArgumentException("policy is missing");
        }
        MetadataCreateIndexService.validateIndexOrAliasName((String)name, (policyName, error) -> new IllegalArgumentException("Invalid policy name [" + policyName + "], " + error));
        if (!name.toLowerCase(Locale.ROOT).equals(name)) {
            throw new IllegalArgumentException("Invalid policy name [" + name + "], must be lowercase");
        }
        Set<String> supportedPolicyTypes = Set.of(EnrichPolicy.SUPPORTED_POLICY_TYPES);
        if (!supportedPolicyTypes.contains(policy.getType())) {
            throw new IllegalArgumentException("unsupported policy type [" + policy.getType() + "], supported types are " + Arrays.toString(EnrichPolicy.SUPPORTED_POLICY_TYPES));
        }
        EnrichPolicy finalPolicy = policy.getElasticsearchVersion() == null ? new EnrichPolicy(policy.getType(), policy.getQuery(), policy.getIndices(), policy.getMatchField(), policy.getEnrichFields(), Version.CURRENT) : policy;
        EnrichStore.updateClusterState(clusterService, handler, current -> {
            for (String indexExpression : finalPolicy.getIndices()) {
                String[] concreteIndices;
                for (String concreteIndex : concreteIndices = indexNameExpressionResolver.concreteIndexNames(current, IndicesOptions.strictExpandOpen(), new String[]{indexExpression})) {
                    IndexMetadata imd = current.getMetadata().index(concreteIndex);
                    assert (imd != null);
                    MappingMetadata mapping = imd.mapping();
                    if (mapping == null) {
                        throw new IllegalArgumentException("source index [" + concreteIndex + "] has no mapping");
                    }
                    Map mappingSource = mapping.getSourceAsMap();
                    EnrichPolicyRunner.validateMappings(name, finalPolicy, concreteIndex, mappingSource);
                }
            }
            Map<String, EnrichPolicy> policies = EnrichStore.getPolicies(current);
            EnrichPolicy existing = policies.putIfAbsent(name, finalPolicy);
            if (existing != null) {
                throw new ResourceAlreadyExistsException("policy [{}] already exists", new Object[]{name});
            }
            return policies;
        });
    }

    public static void deletePolicy(String name, ClusterService clusterService, Consumer<Exception> handler) {
        assert (clusterService.localNode().isMasterNode());
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name is missing or empty");
        }
        EnrichStore.updateClusterState(clusterService, handler, current -> {
            Map<String, EnrichPolicy> policies = EnrichStore.getPolicies(current);
            if (!policies.containsKey(name)) {
                throw new ResourceNotFoundException("policy [{}] not found", new Object[]{name});
            }
            policies.remove(name);
            return policies;
        });
    }

    public static EnrichPolicy getPolicy(String name, ClusterState state) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("name is missing or empty");
        }
        return EnrichStore.getPolicies(state).get(name);
    }

    public static Map<String, EnrichPolicy> getPolicies(ClusterState state) {
        EnrichMetadata enrichMetadata = (EnrichMetadata)state.metadata().custom("enrich");
        HashMap<String, Object> policies = enrichMetadata != null ? new HashMap(enrichMetadata.getPolicies()) : new HashMap<String, EnrichPolicy>();
        return policies;
    }

    private static void updateClusterState(ClusterService clusterService, final Consumer<Exception> handler, final Function<ClusterState, Map<String, EnrichPolicy>> function) {
        EnrichStore.submitUnbatchedTask(clusterService, "update-enrich-metadata", new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                Map policies = (Map)function.apply(currentState);
                Metadata metadata = Metadata.builder((Metadata)currentState.metadata()).putCustom("enrich", (Metadata.Custom)new EnrichMetadata(policies)).build();
                return ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                handler.accept(null);
            }

            public void onFailure(Exception e) {
                handler.accept(e);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private static void submitUnbatchedTask(ClusterService clusterService, String source, ClusterStateUpdateTask task) {
        clusterService.submitUnbatchedStateUpdateTask(source, task);
    }
}

