/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.Index;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.enrich.EnrichCache;
import org.elasticsearch.xpack.enrich.GeoMatchProcessor;
import org.elasticsearch.xpack.enrich.MatchProcessor;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorProxyAction;

final class EnrichProcessorFactory
implements Processor.Factory,
Consumer<ClusterState> {
    static final String TYPE = "enrich";
    private final Client client;
    private final ScriptService scriptService;
    private final EnrichCache enrichCache;
    volatile Metadata metadata;

    EnrichProcessorFactory(Client client, ScriptService scriptService, EnrichCache enrichCache) {
        this.client = client;
        this.scriptService = scriptService;
        this.enrichCache = Objects.requireNonNull(enrichCache);
    }

    public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
        String policyName = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"policy_name");
        String policyAlias = EnrichPolicy.getBaseName((String)policyName);
        if (this.metadata == null) {
            throw new IllegalStateException("enrich processor factory has not yet been initialized with cluster state");
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.metadata.getIndicesLookup().get(policyAlias);
        if (indexAbstraction == null) {
            throw new IllegalArgumentException("no enrich index exists for policy with name [" + policyName + "]");
        }
        assert (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS);
        assert (indexAbstraction.getIndices().size() == 1);
        IndexMetadata imd = this.metadata.index((Index)indexAbstraction.getIndices().get(0));
        Map mappingAsMap = imd.mapping().sourceAsMap();
        String policyType = (String)XContentMapValues.extractValue((String)"_meta.enrich_policy_type", (Map)mappingAsMap);
        String matchField = (String)XContentMapValues.extractValue((String)"_meta.enrich_match_field", (Map)mappingAsMap);
        TemplateScript.Factory field = ConfigurationUtils.readTemplateProperty((String)TYPE, (String)tag, config, (String)"field", (ScriptService)this.scriptService);
        boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)TYPE, (String)tag, config, (String)"ignore_missing", (boolean)false);
        boolean overrideEnabled = ConfigurationUtils.readBooleanProperty((String)TYPE, (String)tag, config, (String)"override", (boolean)true);
        TemplateScript.Factory targetField = ConfigurationUtils.readTemplateProperty((String)TYPE, (String)tag, config, (String)"target_field", (ScriptService)this.scriptService);
        int maxMatches = ConfigurationUtils.readIntProperty((String)TYPE, (String)tag, config, (String)"max_matches", (Integer)1);
        if (maxMatches < 1 || maxMatches > 128) {
            throw ConfigurationUtils.newConfigurationException((String)TYPE, (String)tag, (String)"max_matches", (String)"should be between 1 and 128");
        }
        BiConsumer<SearchRequest, BiConsumer<List<Map<?, ?>>, Exception>> searchRunner = EnrichProcessorFactory.createSearchRunner(this.client, this.enrichCache);
        switch (policyType) {
            case "match": 
            case "range": {
                return new MatchProcessor(tag, description, searchRunner, policyName, field, targetField, overrideEnabled, ignoreMissing, matchField, maxMatches);
            }
            case "geo_match": {
                String relationStr = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"shape_relation", (String)"intersects");
                ShapeRelation shapeRelation = ShapeRelation.getRelationByName((String)relationStr);
                String orientationStr = ConfigurationUtils.readStringProperty((String)TYPE, (String)tag, config, (String)"orientation", (String)"CCW");
                Orientation orientation = Orientation.fromString((String)orientationStr);
                return new GeoMatchProcessor(tag, description, searchRunner, policyName, field, targetField, overrideEnabled, ignoreMissing, matchField, maxMatches, shapeRelation, orientation);
            }
        }
        throw new IllegalArgumentException("unsupported policy type [" + policyType + "]");
    }

    @Override
    public void accept(ClusterState state) {
        this.metadata = state.getMetadata();
        this.enrichCache.setMetadata(this.metadata);
    }

    private static BiConsumer<SearchRequest, BiConsumer<List<Map<?, ?>>, Exception>> createSearchRunner(Client client, EnrichCache enrichCache) {
        OriginSettingClient originClient = new OriginSettingClient(client, TYPE);
        return (arg_0, arg_1) -> EnrichProcessorFactory.lambda$createSearchRunner$2(enrichCache, (Client)originClient, arg_0, arg_1);
    }

    private static /* synthetic */ void lambda$createSearchRunner$2(EnrichCache enrichCache, Client originClient, SearchRequest req, BiConsumer handler) {
        List<Map<?, ?>> response = enrichCache.get(req);
        if (response != null) {
            handler.accept(response, null);
        } else {
            originClient.execute((ActionType)EnrichCoordinatorProxyAction.INSTANCE, (ActionRequest)req, ActionListener.wrap(resp -> {
                List<Map<?, ?>> value = enrichCache.toCacheValue((SearchResponse)resp);
                enrichCache.put(req, value);
                handler.accept(EnrichCache.deepCopy(value, false), null);
            }, e -> handler.accept(null, e)));
        }
    }
}

