/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestSearchTemplateAction
extends BaseRestHandler {
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    private static final Set<String> RESPONSE_PARAMS = Set.of("typed_keys", "rest_total_hits_as_int");

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_search/template"), new RestHandler.Route(RestRequest.Method.POST, "/_search/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_search/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_search/template"), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/{index}/{type}/_search/template").deprecated("[types removal] Specifying types in search requests is deprecated.", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/{index}/{type}/_search/template").deprecated("[types removal] Specifying types in search requests is deprecated.", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest searchTemplateRequest;
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, null, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), size -> searchRequest.source().size(size));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            searchTemplateRequest = SearchTemplateRequest.fromXContent(parser);
        }
        searchTemplateRequest.setRequest(searchRequest);
        if (searchRequest.source().explain() != null) {
            searchTemplateRequest.setExplain(searchRequest.source().explain());
        }
        return channel -> client.execute((ActionType)SearchTemplateAction.INSTANCE, (ActionRequest)searchTemplateRequest, (ActionListener)new RestToXContentListener(channel, SearchTemplateResponse::status));
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

