/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.CustomMustacheFactory;

public final class MustacheScriptEngine
implements ScriptEngine {
    private static final Logger logger = LogManager.getLogger(MustacheScriptEngine.class);
    public static final String NAME = "mustache";

    public <T> T compile(String templateName, String templateSource, ScriptContext<T> context, Map<String, String> options) {
        if (!context.instanceClazz.equals(TemplateScript.class)) {
            throw new IllegalArgumentException("mustache engine does not know how to handle context [" + context.name + "]");
        }
        CustomMustacheFactory factory = this.createMustacheFactory(options);
        StringReader reader = new StringReader(templateSource);
        try {
            Mustache template = factory.compile(reader, "query-template");
            TemplateScript.Factory compiled = params -> new MustacheExecutableScript(template, params);
            return context.factoryClazz.cast(compiled);
        }
        catch (MustacheException ex) {
            throw new ScriptException(ex.getMessage(), (Throwable)ex, Collections.emptyList(), templateSource, NAME);
        }
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Set.of(TemplateScript.CONTEXT, TemplateScript.INGEST_CONTEXT);
    }

    private CustomMustacheFactory createMustacheFactory(Map<String, String> options) {
        if (options == null || options.isEmpty() || !options.containsKey("content_type")) {
            return new CustomMustacheFactory();
        }
        return new CustomMustacheFactory(options.get("content_type"));
    }

    public String getType() {
        return NAME;
    }

    private class MustacheExecutableScript
    extends TemplateScript {
        private Mustache template;
        private Map<String, Object> params;

        MustacheExecutableScript(Mustache template, Map<String, Object> params) {
            super(params);
            this.template = template;
            this.params = params;
        }

        public String execute() {
            StringWriter writer = new StringWriter();
            try {
                this.template.execute((Writer)writer, this.params);
            }
            catch (Exception e) {
                logger.error(() -> Strings.format((String)"Error running %s", (Object[])new Object[]{this.template}), (Throwable)e);
                throw new GeneralScriptException("Error running " + this.template, (Throwable)e);
            }
            return writer.toString();
        }
    }
}

