/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.Strings;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.Times;

public class DayTimes
implements Times {
    public static final DayTimes NOON = new DayTimes("noon", new int[]{12}, new int[]{0});
    public static final DayTimes MIDNIGHT = new DayTimes("midnight", new int[]{0}, new int[]{0});
    final int[] hour;
    final int[] minute;
    final String time;

    public DayTimes() {
        this(0, 0);
    }

    public DayTimes(int hour, int minute) {
        this(new int[]{hour}, new int[]{minute});
    }

    public DayTimes(int[] hour, int[] minute) {
        this(null, hour, minute);
    }

    DayTimes(String time, int[] hour, int[] minute) {
        this.time = time;
        this.hour = hour;
        this.minute = minute;
        this.validate();
    }

    public int[] hour() {
        return this.hour;
    }

    public int[] minute() {
        return this.minute;
    }

    public String time() {
        return this.time;
    }

    public static DayTimes parse(String time) throws ElasticsearchParseException {
        int[] minute;
        int[] hour;
        if (DayTimes.NOON.time.equals(time)) {
            return NOON;
        }
        if (DayTimes.MIDNIGHT.time.equals(time)) {
            return MIDNIGHT;
        }
        int i = time.indexOf(":");
        if (i < 0) {
            throw new ElasticsearchParseException("could not parse time [{}]. time format must be in the form of hh:mm", new Object[]{time});
        }
        if (i == time.length() - 1 || time.indexOf(":", i + 1) >= 0) {
            throw new ElasticsearchParseException("could not parse time [{}]. time format must be in the form of hh:mm", new Object[]{time});
        }
        String hrStr = time.substring(0, i);
        String minStr = time.substring(i + 1);
        if (hrStr.length() != 1 && hrStr.length() != 2) {
            throw new ElasticsearchParseException("could not parse time [{}]. time format must be in the form of hh:mm", new Object[]{time});
        }
        if (minStr.length() != 2) {
            throw new ElasticsearchParseException("could not parse time [{}]. time format must be in the form of hh:mm", new Object[]{time});
        }
        try {
            hour = new int[]{Integer.parseInt(hrStr)};
        }
        catch (NumberFormatException nfe) {
            throw new ElasticsearchParseException("could not parse time [{}]. time hour [{}] is not a number", new Object[]{time, hrStr});
        }
        try {
            minute = new int[]{Integer.parseInt(minStr)};
        }
        catch (NumberFormatException nfe) {
            throw new ElasticsearchParseException("could not parse time [{}]. time minute [{}] is not a number", new Object[]{time, minStr});
        }
        try {
            return new DayTimes(time, hour, minute);
        }
        catch (IllegalArgumentException iae) {
            throw new ElasticsearchParseException("could not parse time [{}]", (Throwable)iae, new Object[0]);
        }
    }

    public void validate() {
        int i;
        for (i = 0; i < this.hour.length; ++i) {
            if (DayTimes.validHour(this.hour[i])) continue;
            throw Exceptions.illegalArgument((String)"invalid time [{}]. invalid time hour value [{}]. time hours must be between 0 and 23 incl.", (Object[])new Object[]{this, this.hour[i]});
        }
        for (i = 0; i < this.minute.length; ++i) {
            if (DayTimes.validMinute(this.minute[i])) continue;
            throw Exceptions.illegalArgument((String)"invalid time [{}]. invalid time minute value [{}]. time minutes must be between 0 and 59 incl.", (Object[])new Object[]{this, this.minute[i]});
        }
    }

    static boolean validHour(int hour) {
        return hour >= 0 && hour < 24;
    }

    static boolean validMinute(int minute) {
        return minute >= 0 && minute < 60;
    }

    public String cron() {
        String hrs = Strings.join(",", this.hour);
        String mins = Strings.join(",", this.minute);
        return "0 " + mins + " " + hrs + " * * ?";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.time != null) {
            return builder.value(this.time);
        }
        return builder.startObject().array(HOUR_FIELD.getPreferredName(), this.hour).array(MINUTE_FIELD.getPreferredName(), this.minute).endObject();
    }

    public String toString() {
        if (this.time != null) {
            return this.time;
        }
        StringBuilder sb = new StringBuilder();
        for (int h = 0; h < this.hour.length; ++h) {
            for (int m = 0; m < this.minute.length; ++m) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (this.hour[h] < 10) {
                    sb.append("0");
                }
                sb.append(this.hour[h]).append(":");
                if (this.minute[m] < 10) {
                    sb.append("0");
                }
                sb.append(this.minute[m]);
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DayTimes time = (DayTimes)o;
        if (!Arrays.equals(this.hour, time.hour)) {
            return false;
        }
        return Arrays.equals(this.minute, time.minute);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.hour);
        result = 31 * result + Arrays.hashCode(this.minute);
        return result;
    }

    public static DayTimes parse(XContentParser parser, XContentParser.Token token) throws IOException, ElasticsearchParseException {
        if (token == XContentParser.Token.VALUE_STRING) {
            return DayTimes.parse(parser.text());
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse time. expected string/number value or an object, but found [{}]", new Object[]{token});
        }
        ArrayList<Integer> hours = new ArrayList<Integer>();
        ArrayList<Integer> minutes = new ArrayList<Integer>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (HOUR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token.isValue()) {
                    hours.add(DayTimes.parseHourValue(parser, token));
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        hours.add(DayTimes.parseHourValue(parser, token));
                    }
                    continue;
                }
                throw new ElasticsearchParseException("invalid time hour value. expected string/number value or an array of string/number values, but found [{}]", new Object[]{token});
            }
            if (!MINUTE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
            if (token.isValue()) {
                minutes.add(DayTimes.parseMinuteValue(parser, token));
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    minutes.add(DayTimes.parseMinuteValue(parser, token));
                }
                continue;
            }
            throw new ElasticsearchParseException("invalid time minute value. expected string/number value or an array of string/number values, but found [{}]", new Object[]{token});
        }
        if (hours.isEmpty()) {
            hours.add(0);
        }
        if (minutes.isEmpty()) {
            minutes.add(0);
        }
        return new DayTimes(CollectionUtils.toArray(hours), CollectionUtils.toArray(minutes));
    }

    public static int parseHourValue(XContentParser parser, XContentParser.Token token) throws IOException, ElasticsearchParseException {
        int n;
        switch (token) {
            case VALUE_NUMBER: {
                int n2;
                int hour = parser.intValue();
                if (!DayTimes.validHour(hour)) {
                    throw new ElasticsearchParseException("invalid time hour value [{}] (possible values may be between 0 and 23 incl.)", new Object[]{hour});
                }
                n = n2 = hour;
                break;
            }
            case VALUE_STRING: {
                String value = parser.text();
                try {
                    int n3;
                    int hour = Integer.parseInt(value);
                    if (!DayTimes.validHour(hour)) {
                        String msg = "invalid time hour value [{}] (possible values may be between 0 and 23 incl.)";
                        throw new ElasticsearchParseException(msg, new Object[]{hour});
                    }
                    n = n3 = hour;
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ElasticsearchParseException("invalid time hour value [{}]", new Object[]{value});
                }
            }
            default: {
                throw new ElasticsearchParseException("invalid hour value. expected string/number value, but found [{}]", new Object[]{token});
            }
        }
        return n;
    }

    public static int parseMinuteValue(XContentParser parser, XContentParser.Token token) throws IOException, ElasticsearchParseException {
        int n;
        switch (token) {
            case VALUE_NUMBER: {
                int n2;
                int minute = parser.intValue();
                if (!DayTimes.validMinute(minute)) {
                    throw new ElasticsearchParseException("invalid time minute value [{}] (possible values may be between 0 and 59 incl.)", new Object[]{minute});
                }
                n = n2 = minute;
                break;
            }
            case VALUE_STRING: {
                String value = parser.text();
                try {
                    int n3;
                    int minute = Integer.parseInt(value);
                    if (!DayTimes.validMinute(minute)) {
                        throw new ElasticsearchParseException("invalid time minute value [{}] (possible values may be between 0 and 59 incl.)", new Object[]{minute});
                    }
                    n = n3 = minute;
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ElasticsearchParseException("invalid time minute value [{}]", new Object[]{value});
                }
            }
            default: {
                throw new ElasticsearchParseException("invalid time minute value. expected string/number value, but found [{}]", new Object[]{token});
            }
        }
        return n;
    }
}

