/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapper;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.watcher.ClockHolder;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class TransportAckWatchAction
extends WatcherTransportAction<AckWatchRequest, AckWatchResponse> {
    private final Clock clock;
    private final WatchParser parser;
    private final Client client;

    @Inject
    public TransportAckWatchAction(TransportService transportService, ActionFilters actionFilters, ClockHolder clockHolder, XPackLicenseState licenseState, WatchParser parser, Client client) {
        super("cluster:admin/xpack/watcher/watch/ack", transportService, actionFilters, licenseState, AckWatchRequest::new);
        this.clock = clockHolder.clock;
        this.parser = parser;
        this.client = client;
    }

    @Override
    protected void doExecute(AckWatchRequest request, ActionListener<AckWatchResponse> listener) {
        WatcherStatsRequest watcherStatsRequest = new WatcherStatsRequest();
        watcherStatsRequest.includeCurrentWatches(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"watcher", (ActionType)WatcherStatsAction.INSTANCE, (ActionRequest)watcherStatsRequest, (ActionListener)ActionListener.wrap(response -> {
            boolean isWatchRunning = response.getNodes().stream().anyMatch(node -> node.getSnapshots().stream().anyMatch(snapshot -> snapshot.watchId().equals(request.getWatchId())));
            if (isWatchRunning) {
                listener.onFailure((Exception)new ElasticsearchStatusException("watch[{}] is running currently, cannot ack until finished", RestStatus.CONFLICT, new Object[]{request.getWatchId()}));
            } else {
                GetRequest getRequest = new GetRequest(".watches", request.getWatchId()).preference(Preference.LOCAL.type()).realtime(true);
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
                    if (!getResponse.isExists()) {
                        listener.onFailure((Exception)new ResourceNotFoundException("Watch with id [{}] does not exist", new Object[]{request.getWatchId()}));
                    } else {
                        boolean isChanged;
                        ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
                        Watch watch = this.parser.parseWithSecrets(request.getWatchId(), true, getResponse.getSourceAsBytesRef(), now, XContentType.JSON, getResponse.getSeqNo(), getResponse.getPrimaryTerm());
                        watch.status().version(getResponse.getVersion());
                        String[] actionIds = request.getActionIds();
                        if (actionIds == null || actionIds.length == 0) {
                            actionIds = new String[]{"_all"};
                        }
                        if (!(isChanged = watch.ack(now, actionIds))) {
                            listener.onResponse((Object)new AckWatchResponse(watch.status()));
                            return;
                        }
                        UpdateRequest updateRequest = new UpdateRequest(".watches", request.getWatchId());
                        updateRequest.setIfSeqNo(getResponse.getSeqNo());
                        updateRequest.setIfPrimaryTerm(getResponse.getPrimaryTerm());
                        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                        XContentBuilder builder = XContentFactory.jsonBuilder();
                        builder.startObject().startObject(WatchField.STATUS.getPreferredName()).startObject("actions");
                        List<String> actionIdsAsList = Arrays.asList(actionIds);
                        boolean updateAll = actionIdsAsList.contains("_all");
                        for (ActionWrapper actionWrapper : watch.actions()) {
                            if (!updateAll && !actionIdsAsList.contains(actionWrapper.id())) continue;
                            builder.startObject(actionWrapper.id()).field("ack", (ToXContent)watch.status().actionStatus(actionWrapper.id()).ackStatus(), ToXContent.EMPTY_PARAMS).endObject();
                        }
                        builder.endObject().endObject().endObject();
                        updateRequest.doc(builder);
                        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(updateResponse -> listener.onResponse((Object)new AckWatchResponse(watch.status())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

