/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.slack;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.common.http.HttpRequest;
import org.elasticsearch.xpack.watcher.common.http.HttpResponse;
import org.elasticsearch.xpack.watcher.notification.slack.message.SlackMessage;

public class SentMessages
implements ToXContentObject,
Iterable<SentMessage> {
    private static final ParseField ACCOUNT = new ParseField("account", new String[0]);
    private static final ParseField SENT_MESSAGES = new ParseField("sent_messages", new String[0]);
    private String accountName;
    private List<SentMessage> messages;

    public SentMessages(String accountName, List<SentMessage> messages) {
        this.accountName = accountName;
        this.messages = messages;
    }

    public String getAccountName() {
        return this.accountName;
    }

    @Override
    public Iterator<SentMessage> iterator() {
        return this.messages.iterator();
    }

    public int count() {
        return this.messages.size();
    }

    public List<SentMessage> asList() {
        return Collections.unmodifiableList(this.messages);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACCOUNT.getPreferredName(), this.accountName);
        builder.startArray(SENT_MESSAGES.getPreferredName());
        for (SentMessage message : this.messages) {
            message.toXContent(builder, params);
        }
        builder.endArray();
        return builder.endObject();
    }

    public static class SentMessage
    implements ToXContentObject {
        private static final ParseField STATUS = new ParseField("status", new String[0]);
        private static final ParseField REQUEST = new ParseField("request", new String[0]);
        private static final ParseField RESPONSE = new ParseField("response", new String[0]);
        private static final ParseField TO = new ParseField("to", new String[0]);
        private static final ParseField MESSAGE = new ParseField("message", new String[0]);
        final String to;
        final SlackMessage message;
        @Nullable
        final HttpRequest request;
        @Nullable
        final HttpResponse response;
        @Nullable
        final Exception exception;

        public static SentMessage responded(String to, SlackMessage message, HttpRequest request, HttpResponse response) {
            return new SentMessage(to, message, request, response, null);
        }

        public static SentMessage error(String to, SlackMessage message, Exception e) {
            return new SentMessage(to, message, null, null, e);
        }

        private SentMessage(String to, SlackMessage message, HttpRequest request, HttpResponse response, Exception exception) {
            this.to = to;
            this.message = message;
            this.request = request;
            this.response = response;
            this.exception = exception;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isSuccess() {
            return this.response != null && this.response.status() >= 200 && this.response.status() < 300;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(STATUS.getPreferredName(), this.isSuccess() ? "success" : "failure");
            if (!this.isSuccess()) {
                if (this.request != null) {
                    if (WatcherParams.hideSecrets((ToXContent.Params)params)) {
                        try (InputStream is = HttpRequest.filterToXContent(this.request, builder.contentType(), params, "path");){
                            builder.rawField(REQUEST.getPreferredName(), is, builder.contentType());
                        }
                    } else {
                        builder.field(REQUEST.getPreferredName());
                        this.request.toXContent(builder, params);
                    }
                }
                if (this.response != null) {
                    builder.field(RESPONSE.getPreferredName());
                    this.response.toXContent(builder, params);
                }
                if (this.exception != null) {
                    ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.exception, (boolean)true);
                }
            }
            if (this.to != null) {
                builder.field(TO.getPreferredName(), this.to);
            }
            builder.field(MESSAGE.getPreferredName());
            this.message.toXContent(builder, params, false);
            return builder.endObject();
        }
    }
}

