/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.common.http.BasicAuth;
import org.elasticsearch.xpack.watcher.common.http.HttpMethod;
import org.elasticsearch.xpack.watcher.common.http.HttpProxy;
import org.elasticsearch.xpack.watcher.common.http.Scheme;

public class HttpRequest
implements ToXContentObject {
    final String host;
    final int port;
    final Scheme scheme;
    final HttpMethod method;
    @Nullable
    final String path;
    final Map<String, String> params;
    final Map<String, String> headers;
    @Nullable
    final BasicAuth auth;
    @Nullable
    final String body;
    @Nullable
    final TimeValue connectionTimeout;
    @Nullable
    final TimeValue readTimeout;
    @Nullable
    final HttpProxy proxy;

    public HttpRequest(String host, int port, @Nullable Scheme scheme, @Nullable HttpMethod method, @Nullable String path, @Nullable Map<String, String> params, @Nullable Map<String, String> headers, @Nullable BasicAuth auth, @Nullable String body, @Nullable TimeValue connectionTimeout, @Nullable TimeValue readTimeout, @Nullable HttpProxy proxy) {
        this.host = host;
        this.port = port;
        this.scheme = scheme != null ? scheme : Scheme.HTTP;
        this.method = method != null ? method : HttpMethod.GET;
        this.path = path;
        this.params = params != null ? params : Collections.emptyMap();
        this.headers = headers != null ? headers : Collections.emptyMap();
        this.auth = auth;
        this.body = body;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public HttpMethod method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public BasicAuth auth() {
        return this.auth;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String body() {
        return this.body;
    }

    public TimeValue connectionTimeout() {
        return this.connectionTimeout;
    }

    public TimeValue readTimeout() {
        return this.readTimeout;
    }

    public HttpProxy proxy() {
        return this.proxy;
    }

    public static String encodeUrl(String text) {
        return URLEncoder.encode(text, StandardCharsets.UTF_8);
    }

    public static String decodeUrl(String text) {
        return URLDecoder.decode(text, StandardCharsets.UTF_8);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params toXContentParams) throws IOException {
        builder.startObject();
        builder.field(Field.HOST.getPreferredName(), this.host);
        builder.field(Field.PORT.getPreferredName(), this.port);
        builder.field(Field.SCHEME.getPreferredName(), this.scheme.value());
        builder.field(Field.METHOD.getPreferredName(), this.method.value());
        if (this.path != null) {
            builder.field(Field.PATH.getPreferredName(), this.path);
        }
        if (!this.params.isEmpty()) {
            builder.field(Field.PARAMS.getPreferredName(), this.params);
        }
        if (!this.headers.isEmpty()) {
            if (WatcherParams.hideSecrets((ToXContent.Params)toXContentParams)) {
                builder.field(Field.HEADERS.getPreferredName(), this.sanitizeHeaders(this.headers));
            } else {
                builder.field(Field.HEADERS.getPreferredName(), this.sanitizeInternalHeaders(this.headers));
            }
        }
        if (this.auth != null) {
            builder.startObject(Field.AUTH.getPreferredName()).field("basic", (ToXContent)this.auth, toXContentParams).endObject();
        }
        if (this.body != null) {
            builder.field(Field.BODY.getPreferredName(), this.body);
        }
        if (this.connectionTimeout != null) {
            builder.humanReadableField(Field.CONNECTION_TIMEOUT.getPreferredName(), Field.CONNECTION_TIMEOUT_HUMAN.getPreferredName(), (Object)this.connectionTimeout);
        }
        if (this.readTimeout != null) {
            builder.humanReadableField(Field.READ_TIMEOUT.getPreferredName(), Field.READ_TIMEOUT_HUMAN.getPreferredName(), (Object)this.readTimeout);
        }
        if (this.proxy != null) {
            this.proxy.toXContent(builder, toXContentParams);
        }
        return builder.endObject();
    }

    private Map<String, String> sanitizeHeaders(Map<String, String> headers) {
        String authorizationHeader;
        String string = authorizationHeader = headers.containsKey("Authorization") ? "Authorization" : null;
        if (authorizationHeader == null) {
            String string2 = authorizationHeader = headers.containsKey("authorization") ? "authorization" : null;
        }
        if (authorizationHeader == null) {
            return headers;
        }
        HashMap<String, String> sanitizedHeaders = new HashMap<String, String>(headers);
        sanitizedHeaders.put(authorizationHeader, "::es_redacted::");
        return this.sanitizeInternalHeaders(sanitizedHeaders);
    }

    private Map<String, String> sanitizeInternalHeaders(Map<String, String> headers) {
        if (headers.containsKey("X-Elastic-App-Auth")) {
            HashMap<String, String> sanitizedHeaders = new HashMap<String, String>(headers);
            sanitizedHeaders.put("X-Elastic-App-Auth", "::es_redacted::");
            return sanitizedHeaders;
        }
        return headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && this.scheme == that.scheme && this.method == that.method && Objects.equals(this.path, that.path) && Objects.equals(this.params, that.params) && Objects.equals(this.headers, that.headers) && Objects.equals(this.auth, that.auth) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.scheme, this.method, this.path, this.params, this.headers, this.auth, this.connectionTimeout, this.readTimeout, this.body, this.proxy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("method=[").append((Object)this.method).append("], ");
        sb.append("scheme=[").append((Object)this.scheme).append("], ");
        sb.append("host=[").append(this.host).append("], ");
        sb.append("port=[").append(this.port).append("], ");
        sb.append("path=[").append(this.path).append("], ");
        if (!this.headers.isEmpty()) {
            sb.append(this.sanitizeHeaders(this.headers).entrySet().stream().map(header -> (String)header.getKey() + ": " + (String)header.getValue()).collect(Collectors.joining(", ", "headers=[", "], ")));
        }
        if (this.auth != null) {
            sb.append("auth=[").append("basic").append("], ");
        }
        sb.append("connection_timeout=[").append(this.connectionTimeout).append("], ");
        sb.append("read_timeout=[").append(this.readTimeout).append("], ");
        if (this.proxy != null) {
            sb.append("proxy=[").append(this.proxy).append("], ");
        }
        sb.append("body=[").append(this.body).append("], ");
        return sb.toString();
    }

    public static Builder builder(String host, int port) {
        return new Builder(host, port);
    }

    public Builder copy() {
        return new Builder(this);
    }

    static Builder builder() {
        return new Builder();
    }

    public static InputStream filterToXContent(HttpRequest request, XContentType xContentType, ToXContent.Params params, String excludeField) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ByteArrayInputStream byteArrayInputStream;
            try (XContentBuilder filteredBuilder = new XContentBuilder(xContentType.xContent(), (OutputStream)bos, Collections.emptySet(), Collections.singleton(excludeField), xContentType.toParsedMediaType());){
                request.toXContent(filteredBuilder, params);
                filteredBuilder.flush();
                byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            }
            return byteArrayInputStream;
        }
    }

    public static interface Field {
        public static final ParseField SCHEME = new ParseField("scheme", new String[0]);
        public static final ParseField HOST = new ParseField("host", new String[0]);
        public static final ParseField PORT = new ParseField("port", new String[0]);
        public static final ParseField METHOD = new ParseField("method", new String[0]);
        public static final ParseField PATH = new ParseField("path", new String[0]);
        public static final ParseField PARAMS = new ParseField("params", new String[0]);
        public static final ParseField HEADERS = new ParseField("headers", new String[0]);
        public static final ParseField AUTH = new ParseField("auth", new String[0]);
        public static final ParseField BODY = new ParseField("body", new String[0]);
        public static final ParseField CONNECTION_TIMEOUT = new ParseField("connection_timeout_in_millis", new String[0]);
        public static final ParseField CONNECTION_TIMEOUT_HUMAN = new ParseField("connection_timeout", new String[0]);
        public static final ParseField READ_TIMEOUT = new ParseField("read_timeout_millis", new String[0]);
        public static final ParseField READ_TIMEOUT_HUMAN = new ParseField("read_timeout", new String[0]);
        public static final ParseField PROXY = new ParseField("proxy", new String[0]);
        public static final ParseField URL = new ParseField("url", new String[0]);
    }

    public static class Builder {
        private String host;
        private int port = -1;
        private Scheme scheme;
        private HttpMethod method;
        private String path;
        private Map<String, String> params = new HashMap<String, String>();
        private Map<String, String> headers = new HashMap<String, String>();
        private BasicAuth auth;
        private String body;
        private TimeValue connectionTimeout;
        private TimeValue readTimeout;
        private HttpProxy proxy;

        private Builder(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private Builder(HttpRequest original) {
            this.host = original.host;
            this.port = original.port;
            this.scheme = original.scheme;
            this.method = original.method;
            this.path = original.path;
            this.params = new HashMap<String, String>(original.params);
            this.headers = new HashMap<String, String>(original.headers);
            this.auth = original.auth;
            this.body = original.body;
            this.connectionTimeout = original.connectionTimeout;
            this.readTimeout = original.readTimeout;
            this.proxy = original.proxy;
        }

        private Builder() {
        }

        public Builder scheme(Scheme scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            if (this.params == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.params.putAll(params);
            return this;
        }

        public Builder setParam(String key, String value) {
            if (this.params == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.params.put(key, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            if (this.headers == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.headers.putAll(headers);
            return this;
        }

        public Builder setHeader(String key, String value) {
            if (this.headers == null) {
                throw new IllegalStateException("Request has already been built!");
            }
            this.headers.put(key, value);
            return this;
        }

        public Builder auth(BasicAuth auth) {
            this.auth = auth;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder jsonBody(ToXContent xContent) {
            return this.body(Strings.toString((ToXContent)xContent)).setHeader("Content-Type", XContentType.JSON.mediaType());
        }

        public Builder connectionTimeout(TimeValue timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public Builder readTimeout(TimeValue timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Builder proxy(HttpProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public HttpRequest build() {
            HttpRequest request = new HttpRequest(this.host, this.port, this.scheme, this.method, this.path, Collections.unmodifiableMap(this.params), Collections.unmodifiableMap(this.headers), this.auth, this.body, this.connectionTimeout, this.readTimeout, this.proxy);
            this.params = null;
            this.headers = null;
            return request;
        }

        public Builder fromUrl(String supposedUrl) {
            if (!Strings.hasLength((String)supposedUrl)) {
                throw new ElasticsearchParseException("Configured URL is empty, please configure a valid URL", new Object[0]);
            }
            try {
                String rawQuery;
                URI uri = new URI(supposedUrl);
                if (!Strings.hasLength((String)uri.getScheme())) {
                    throw new ElasticsearchParseException("URL [{}] does not contain a scheme", new Object[]{uri});
                }
                this.scheme = Scheme.parse(uri.getScheme());
                this.port = uri.getPort() > 0 ? uri.getPort() : this.scheme.defaultPort();
                this.host = uri.getHost();
                if (Strings.hasLength((String)uri.getRawPath())) {
                    this.path = uri.getRawPath();
                }
                if (Strings.hasLength((String)(rawQuery = uri.getRawQuery()))) {
                    RestUtils.decodeQueryString((String)rawQuery, (int)0, this.params);
                }
            }
            catch (URISyntaxException e) {
                throw new ElasticsearchParseException("Malformed URL [{}]", new Object[]{supposedUrl});
            }
            return this;
        }
    }

    public static class Parser {
        public static HttpRequest parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Field.PROXY.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        builder.proxy(HttpProxy.parse(parser));
                        continue;
                    }
                    catch (Exception e) {
                        throw new ElasticsearchParseException("could not parse http request. could not parse [{}] field", new Object[]{currentFieldName});
                    }
                }
                if (Field.AUTH.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.auth(BasicAuth.parse(parser));
                    continue;
                }
                if (Field.CONNECTION_TIMEOUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.connectionTimeout(TimeValue.timeValueMillis((long)parser.longValue()));
                    continue;
                }
                if (Field.CONNECTION_TIMEOUT_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        builder.connectionTimeout(WatcherDateTimeUtils.parseTimeValue((XContentParser)parser, (String)Field.CONNECTION_TIMEOUT.toString()));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse http request template. invalid time value for [{}] field", (Throwable)pe, new Object[]{currentFieldName});
                    }
                }
                if (Field.READ_TIMEOUT.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.readTimeout(TimeValue.timeValueMillis((long)parser.longValue()));
                    continue;
                }
                if (Field.READ_TIMEOUT_HUMAN.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        builder.readTimeout(WatcherDateTimeUtils.parseTimeValue((XContentParser)parser, (String)Field.READ_TIMEOUT.toString()));
                        continue;
                    }
                    catch (ElasticsearchParseException pe) {
                        throw new ElasticsearchParseException("could not parse http request template. invalid time value for [{}] field", (Throwable)pe, new Object[]{currentFieldName});
                    }
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    Map headers = WatcherUtils.flattenModel((Map)parser.map());
                    if (Field.HEADERS.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setHeaders(headers);
                        continue;
                    }
                    if (Field.PARAMS.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.setParams(headers);
                        continue;
                    }
                    if (Field.BODY.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.body(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request. unexpected object field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if (Field.SCHEME.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.scheme(Scheme.parse(parser.text()));
                        continue;
                    }
                    if (Field.METHOD.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.method(HttpMethod.parse(parser.text()));
                        continue;
                    }
                    if (Field.HOST.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.host = parser.text();
                        continue;
                    }
                    if (Field.PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.path(parser.text());
                        continue;
                    }
                    if (Field.BODY.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.body(parser.text());
                        continue;
                    }
                    if (Field.URL.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.fromUrl(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request. unexpected string field [{}]", new Object[]{currentFieldName});
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (Field.PORT.match(currentFieldName, parser.getDeprecationHandler())) {
                        builder.port = parser.intValue();
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse http request. unexpected numeric field [{}]", new Object[]{currentFieldName});
                }
                throw new ElasticsearchParseException("could not parse http request. unexpected token [{}]", new Object[]{token});
            }
            if (builder.host == null) {
                throw new ElasticsearchParseException("could not parse http request. missing required [{}] field", new Object[]{Field.HOST.getPreferredName()});
            }
            if (builder.port < 0) {
                throw new ElasticsearchParseException("could not parse http request. missing required [{}] field", new Object[]{Field.PORT.getPreferredName()});
            }
            return builder.build();
        }
    }
}

