/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.sql.rowset.serial.SerialException;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.RemoteFailure;
import org.elasticsearch.xpack.sql.client.StringUtils;
import org.elasticsearch.xpack.sql.client.UriUtils;
import org.elasticsearch.xpack.sql.proto.core.CheckedBiFunction;
import org.elasticsearch.xpack.sql.proto.core.CheckedConsumer;

public class JreHttpUrlConnection
implements Closeable {
    public static final String SQL_STATE_BAD_SERVER = "bad_server";
    private static final String SQL_NOT_AVAILABLE_ERROR_MESSAGE = "Incorrect HTTP method for uri [/_sql?error_trace] and method [POST], allowed:";
    private boolean closed = false;
    final HttpURLConnection con;
    private final URL url;
    private static final String GZIP = "gzip";

    public static <R> R http(String path, String query, ConnectionConfiguration cfg, Function<JreHttpUrlConnection, R> handler) {
        URL url;
        URI uriPath = UriUtils.appendSegmentToPath(cfg.baseUri(), path);
        String uriQuery = query == null ? uriPath.getQuery() : query;
        try {
            url = new URI(uriPath.getScheme(), null, uriPath.getHost(), uriPath.getPort(), uriPath.getPath(), uriQuery, uriPath.getFragment()).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new ClientException("Cannot build url using base: [" + uriPath + "] query: [" + query + "] path: [" + path + "]", ex);
        }
        try (JreHttpUrlConnection con = new JreHttpUrlConnection(url, cfg);){
            R r = handler.apply(con);
            return r;
        }
    }

    public JreHttpUrlConnection(URL url, ConnectionConfiguration cfg) throws ClientException {
        this.url = url;
        try {
            Proxy p = cfg.proxyConfig().proxy();
            this.con = (HttpURLConnection)(p != null ? url.openConnection(p) : url.openConnection());
        }
        catch (IOException ex) {
            throw new ClientException("Cannot setup connection to " + url + " (" + ex.getMessage() + ")", ex);
        }
        this.setupConnection(cfg);
    }

    private void setupConnection(ConnectionConfiguration cfg) {
        this.con.setConnectTimeout((int)cfg.connectTimeout());
        this.con.setReadTimeout((int)cfg.networkTimeout());
        this.con.setAllowUserInteraction(false);
        this.con.setUseCaches(false);
        this.con.setRequestProperty("Accept-Charset", "UTF-8");
        this.setupSSL(cfg);
        this.setupBasicAuth(cfg);
    }

    private void setupSSL(ConnectionConfiguration cfg) {
        if (cfg.sslConfig().isEnabled()) {
            HttpsURLConnection https = (HttpsURLConnection)this.con;
            SSLSocketFactory factory = cfg.sslConfig().sslSocketFactory();
            AccessController.doPrivileged(() -> {
                https.setSSLSocketFactory(factory);
                return null;
            });
        }
    }

    private void setupBasicAuth(ConnectionConfiguration cfg) {
        if (StringUtils.hasText(cfg.authUser())) {
            String basicValue = cfg.authUser() + ":" + cfg.authPass();
            String encoded = StringUtils.asUTFString(Base64.getEncoder().encode(StringUtils.toUTF(basicValue)));
            this.con.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    public boolean head() throws ClientException {
        try {
            this.con.setRequestMethod("HEAD");
            int responseCode = this.con.getResponseCode();
            return responseCode == 200;
        }
        catch (IOException ex) {
            throw new ClientException("Cannot HEAD address " + this.url + " (" + ex.getMessage() + ")", ex);
        }
    }

    public <R> ResponseOrException<R> request(CheckedConsumer<OutputStream, IOException> doc, CheckedBiFunction<InputStream, Function<String, List<String>>, R, IOException> parser, String requestMethod) throws ClientException {
        return this.request(doc, parser, requestMethod, "application/json");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <R> ResponseOrException<R> request(CheckedConsumer<OutputStream, IOException> doc, CheckedBiFunction<InputStream, Function<String, List<String>>, R, IOException> parser, String requestMethod, String contentTypeHeader) throws ClientException {
        ResponseOrException responseOrException;
        this.con.setRequestMethod(requestMethod);
        this.con.setDoOutput(true);
        this.con.setRequestProperty("Content-Type", contentTypeHeader);
        this.con.setRequestProperty("Accept", "application/json");
        if (doc != null) {
            try (OutputStream out = this.con.getOutputStream();){
                doc.accept(out);
            }
        }
        if (!this.shouldParseBody(this.con.getResponseCode())) return this.parserError();
        InputStream stream = JreHttpUrlConnection.getStream(this.con, this.con.getInputStream());
        try {
            responseOrException = new ResponseOrException(parser.apply(new BufferedInputStream(stream), this.getHeaderFields(this.con)));
            if (stream == null) return responseOrException;
        }
        catch (Throwable throwable) {
            try {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ClientException("Cannot POST address " + this.url + " (" + ex.getMessage() + ")", ex);
            }
        }
        stream.close();
        return responseOrException;
    }

    private Function<String, List<String>> getHeaderFields(URLConnection con) {
        return header -> {
            LinkedList values = new LinkedList();
            for (Map.Entry<String, List<String>> entry : con.getHeaderFields().entrySet()) {
                if (!header.equalsIgnoreCase(entry.getKey())) continue;
                values.addAll(entry.getValue());
            }
            return values;
        };
    }

    private boolean shouldParseBody(int responseCode) {
        return responseCode == 200 || responseCode == 201 || responseCode == 202;
    }

    private <R> ResponseOrException<R> parserError() throws IOException {
        RemoteFailure failure;
        try (InputStream stream = JreHttpUrlConnection.getStream(this.con, this.con.getErrorStream());){
            failure = RemoteFailure.parseFromResponse(stream);
        }
        if (this.con.getResponseCode() >= 500) {
            return new ResponseOrException(new SQLException("Server encountered an error [" + failure.reason() + "]. [" + failure.remoteTrace() + "]", SQL_STATE_BAD_SERVER));
        }
        SqlExceptionType type = SqlExceptionType.fromRemoteFailureType(failure.type());
        if (type == null) {
            if (this.con.getResponseCode() >= 400 && failure.reason().contains(SQL_NOT_AVAILABLE_ERROR_MESSAGE)) {
                return new ResponseOrException(new SQLException("X-Pack/SQL does not seem to be available on the Elasticsearch node using the access path '" + this.con.getURL().getHost() + (this.con.getURL().getPort() > 0 ? ":" + this.con.getURL().getPort() : "") + "'. Please verify X-Pack is installed and SQL enabled. Alternatively, check if any proxy is interfering the communication to Elasticsearch", SQL_STATE_BAD_SERVER));
            }
            return new ResponseOrException(new SQLException("Server sent bad type [" + failure.type() + "]. Original type was [" + failure.reason() + "]. [" + failure.remoteTrace() + "]", SQL_STATE_BAD_SERVER));
        }
        return new ResponseOrException(type.asException(failure.reason()));
    }

    private static InputStream getStream(HttpURLConnection con, InputStream stream) throws IOException {
        if (GZIP.equals(con.getContentEncoding())) {
            return new GZIPInputStream(stream);
        }
        return stream;
    }

    public void connect() {
        if (this.closed) {
            throw new ClientException("Connection cannot be reused");
        }
        try {
            this.con.connect();
        }
        catch (IOException ex) {
            throw new ClientException("Cannot open connection to " + this.url + " (" + ex.getMessage() + ")", ex);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.consumeStreams();
        }
    }

    public void disconnect() {
        try {
            this.connect();
        }
        finally {
            this.con.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeStreams() {
        try (InputStream in = this.con.getInputStream();){
            while (in != null && in.read() > -1) {
            }
        }
        catch (IOException ein2) {
        }
        finally {
            try (InputStream ein2 = this.con.getErrorStream();){
                while (ein2 != null && ein2.read() > -1) {
                }
            }
            catch (IOException ein2) {}
        }
    }

    public static class ResponseOrException<R> {
        private final R response;
        private final SQLException exception;

        private ResponseOrException(R response) {
            this.response = response;
            this.exception = null;
        }

        private ResponseOrException(SQLException exception) {
            this.response = null;
            this.exception = exception;
        }

        public R getResponseOrThrowException() throws SQLException {
            if (this.exception != null) {
                throw this.exception;
            }
            assert (this.response != null);
            return this.response;
        }
    }

    public static enum SqlExceptionType {
        UNKNOWN(SQLException::new),
        SERIAL(SerialException::new),
        CLIENT_INFO(message -> new SQLClientInfoException((String)message, Collections.emptyMap())),
        DATA(SQLDataException::new),
        SYNTAX(SQLSyntaxErrorException::new),
        RECOVERABLE(SQLRecoverableException::new),
        TIMEOUT(SQLTimeoutException::new),
        SECURITY(SQLInvalidAuthorizationSpecException::new),
        NOT_SUPPORTED(SQLFeatureNotSupportedException::new);

        private final Function<String, SQLException> toException;

        public static SqlExceptionType fromRemoteFailureType(String type) {
            switch (type) {
                case "analysis_exception": 
                case "resource_not_found_exception": 
                case "verification_exception": {
                    return DATA;
                }
                case "planning_exception": 
                case "mapping_exception": {
                    return NOT_SUPPORTED;
                }
                case "parsing_exception": {
                    return SYNTAX;
                }
                case "security_exception": {
                    return SECURITY;
                }
                case "timeout_exception": {
                    return TIMEOUT;
                }
            }
            return null;
        }

        private SqlExceptionType(Function<String, SQLException> toException) {
            this.toException = toException;
        }

        SQLException asException(String message) {
            if (message == null) {
                throw new IllegalArgumentException("[message] cannot be null");
            }
            return this.toException.apply(message);
        }
    }
}

