/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.analytics.action.PostAnalyticsEventAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPostAnalyticsEventAction
extends EnterpriseSearchBaseRestHandler {
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";

    public RestPostAnalyticsEventAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.BEHAVIORAL_ANALYTICS);
    }

    public String getName() {
        return "analytics_post_event_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_application/analytics/{collection_name}/event/{event_type}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) {
        PostAnalyticsEventAction.Request request = this.buidRequest(restRequest);
        return channel -> client.execute((ActionType)PostAnalyticsEventAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel, r -> RestStatus.ACCEPTED));
    }

    private InetAddress getClientAddress(RestRequest restRequest, Map<String, List<String>> headers) {
        List<String> addresses;
        InetAddress remoteAddress = restRequest.getHttpChannel().getRemoteAddress().getAddress();
        if (headers.containsKey(X_FORWARDED_FOR_HEADER) && !(addresses = headers.get(X_FORWARDED_FOR_HEADER)).isEmpty()) {
            try {
                remoteAddress = InetAddresses.forString((String)addresses.get(0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return remoteAddress;
    }

    private PostAnalyticsEventAction.Request buidRequest(RestRequest restRequest) {
        Tuple sourceTuple = restRequest.contentOrSourceParam();
        PostAnalyticsEventAction.RequestBuilder builder = PostAnalyticsEventAction.Request.builder(restRequest.param("collection_name"), restRequest.param("event_type"), (XContentType)sourceTuple.v1(), (BytesReference)sourceTuple.v2());
        builder.debug(restRequest.paramAsBoolean("debug", false));
        Map headers = restRequest.getHeaders();
        builder.headers(headers);
        builder.clientAddress(this.getClientAddress(restRequest, headers));
        return builder.request();
    }
}

