/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.application.EnterpriseSearchInfoTransportAction;
import org.elasticsearch.xpack.application.EnterpriseSearchUsageTransportAction;
import org.elasticsearch.xpack.application.analytics.AnalyticsTemplateRegistry;
import org.elasticsearch.xpack.application.analytics.action.DeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.GetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.PostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.action.PutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.RestDeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.RestGetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.RestPostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.action.RestPutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.TransportDeleteAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.TransportGetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.action.TransportPostAnalyticsEventAction;
import org.elasticsearch.xpack.application.analytics.action.TransportPutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.analytics.ingest.AnalyticsEventIngestConfig;
import org.elasticsearch.xpack.application.connector.ConnectorTemplateRegistry;
import org.elasticsearch.xpack.application.rules.QueryRulesConfig;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.RuleQueryBuilder;
import org.elasticsearch.xpack.application.rules.action.DeleteQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.GetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.ListQueryRulesetsAction;
import org.elasticsearch.xpack.application.rules.action.PutQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.RestDeleteQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.RestGetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.RestListQueryRulesetsAction;
import org.elasticsearch.xpack.application.rules.action.RestPutQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TransportDeleteQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TransportGetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TransportListQueryRulesetsAction;
import org.elasticsearch.xpack.application.rules.action.TransportPutQueryRulesetAction;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.action.DeleteSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.GetSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.ListSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.PutSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.QuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.application.search.action.RestDeleteSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestGetSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestListSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestPutSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestQuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.RestRenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.application.search.action.TransportDeleteSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportGetSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportListSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportPutSearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportQuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.TransportRenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;

public class EnterpriseSearch
extends Plugin
implements ActionPlugin,
SystemIndexPlugin,
SearchPlugin {
    public static final String APPLICATION_API_ENDPOINT = "_application";
    public static final String SEARCH_APPLICATION_API_ENDPOINT = "_application/search_application";
    public static final String BEHAVIORAL_ANALYTICS_API_ENDPOINT = "_application/analytics";
    public static final String QUERY_RULES_API_ENDPOINT = "_query_rules";
    private static final Logger logger = LogManager.getLogger(EnterpriseSearch.class);
    public static final String FEATURE_NAME = "ent_search";
    private final boolean enabled;

    public EnterpriseSearch(Settings settings) {
        this.enabled = (Boolean)XPackSettings.ENTERPRISE_SEARCH_ENABLED.get(settings);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.ENTERPRISE_SEARCH, EnterpriseSearchUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.ENTERPRISE_SEARCH, EnterpriseSearchInfoTransportAction.class);
        if (!this.enabled) {
            return List.of(usageAction, infoAction);
        }
        return List.of(new ActionPlugin.ActionHandler((ActionType)PutAnalyticsCollectionAction.INSTANCE, TransportPutAnalyticsCollectionAction.class), new ActionPlugin.ActionHandler((ActionType)GetAnalyticsCollectionAction.INSTANCE, TransportGetAnalyticsCollectionAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteAnalyticsCollectionAction.INSTANCE, TransportDeleteAnalyticsCollectionAction.class), new ActionPlugin.ActionHandler((ActionType)PostAnalyticsEventAction.INSTANCE, TransportPostAnalyticsEventAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteSearchApplicationAction.INSTANCE, TransportDeleteSearchApplicationAction.class), new ActionPlugin.ActionHandler((ActionType)GetSearchApplicationAction.INSTANCE, TransportGetSearchApplicationAction.class), new ActionPlugin.ActionHandler((ActionType)ListSearchApplicationAction.INSTANCE, TransportListSearchApplicationAction.class), new ActionPlugin.ActionHandler((ActionType)PutSearchApplicationAction.INSTANCE, TransportPutSearchApplicationAction.class), new ActionPlugin.ActionHandler((ActionType)QuerySearchApplicationAction.INSTANCE, TransportQuerySearchApplicationAction.class), new ActionPlugin.ActionHandler((ActionType)RenderSearchApplicationQueryAction.INSTANCE, TransportRenderSearchApplicationQueryAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteQueryRulesetAction.INSTANCE, TransportDeleteQueryRulesetAction.class), new ActionPlugin.ActionHandler((ActionType)GetQueryRulesetAction.INSTANCE, TransportGetQueryRulesetAction.class), new ActionPlugin.ActionHandler((ActionType)ListQueryRulesetsAction.INSTANCE, TransportListQueryRulesetsAction.class), new ActionPlugin.ActionHandler((ActionType)PutQueryRulesetAction.INSTANCE, TransportPutQueryRulesetAction.class), usageAction, infoAction);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return List.of(new RestHandler[]{new RestPutAnalyticsCollectionAction(this.getLicenseState()), new RestGetAnalyticsCollectionAction(this.getLicenseState()), new RestDeleteAnalyticsCollectionAction(this.getLicenseState()), new RestPostAnalyticsEventAction(this.getLicenseState()), new RestDeleteSearchApplicationAction(this.getLicenseState()), new RestGetSearchApplicationAction(this.getLicenseState()), new RestListSearchApplicationAction(this.getLicenseState()), new RestPutSearchApplicationAction(this.getLicenseState()), new RestQuerySearchApplicationAction(this.getLicenseState()), new RestRenderSearchApplicationQueryAction(this.getLicenseState()), new RestDeleteQueryRulesetAction(this.getLicenseState()), new RestGetQueryRulesetAction(this.getLicenseState()), new RestListQueryRulesetsAction(this.getLicenseState()), new RestPutQueryRulesetAction(this.getLicenseState())});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider telemetryProvider, AllocationService allocationService, IndicesService indicesService) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        AnalyticsTemplateRegistry analyticsTemplateRegistry = new AnalyticsTemplateRegistry(clusterService, threadPool, client, xContentRegistry);
        analyticsTemplateRegistry.initialize();
        ConnectorTemplateRegistry connectorTemplateRegistry = new ConnectorTemplateRegistry(clusterService, threadPool, client, xContentRegistry);
        connectorTemplateRegistry.initialize();
        return Arrays.asList(new Object[]{analyticsTemplateRegistry, connectorTemplateRegistry});
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Arrays.asList(SearchApplicationIndexService.getSystemIndexDescriptor(), QueryRulesIndexService.getSystemIndexDescriptor());
    }

    public String getFeatureName() {
        return FEATURE_NAME;
    }

    public String getFeatureDescription() {
        return "Manages configuration for Enterprise Search features";
    }

    public List<Setting<?>> getSettings() {
        return List.of(AnalyticsEventIngestConfig.MAX_NUMBER_OF_EVENTS_PER_BULK_SETTING, AnalyticsEventIngestConfig.FLUSH_DELAY_SETTING, AnalyticsEventIngestConfig.MAX_NUMBER_OF_RETRIES_SETTING, AnalyticsEventIngestConfig.MAX_BYTES_IN_FLIGHT_SETTING, QueryRulesConfig.MAX_RULE_LIMIT_SETTING);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("rule_query", RuleQueryBuilder::new, p -> RuleQueryBuilder.fromXContent(p, this.getLicenseState())));
    }
}

