/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.reindex.ReindexSslConfig;
import org.elasticsearch.reindex.RestDeleteByQueryAction;
import org.elasticsearch.reindex.RestReindexAction;
import org.elasticsearch.reindex.RestRethrottleAction;
import org.elasticsearch.reindex.RestUpdateByQueryAction;
import org.elasticsearch.reindex.RethrottleAction;
import org.elasticsearch.reindex.TransportDeleteByQueryAction;
import org.elasticsearch.reindex.TransportReindexAction;
import org.elasticsearch.reindex.TransportRethrottleAction;
import org.elasticsearch.reindex.TransportUpdateByQueryAction;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class ReindexPlugin
extends Plugin
implements ActionPlugin {
    public static final String NAME = "reindex";

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)ReindexAction.INSTANCE, TransportReindexAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateByQueryAction.INSTANCE, TransportUpdateByQueryAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteByQueryAction.INSTANCE, TransportDeleteByQueryAction.class), new ActionPlugin.ActionHandler((ActionType)RethrottleAction.INSTANCE, TransportRethrottleAction.class));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Collections.singletonList(new NamedWriteableRegistry.Entry(Task.Status.class, "bulk-by-scroll", BulkByScrollTask.Status::new));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestReindexAction(), new RestUpdateByQueryAction(), new RestDeleteByQueryAction(), new RestRethrottleAction(nodesInCluster)});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, TelemetryProvider telemetryProvider, AllocationService allocationService, IndicesService indicesService) {
        return Collections.singletonList(new ReindexSslConfig(environment.settings(), environment, resourceWatcherService));
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(TransportReindexAction.REMOTE_CLUSTER_WHITELIST);
        settings.addAll(ReindexSslConfig.getSettings());
        return settings;
    }
}

