/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.antlr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DiagnosticErrorListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.antlr.EnhancedPainlessLexer;
import org.elasticsearch.painless.antlr.PainlessParser;
import org.elasticsearch.painless.antlr.PainlessParserBaseVisitor;
import org.elasticsearch.painless.antlr.ParserErrorStrategy;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ANode;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.EAssignment;
import org.elasticsearch.painless.node.EBinary;
import org.elasticsearch.painless.node.EBooleanComp;
import org.elasticsearch.painless.node.EBooleanConstant;
import org.elasticsearch.painless.node.EBrace;
import org.elasticsearch.painless.node.ECall;
import org.elasticsearch.painless.node.ECallLocal;
import org.elasticsearch.painless.node.EComp;
import org.elasticsearch.painless.node.EConditional;
import org.elasticsearch.painless.node.EDecimal;
import org.elasticsearch.painless.node.EDot;
import org.elasticsearch.painless.node.EElvis;
import org.elasticsearch.painless.node.EExplicit;
import org.elasticsearch.painless.node.EFunctionRef;
import org.elasticsearch.painless.node.EInstanceof;
import org.elasticsearch.painless.node.ELambda;
import org.elasticsearch.painless.node.EListInit;
import org.elasticsearch.painless.node.EMapInit;
import org.elasticsearch.painless.node.ENewArray;
import org.elasticsearch.painless.node.ENewArrayFunctionRef;
import org.elasticsearch.painless.node.ENewObj;
import org.elasticsearch.painless.node.ENull;
import org.elasticsearch.painless.node.ENumeric;
import org.elasticsearch.painless.node.ERegex;
import org.elasticsearch.painless.node.EString;
import org.elasticsearch.painless.node.ESymbol;
import org.elasticsearch.painless.node.EUnary;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SBreak;
import org.elasticsearch.painless.node.SCatch;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.node.SContinue;
import org.elasticsearch.painless.node.SDeclBlock;
import org.elasticsearch.painless.node.SDeclaration;
import org.elasticsearch.painless.node.SDo;
import org.elasticsearch.painless.node.SEach;
import org.elasticsearch.painless.node.SExpression;
import org.elasticsearch.painless.node.SFor;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.node.SIf;
import org.elasticsearch.painless.node.SIfElse;
import org.elasticsearch.painless.node.SReturn;
import org.elasticsearch.painless.node.SThrow;
import org.elasticsearch.painless.node.STry;
import org.elasticsearch.painless.node.SWhile;

public final class Walker
extends PainlessParserBaseVisitor<ANode> {
    private final CompilerSettings settings;
    private final String sourceName;
    private int identifier;
    private final SClass source;

    public static SClass buildPainlessTree(String sourceName, String sourceText, CompilerSettings settings) {
        return new Walker((String)sourceName, (String)sourceText, (CompilerSettings)settings).source;
    }

    private Walker(String sourceName, String sourceText, CompilerSettings settings) {
        this.settings = settings;
        this.sourceName = sourceName;
        this.identifier = 0;
        this.source = (SClass)this.visit((ParseTree)this.buildAntlrTree(sourceText));
    }

    private int nextIdentifier() {
        return this.identifier++;
    }

    private PainlessParser.SourceContext buildAntlrTree(String sourceString) {
        ANTLRInputStream stream = new ANTLRInputStream(sourceString);
        EnhancedPainlessLexer lexer = new EnhancedPainlessLexer((CharStream)stream, this.sourceName);
        PainlessParser parser = new PainlessParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ParserErrorStrategy strategy = new ParserErrorStrategy(this.sourceName);
        lexer.removeErrorListeners();
        parser.removeErrorListeners();
        if (this.settings.isPicky()) {
            this.setupPicky(parser);
        }
        parser.setErrorHandler((ANTLRErrorStrategy)strategy);
        return parser.source();
    }

    private void setupPicky(PainlessParser parser) {
        parser.addErrorListener((ANTLRErrorListener)new DiagnosticErrorListener(true));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new AssertionError((Object)("line: " + line + ", offset: " + charPositionInLine + ", symbol:" + offendingSymbol + " " + msg));
            }
        });
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
    }

    private Location location(ParserRuleContext ctx) {
        return new Location(this.sourceName, ctx.getStart().getStartIndex());
    }

    private Location location(TerminalNode tn) {
        return new Location(this.sourceName, tn.getSymbol().getStartIndex());
    }

    @Override
    public ANode visitSource(PainlessParser.SourceContext ctx) {
        ArrayList<SFunction> functions = new ArrayList<SFunction>();
        for (PainlessParser.FunctionContext functionContext : ctx.function()) {
            functions.add((SFunction)this.visit((ParseTree)functionContext));
        }
        ArrayList<AStatement> statements = new ArrayList<AStatement>();
        for (PainlessParser.StatementContext statement : ctx.statement()) {
            statements.add((AStatement)this.visit((ParseTree)statement));
        }
        SFunction sFunction = new SFunction(this.nextIdentifier(), this.location(ctx), "<internal>", "execute", List.of(), List.of(), new SBlock(this.nextIdentifier(), this.location(ctx), statements), false, false, false, false);
        functions.add(sFunction);
        return new SClass(this.nextIdentifier(), this.location(ctx), functions);
    }

    @Override
    public ANode visitFunction(PainlessParser.FunctionContext ctx) {
        String rtnType = ctx.decltype().getText();
        String name = ctx.ID().getText();
        List<String> paramTypes = ctx.parameters().decltype().stream().map(RuleContext::getText).toList();
        List<String> paramNames = ctx.parameters().ID().stream().map(ParseTree::getText).toList();
        ArrayList<AStatement> statements = new ArrayList<AStatement>();
        for (PainlessParser.StatementContext statement : ctx.block().statement()) {
            statements.add((AStatement)this.visit((ParseTree)statement));
        }
        if (ctx.block().dstatement() != null) {
            statements.add((AStatement)this.visit((ParseTree)ctx.block().dstatement()));
        }
        return new SFunction(this.nextIdentifier(), this.location(ctx), rtnType, name, paramTypes, paramNames, new SBlock(this.nextIdentifier(), this.location(ctx), statements), false, false, false, false);
    }

    @Override
    public ANode visitParameters(PainlessParser.ParametersContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitStatement(PainlessParser.StatementContext ctx) {
        if (ctx.rstatement() != null) {
            return (ANode)this.visit((ParseTree)ctx.rstatement());
        }
        if (ctx.dstatement() != null) {
            return (ANode)this.visit((ParseTree)ctx.dstatement());
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitIf(PainlessParser.IfContext ctx) {
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        SBlock ifblock = (SBlock)this.visit((ParseTree)ctx.trailer(0));
        if (ctx.trailer().size() > 1) {
            SBlock elseblock = (SBlock)this.visit((ParseTree)ctx.trailer(1));
            return new SIfElse(this.nextIdentifier(), this.location(ctx), expression, ifblock, elseblock);
        }
        return new SIf(this.nextIdentifier(), this.location(ctx), expression, ifblock);
    }

    @Override
    public ANode visitWhile(PainlessParser.WhileContext ctx) {
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        if (ctx.trailer() != null) {
            SBlock block = (SBlock)this.visit((ParseTree)ctx.trailer());
            return new SWhile(this.nextIdentifier(), this.location(ctx), expression, block);
        }
        if (ctx.empty() != null) {
            return new SWhile(this.nextIdentifier(), this.location(ctx), expression, null);
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitDo(PainlessParser.DoContext ctx) {
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        SBlock block = (SBlock)this.visit((ParseTree)ctx.block());
        return new SDo(this.nextIdentifier(), this.location(ctx), expression, block);
    }

    @Override
    public ANode visitFor(PainlessParser.ForContext ctx) {
        AExpression afterthought;
        ANode initializer = ctx.initializer() == null ? null : (ANode)this.visit((ParseTree)ctx.initializer());
        AExpression expression = ctx.expression() == null ? null : (AExpression)this.visit((ParseTree)ctx.expression());
        AExpression aExpression = afterthought = ctx.afterthought() == null ? null : (AExpression)this.visit((ParseTree)ctx.afterthought());
        if (ctx.trailer() != null) {
            SBlock block = (SBlock)this.visit((ParseTree)ctx.trailer());
            return new SFor(this.nextIdentifier(), this.location(ctx), initializer, expression, afterthought, block);
        }
        if (ctx.empty() != null) {
            return new SFor(this.nextIdentifier(), this.location(ctx), initializer, expression, afterthought, null);
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitEach(PainlessParser.EachContext ctx) {
        String type = ctx.decltype().getText();
        String name = ctx.ID().getText();
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        SBlock block = (SBlock)this.visit((ParseTree)ctx.trailer());
        return new SEach(this.nextIdentifier(), this.location(ctx), type, name, expression, block);
    }

    @Override
    public ANode visitIneach(PainlessParser.IneachContext ctx) {
        String name = ctx.ID().getText();
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        SBlock block = (SBlock)this.visit((ParseTree)ctx.trailer());
        return new SEach(this.nextIdentifier(), this.location(ctx), "def", name, expression, block);
    }

    @Override
    public ANode visitDecl(PainlessParser.DeclContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.declaration());
    }

    @Override
    public ANode visitContinue(PainlessParser.ContinueContext ctx) {
        return new SContinue(this.nextIdentifier(), this.location(ctx));
    }

    @Override
    public ANode visitBreak(PainlessParser.BreakContext ctx) {
        return new SBreak(this.nextIdentifier(), this.location(ctx));
    }

    @Override
    public ANode visitReturn(PainlessParser.ReturnContext ctx) {
        AExpression expression = null;
        if (ctx.expression() != null) {
            expression = (AExpression)this.visit((ParseTree)ctx.expression());
        }
        return new SReturn(this.nextIdentifier(), this.location(ctx), expression);
    }

    @Override
    public ANode visitTry(PainlessParser.TryContext ctx) {
        SBlock block = (SBlock)this.visit((ParseTree)ctx.block());
        ArrayList<SCatch> catches = new ArrayList<SCatch>();
        for (PainlessParser.TrapContext trap : ctx.trap()) {
            catches.add((SCatch)this.visit((ParseTree)trap));
        }
        return new STry(this.nextIdentifier(), this.location(ctx), block, catches);
    }

    @Override
    public ANode visitThrow(PainlessParser.ThrowContext ctx) {
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        return new SThrow(this.nextIdentifier(), this.location(ctx), expression);
    }

    @Override
    public ANode visitExpr(PainlessParser.ExprContext ctx) {
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        return new SExpression(this.nextIdentifier(), this.location(ctx), expression);
    }

    @Override
    public ANode visitTrailer(PainlessParser.TrailerContext ctx) {
        if (ctx.block() != null) {
            return (ANode)this.visit((ParseTree)ctx.block());
        }
        if (ctx.statement() != null) {
            ArrayList<AStatement> statements = new ArrayList<AStatement>();
            statements.add((AStatement)this.visit((ParseTree)ctx.statement()));
            return new SBlock(this.nextIdentifier(), this.location(ctx), statements);
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitBlock(PainlessParser.BlockContext ctx) {
        if (ctx.statement().isEmpty() && ctx.dstatement() == null) {
            return null;
        }
        ArrayList<AStatement> statements = new ArrayList<AStatement>();
        for (PainlessParser.StatementContext statement : ctx.statement()) {
            statements.add((AStatement)this.visit((ParseTree)statement));
        }
        if (ctx.dstatement() != null) {
            statements.add((AStatement)this.visit((ParseTree)ctx.dstatement()));
        }
        return new SBlock(this.nextIdentifier(), this.location(ctx), statements);
    }

    @Override
    public ANode visitEmpty(PainlessParser.EmptyContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitInitializer(PainlessParser.InitializerContext ctx) {
        if (ctx.declaration() != null) {
            return (ANode)this.visit((ParseTree)ctx.declaration());
        }
        if (ctx.expression() != null) {
            return (ANode)this.visit((ParseTree)ctx.expression());
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitAfterthought(PainlessParser.AfterthoughtContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public ANode visitDeclaration(PainlessParser.DeclarationContext ctx) {
        String type = ctx.decltype().getText();
        ArrayList<SDeclaration> declarations = new ArrayList<SDeclaration>();
        for (PainlessParser.DeclvarContext declvar : ctx.declvar()) {
            String name = declvar.ID().getText();
            AExpression expression = declvar.expression() == null ? null : (AExpression)this.visit((ParseTree)declvar.expression());
            declarations.add(new SDeclaration(this.nextIdentifier(), this.location(declvar), type, name, expression));
        }
        return new SDeclBlock(this.nextIdentifier(), this.location(ctx), declarations);
    }

    @Override
    public ANode visitDecltype(PainlessParser.DecltypeContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitType(PainlessParser.TypeContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitDeclvar(PainlessParser.DeclvarContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitTrap(PainlessParser.TrapContext ctx) {
        String type = ctx.type().getText();
        String name = ctx.ID().getText();
        SBlock block = (SBlock)this.visit((ParseTree)ctx.block());
        return new SCatch(this.nextIdentifier(), this.location(ctx), Exception.class, type, name, block);
    }

    @Override
    public ANode visitSingle(PainlessParser.SingleContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.unary());
    }

    @Override
    public ANode visitBinary(PainlessParser.BinaryContext ctx) {
        Operation operation;
        AExpression left = (AExpression)this.visit((ParseTree)ctx.noncondexpression(0));
        AExpression right = (AExpression)this.visit((ParseTree)ctx.noncondexpression(1));
        if (ctx.MUL() != null) {
            operation = Operation.MUL;
        } else if (ctx.DIV() != null) {
            operation = Operation.DIV;
        } else if (ctx.REM() != null) {
            operation = Operation.REM;
        } else if (ctx.ADD() != null) {
            operation = Operation.ADD;
        } else if (ctx.SUB() != null) {
            operation = Operation.SUB;
        } else if (ctx.FIND() != null) {
            operation = Operation.FIND;
        } else if (ctx.MATCH() != null) {
            operation = Operation.MATCH;
        } else if (ctx.LSH() != null) {
            operation = Operation.LSH;
        } else if (ctx.RSH() != null) {
            operation = Operation.RSH;
        } else if (ctx.USH() != null) {
            operation = Operation.USH;
        } else if (ctx.BWAND() != null) {
            operation = Operation.BWAND;
        } else if (ctx.XOR() != null) {
            operation = Operation.XOR;
        } else if (ctx.BWOR() != null) {
            operation = Operation.BWOR;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EBinary(this.nextIdentifier(), this.location(ctx), left, right, operation);
    }

    @Override
    public ANode visitComp(PainlessParser.CompContext ctx) {
        Operation operation;
        AExpression left = (AExpression)this.visit((ParseTree)ctx.noncondexpression(0));
        AExpression right = (AExpression)this.visit((ParseTree)ctx.noncondexpression(1));
        if (ctx.LT() != null) {
            operation = Operation.LT;
        } else if (ctx.LTE() != null) {
            operation = Operation.LTE;
        } else if (ctx.GT() != null) {
            operation = Operation.GT;
        } else if (ctx.GTE() != null) {
            operation = Operation.GTE;
        } else if (ctx.EQ() != null) {
            operation = Operation.EQ;
        } else if (ctx.EQR() != null) {
            operation = Operation.EQR;
        } else if (ctx.NE() != null) {
            operation = Operation.NE;
        } else if (ctx.NER() != null) {
            operation = Operation.NER;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EComp(this.nextIdentifier(), this.location(ctx), left, right, operation);
    }

    @Override
    public ANode visitInstanceof(PainlessParser.InstanceofContext ctx) {
        AExpression expr = (AExpression)this.visit((ParseTree)ctx.noncondexpression());
        String type = ctx.decltype().getText();
        return new EInstanceof(this.nextIdentifier(), this.location(ctx), expr, type);
    }

    @Override
    public ANode visitBool(PainlessParser.BoolContext ctx) {
        Operation operation;
        AExpression left = (AExpression)this.visit((ParseTree)ctx.noncondexpression(0));
        AExpression right = (AExpression)this.visit((ParseTree)ctx.noncondexpression(1));
        if (ctx.BOOLAND() != null) {
            operation = Operation.AND;
        } else if (ctx.BOOLOR() != null) {
            operation = Operation.OR;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EBooleanComp(this.nextIdentifier(), this.location(ctx), left, right, operation);
    }

    @Override
    public ANode visitElvis(PainlessParser.ElvisContext ctx) {
        AExpression left = (AExpression)this.visit((ParseTree)ctx.noncondexpression(0));
        AExpression right = (AExpression)this.visit((ParseTree)ctx.noncondexpression(1));
        return new EElvis(this.nextIdentifier(), this.location(ctx), left, right);
    }

    @Override
    public ANode visitNonconditional(PainlessParser.NonconditionalContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.noncondexpression());
    }

    @Override
    public ANode visitConditional(PainlessParser.ConditionalContext ctx) {
        AExpression condition = (AExpression)this.visit((ParseTree)ctx.noncondexpression());
        AExpression left = (AExpression)this.visit((ParseTree)ctx.expression(0));
        AExpression right = (AExpression)this.visit((ParseTree)ctx.expression(1));
        return new EConditional(this.nextIdentifier(), this.location(ctx), condition, left, right);
    }

    @Override
    public ANode visitAssignment(PainlessParser.AssignmentContext ctx) {
        Operation operation;
        AExpression lhs = (AExpression)this.visit((ParseTree)ctx.noncondexpression());
        AExpression rhs = (AExpression)this.visit((ParseTree)ctx.expression());
        if (ctx.ASSIGN() != null) {
            operation = null;
        } else if (ctx.AMUL() != null) {
            operation = Operation.MUL;
        } else if (ctx.ADIV() != null) {
            operation = Operation.DIV;
        } else if (ctx.AREM() != null) {
            operation = Operation.REM;
        } else if (ctx.AADD() != null) {
            operation = Operation.ADD;
        } else if (ctx.ASUB() != null) {
            operation = Operation.SUB;
        } else if (ctx.ALSH() != null) {
            operation = Operation.LSH;
        } else if (ctx.ARSH() != null) {
            operation = Operation.RSH;
        } else if (ctx.AUSH() != null) {
            operation = Operation.USH;
        } else if (ctx.AAND() != null) {
            operation = Operation.BWAND;
        } else if (ctx.AXOR() != null) {
            operation = Operation.XOR;
        } else if (ctx.AOR() != null) {
            operation = Operation.BWOR;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EAssignment(this.nextIdentifier(), this.location(ctx), lhs, rhs, false, operation);
    }

    @Override
    public ANode visitPre(PainlessParser.PreContext ctx) {
        Operation operation;
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.chain());
        if (ctx.INCR() != null) {
            operation = Operation.ADD;
        } else if (ctx.DECR() != null) {
            operation = Operation.SUB;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EAssignment(this.nextIdentifier(), this.location(ctx), expression, new ENumeric(this.nextIdentifier(), this.location(ctx), "1", 10), false, operation);
    }

    @Override
    public ANode visitAddsub(PainlessParser.AddsubContext ctx) {
        Operation operation;
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.unary());
        if (ctx.ADD() != null) {
            operation = Operation.ADD;
        } else if (ctx.SUB() != null) {
            operation = Operation.SUB;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EUnary(this.nextIdentifier(), this.location(ctx), expression, operation);
    }

    @Override
    public ANode visitNotaddsub(PainlessParser.NotaddsubContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.unarynotaddsub());
    }

    @Override
    public ANode visitRead(PainlessParser.ReadContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.chain());
    }

    @Override
    public ANode visitPost(PainlessParser.PostContext ctx) {
        Operation operation;
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.chain());
        if (ctx.INCR() != null) {
            operation = Operation.ADD;
        } else if (ctx.DECR() != null) {
            operation = Operation.SUB;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EAssignment(this.nextIdentifier(), this.location(ctx), expression, new ENumeric(this.nextIdentifier(), this.location(ctx), "1", 10), true, operation);
    }

    @Override
    public ANode visitNot(PainlessParser.NotContext ctx) {
        Operation operation;
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.unary());
        if (ctx.BOOLNOT() != null) {
            operation = Operation.NOT;
        } else if (ctx.BWNOT() != null) {
            operation = Operation.BWNOT;
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EUnary(this.nextIdentifier(), this.location(ctx), expression, operation);
    }

    @Override
    public ANode visitCast(PainlessParser.CastContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.castexpression());
    }

    @Override
    public ANode visitPrimordefcast(PainlessParser.PrimordefcastContext ctx) {
        String type = ctx.primordefcasttype().getText();
        AExpression child = (AExpression)this.visit((ParseTree)ctx.unary());
        return new EExplicit(this.nextIdentifier(), this.location(ctx), type, child);
    }

    @Override
    public ANode visitRefcast(PainlessParser.RefcastContext ctx) {
        String type = ctx.refcasttype().getText();
        AExpression child = (AExpression)this.visit((ParseTree)ctx.unarynotaddsub());
        return new EExplicit(this.nextIdentifier(), this.location(ctx), type, child);
    }

    @Override
    public ANode visitPrimordefcasttype(PainlessParser.PrimordefcasttypeContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitRefcasttype(PainlessParser.RefcasttypeContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitDynamic(PainlessParser.DynamicContext ctx) {
        AExpression primary = (AExpression)this.visit((ParseTree)ctx.primary());
        return this.buildPostfixChain(primary, null, ctx.postfix());
    }

    @Override
    public ANode visitNewarray(PainlessParser.NewarrayContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.arrayinitializer());
    }

    @Override
    public ANode visitPrecedence(PainlessParser.PrecedenceContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public ANode visitNumeric(PainlessParser.NumericContext ctx) {
        if (ctx.DECIMAL() != null) {
            return new EDecimal(this.nextIdentifier(), this.location(ctx), ctx.DECIMAL().getText());
        }
        if (ctx.HEX() != null) {
            return new ENumeric(this.nextIdentifier(), this.location(ctx), ctx.HEX().getText().substring(2), 16);
        }
        if (ctx.INTEGER() != null) {
            return new ENumeric(this.nextIdentifier(), this.location(ctx), ctx.INTEGER().getText(), 10);
        }
        if (ctx.OCTAL() != null) {
            return new ENumeric(this.nextIdentifier(), this.location(ctx), ctx.OCTAL().getText().substring(1), 8);
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitTrue(PainlessParser.TrueContext ctx) {
        return new EBooleanConstant(this.nextIdentifier(), this.location(ctx), true);
    }

    @Override
    public ANode visitFalse(PainlessParser.FalseContext ctx) {
        return new EBooleanConstant(this.nextIdentifier(), this.location(ctx), false);
    }

    @Override
    public ANode visitNull(PainlessParser.NullContext ctx) {
        return new ENull(this.nextIdentifier(), this.location(ctx));
    }

    @Override
    public ANode visitString(PainlessParser.StringContext ctx) {
        StringBuilder string = new StringBuilder(ctx.STRING().getText());
        int src = 1;
        int dest = 0;
        int end = string.length() - 1;
        assert (string.charAt(0) == '\"' || string.charAt(0) == '\'') : "expected string to start with a quote but was [" + string + "]";
        assert (string.charAt(end) == '\"' || string.charAt(end) == '\'') : "expected string to end with a quote was [" + string + "]";
        while (src < end) {
            char current = string.charAt(src);
            if (current == '\\') {
                current = string.charAt(++src);
            }
            string.setCharAt(dest, current);
            ++src;
            ++dest;
        }
        string.setLength(dest);
        return new EString(this.nextIdentifier(), this.location(ctx), string.toString());
    }

    @Override
    public ANode visitRegex(PainlessParser.RegexContext ctx) {
        String text = ctx.REGEX().getText();
        int lastSlash = text.lastIndexOf(47);
        String pattern = text.substring(1, lastSlash);
        String flags = text.substring(lastSlash + 1);
        return new ERegex(this.nextIdentifier(), this.location(ctx), pattern, flags);
    }

    @Override
    public ANode visitListinit(PainlessParser.ListinitContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.listinitializer());
    }

    @Override
    public ANode visitMapinit(PainlessParser.MapinitContext ctx) {
        return (ANode)this.visit((ParseTree)ctx.mapinitializer());
    }

    @Override
    public ANode visitVariable(PainlessParser.VariableContext ctx) {
        String name = ctx.ID().getText();
        return new ESymbol(this.nextIdentifier(), this.location(ctx), name);
    }

    @Override
    public ANode visitCalllocal(PainlessParser.CalllocalContext ctx) {
        String name = ctx.ID() == null ? ctx.DOLLAR().getText() : ctx.ID().getText();
        List<AExpression> arguments = this.collectArguments(ctx.arguments());
        return new ECallLocal(this.nextIdentifier(), this.location(ctx), name, arguments);
    }

    @Override
    public ANode visitNewobject(PainlessParser.NewobjectContext ctx) {
        String type = ctx.type().getText();
        List<AExpression> arguments = this.collectArguments(ctx.arguments());
        return new ENewObj(this.nextIdentifier(), this.location(ctx), type, arguments);
    }

    private AExpression buildPostfixChain(AExpression primary, PainlessParser.PostdotContext postdot, List<PainlessParser.PostfixContext> postfixes) {
        AExpression prefix = primary;
        if (postdot != null) {
            prefix = this.visitPostdot(postdot, prefix);
        }
        for (PainlessParser.PostfixContext postfix : postfixes) {
            prefix = this.visitPostfix(postfix, prefix);
        }
        return prefix;
    }

    @Override
    public ANode visitPostfix(PainlessParser.PostfixContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    public AExpression visitPostfix(PainlessParser.PostfixContext ctx, AExpression prefix) {
        if (ctx.callinvoke() != null) {
            return this.visitCallinvoke(ctx.callinvoke(), prefix);
        }
        if (ctx.fieldaccess() != null) {
            return this.visitFieldaccess(ctx.fieldaccess(), prefix);
        }
        if (ctx.braceaccess() != null) {
            return this.visitBraceaccess(ctx.braceaccess(), prefix);
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitPostdot(PainlessParser.PostdotContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    public AExpression visitPostdot(PainlessParser.PostdotContext ctx, AExpression prefix) {
        if (ctx.callinvoke() != null) {
            return this.visitCallinvoke(ctx.callinvoke(), prefix);
        }
        if (ctx.fieldaccess() != null) {
            return this.visitFieldaccess(ctx.fieldaccess(), prefix);
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitCallinvoke(PainlessParser.CallinvokeContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    public AExpression visitCallinvoke(PainlessParser.CallinvokeContext ctx, AExpression prefix) {
        String name = ctx.DOTID().getText();
        List<AExpression> arguments = this.collectArguments(ctx.arguments());
        return new ECall(this.nextIdentifier(), this.location(ctx), prefix, name, arguments, ctx.NSDOT() != null);
    }

    @Override
    public ANode visitFieldaccess(PainlessParser.FieldaccessContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    public AExpression visitFieldaccess(PainlessParser.FieldaccessContext ctx, AExpression prefix) {
        String value;
        if (ctx.DOTID() != null) {
            value = ctx.DOTID().getText();
        } else if (ctx.DOTINTEGER() != null) {
            value = ctx.DOTINTEGER().getText();
        } else {
            throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
        }
        return new EDot(this.nextIdentifier(), this.location(ctx), prefix, value, ctx.NSDOT() != null);
    }

    @Override
    public ANode visitBraceaccess(PainlessParser.BraceaccessContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    public AExpression visitBraceaccess(PainlessParser.BraceaccessContext ctx, AExpression prefix) {
        AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
        return new EBrace(this.nextIdentifier(), this.location(ctx), prefix, expression);
    }

    @Override
    public ANode visitNewstandardarray(PainlessParser.NewstandardarrayContext ctx) {
        StringBuilder type = new StringBuilder(ctx.type().getText());
        ArrayList<AExpression> expressions = new ArrayList<AExpression>();
        for (PainlessParser.ExpressionContext expression : ctx.expression()) {
            type.append("[]");
            expressions.add((AExpression)this.visit((ParseTree)expression));
        }
        return this.buildPostfixChain(new ENewArray(this.nextIdentifier(), this.location(ctx), type.toString(), expressions, false), ctx.postdot(), ctx.postfix());
    }

    @Override
    public ANode visitNewinitializedarray(PainlessParser.NewinitializedarrayContext ctx) {
        String type = ctx.type().getText() + "[]";
        ArrayList<AExpression> expressions = new ArrayList<AExpression>();
        for (PainlessParser.ExpressionContext expression : ctx.expression()) {
            expressions.add((AExpression)this.visit((ParseTree)expression));
        }
        return this.buildPostfixChain(new ENewArray(this.nextIdentifier(), this.location(ctx), type, expressions, true), null, ctx.postfix());
    }

    @Override
    public ANode visitListinitializer(PainlessParser.ListinitializerContext ctx) {
        ArrayList<AExpression> values = new ArrayList<AExpression>();
        for (PainlessParser.ExpressionContext expression : ctx.expression()) {
            values.add((AExpression)this.visit((ParseTree)expression));
        }
        return new EListInit(this.nextIdentifier(), this.location(ctx), values);
    }

    @Override
    public ANode visitMapinitializer(PainlessParser.MapinitializerContext ctx) {
        ArrayList<AExpression> keys = new ArrayList<AExpression>();
        ArrayList<AExpression> values = new ArrayList<AExpression>();
        for (PainlessParser.MaptokenContext maptoken : ctx.maptoken()) {
            keys.add((AExpression)this.visit((ParseTree)maptoken.expression(0)));
            values.add((AExpression)this.visit((ParseTree)maptoken.expression(1)));
        }
        return new EMapInit(this.nextIdentifier(), this.location(ctx), keys, values);
    }

    @Override
    public ANode visitMaptoken(PainlessParser.MaptokenContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitArguments(PainlessParser.ArgumentsContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    private List<AExpression> collectArguments(PainlessParser.ArgumentsContext ctx) {
        ArrayList<AExpression> arguments = new ArrayList<AExpression>(ctx.argument().size());
        for (PainlessParser.ArgumentContext argument : ctx.argument()) {
            arguments.add((AExpression)this.visit((ParseTree)argument));
        }
        return arguments;
    }

    @Override
    public ANode visitArgument(PainlessParser.ArgumentContext ctx) {
        if (ctx.expression() != null) {
            return (ANode)this.visit((ParseTree)ctx.expression());
        }
        if (ctx.lambda() != null) {
            return (ANode)this.visit((ParseTree)ctx.lambda());
        }
        if (ctx.funcref() != null) {
            return (ANode)this.visit((ParseTree)ctx.funcref());
        }
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitLambda(PainlessParser.LambdaContext ctx) {
        SBlock block;
        ArrayList<String> paramTypes = new ArrayList<String>(ctx.lamtype().size());
        ArrayList<String> paramNames = new ArrayList<String>(ctx.lamtype().size());
        for (PainlessParser.LamtypeContext lamtype : ctx.lamtype()) {
            if (lamtype.decltype() == null) {
                paramTypes.add(null);
            } else {
                paramTypes.add(lamtype.decltype().getText());
            }
            paramNames.add(lamtype.ID().getText());
        }
        if (ctx.expression() != null) {
            AExpression expression = (AExpression)this.visit((ParseTree)ctx.expression());
            block = new SBlock(this.nextIdentifier(), this.location(ctx), Collections.singletonList(new SReturn(this.nextIdentifier(), this.location(ctx), expression)));
        } else {
            block = (SBlock)this.visit((ParseTree)ctx.block());
        }
        return new ELambda(this.nextIdentifier(), this.location(ctx), paramTypes, paramNames, block);
    }

    @Override
    public ANode visitLamtype(PainlessParser.LamtypeContext ctx) {
        throw this.location(ctx).createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    public ANode visitClassfuncref(PainlessParser.ClassfuncrefContext ctx) {
        return new EFunctionRef(this.nextIdentifier(), this.location(ctx), ctx.decltype().getText(), ctx.ID().getText());
    }

    @Override
    public ANode visitConstructorfuncref(PainlessParser.ConstructorfuncrefContext ctx) {
        return ctx.decltype().LBRACE().isEmpty() ? new EFunctionRef(this.nextIdentifier(), this.location(ctx), ctx.decltype().getText(), ctx.NEW().getText()) : new ENewArrayFunctionRef(this.nextIdentifier(), this.location(ctx), ctx.decltype().getText());
    }

    @Override
    public ANode visitLocalfuncref(PainlessParser.LocalfuncrefContext ctx) {
        return new EFunctionRef(this.nextIdentifier(), this.location(ctx), ctx.THIS().getText(), ctx.ID().getText());
    }
}

