/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.RateLimitingFilter;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.deprecation.logging.DeprecationCacheResetAction;

public class TransportDeprecationCacheResetAction
extends TransportNodesAction<DeprecationCacheResetAction.Request, DeprecationCacheResetAction.Response, DeprecationCacheResetAction.NodeRequest, DeprecationCacheResetAction.NodeResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeprecationCacheResetAction.class);
    private final RateLimitingFilter rateLimitingFilterForIndexing;

    @Inject
    public TransportDeprecationCacheResetAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, RateLimitingFilter rateLimitingFilterForIndexing) {
        super("cluster:admin/deprecation/cache/reset", threadPool, clusterService, transportService, actionFilters, DeprecationCacheResetAction.Request::new, DeprecationCacheResetAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.rateLimitingFilterForIndexing = rateLimitingFilterForIndexing;
    }

    protected DeprecationCacheResetAction.Response newResponse(DeprecationCacheResetAction.Request request, List<DeprecationCacheResetAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new DeprecationCacheResetAction.Response(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected DeprecationCacheResetAction.NodeRequest newNodeRequest(DeprecationCacheResetAction.Request request) {
        return new DeprecationCacheResetAction.NodeRequest(request);
    }

    protected DeprecationCacheResetAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new DeprecationCacheResetAction.NodeResponse(in);
    }

    protected DeprecationCacheResetAction.NodeResponse nodeOperation(DeprecationCacheResetAction.NodeRequest request, Task task) {
        this.rateLimitingFilterForIndexing.reset();
        logger.debug("Deprecation cache was reset");
        return new DeprecationCacheResetAction.NodeResponse(this.transportService.getLocalNode());
    }
}

