/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.type.Converter;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;
import org.elasticsearch.xpack.versionfield.Version;

public final class DataTypeConverter {
    private DataTypeConverter() {
    }

    public static DataType commonType(DataType left, DataType right) {
        if (left == right) {
            return left;
        }
        if (left == DataTypes.NULL) {
            return right;
        }
        if (right == DataTypes.NULL) {
            return left;
        }
        if (DataTypes.isString(left) && DataTypes.isString(right)) {
            if (left == DataTypes.TEXT || right == DataTypes.TEXT) {
                return DataTypes.TEXT;
            }
            if (left == DataTypes.KEYWORD) {
                return DataTypes.KEYWORD;
            }
            return right;
        }
        if (left.isNumeric() && right.isNumeric()) {
            if (left.isInteger()) {
                if (right.isInteger()) {
                    if (left == DataTypes.UNSIGNED_LONG || right == DataTypes.UNSIGNED_LONG) {
                        return DataTypes.UNSIGNED_LONG;
                    }
                    return left.size() > right.size() ? left : right;
                }
                return right;
            }
            if (right.isInteger()) {
                return left;
            }
            return left.size() > right.size() ? left : right;
        }
        if (DataTypes.isString(left) && right.isNumeric()) {
            return right;
        }
        if (DataTypes.isString(right) && left.isNumeric()) {
            return left;
        }
        if (DataTypes.isDateTime(left) && DataTypes.isDateTime(right)) {
            return DataTypes.DATETIME;
        }
        return null;
    }

    public static boolean canConvert(DataType from, DataType to) {
        if (from == to || from == DataTypes.NULL) {
            return true;
        }
        return DataTypes.isPrimitive(from) && DataTypes.isPrimitive(to) && DataTypeConverter.converterFor(from, to) != null;
    }

    public static Converter converterFor(DataType from, DataType to) {
        if (from == to || DataTypes.isDateTime(from) && DataTypes.isDateTime(to)) {
            return DefaultConverter.IDENTITY;
        }
        if (to == DataTypes.NULL || from == DataTypes.NULL) {
            return DefaultConverter.TO_NULL;
        }
        if (to == DataTypes.KEYWORD || to == DataTypes.TEXT) {
            return DataTypeConverter.conversionToString(from);
        }
        if (to == DataTypes.LONG) {
            return DataTypeConverter.conversionToLong(from);
        }
        if (to == DataTypes.UNSIGNED_LONG) {
            return DataTypeConverter.conversionToUnsignedLong(from);
        }
        if (to == DataTypes.INTEGER) {
            return DataTypeConverter.conversionToInt(from);
        }
        if (to == DataTypes.SHORT) {
            return DataTypeConverter.conversionToShort(from);
        }
        if (to == DataTypes.BYTE) {
            return DataTypeConverter.conversionToByte(from);
        }
        if (to == DataTypes.FLOAT) {
            return DataTypeConverter.conversionToFloat(from);
        }
        if (to == DataTypes.DOUBLE) {
            return DataTypeConverter.conversionToDouble(from);
        }
        if (DataTypes.isDateTime(to)) {
            return DataTypeConverter.conversionToDateTime(from);
        }
        if (to == DataTypes.BOOLEAN) {
            return DataTypeConverter.conversionToBoolean(from);
        }
        if (to == DataTypes.IP) {
            return DataTypeConverter.conversionToIp(from);
        }
        if (to == DataTypes.VERSION) {
            return DataTypeConverter.conversionToVersion(from);
        }
        return null;
    }

    private static Converter conversionToString(DataType from) {
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_STRING;
        }
        return DefaultConverter.OTHER_TO_STRING;
    }

    private static Converter conversionToIp(DataType from) {
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_IP;
        }
        return null;
    }

    private static Converter conversionToVersion(DataType from) {
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_VERSION;
        }
        return null;
    }

    private static Converter conversionToUnsignedLong(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_UNSIGNED_LONG;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_UNSIGNED_LONG;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_UNSIGNED_LONG;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_UNSIGNED_LONG;
        }
        if (from == DataTypes.DATETIME) {
            return DefaultConverter.DATETIME_TO_UNSIGNED_LONG;
        }
        return null;
    }

    private static Converter conversionToLong(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_LONG;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_LONG;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_LONG;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_LONG;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_LONG;
        }
        return null;
    }

    private static Converter conversionToInt(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_INT;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_INT;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_INT;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_INT;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_INT;
        }
        return null;
    }

    private static Converter conversionToShort(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_SHORT;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_SHORT;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_SHORT;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_SHORT;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_SHORT;
        }
        return null;
    }

    private static Converter conversionToByte(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_BYTE;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_BYTE;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_BYTE;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_BYTE;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_BYTE;
        }
        return null;
    }

    private static DefaultConverter conversionToFloat(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_FLOAT;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_FLOAT;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_FLOAT;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_FLOAT;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_FLOAT;
        }
        return null;
    }

    private static DefaultConverter conversionToDouble(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_DOUBLE;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_DOUBLE;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_DOUBLE;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_DOUBLE;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_DOUBLE;
        }
        return null;
    }

    private static DefaultConverter conversionToDateTime(DataType from) {
        if (from.isRational()) {
            return DefaultConverter.RATIONAL_TO_DATETIME;
        }
        if (from.isInteger()) {
            return DefaultConverter.INTEGER_TO_DATETIME;
        }
        if (from == DataTypes.BOOLEAN) {
            return DefaultConverter.BOOL_TO_DATETIME;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_DATETIME;
        }
        return null;
    }

    private static DefaultConverter conversionToBoolean(DataType from) {
        if (from.isNumeric()) {
            return DefaultConverter.NUMERIC_TO_BOOLEAN;
        }
        if (DataTypes.isString(from)) {
            return DefaultConverter.STRING_TO_BOOLEAN;
        }
        if (DataTypes.isDateTime(from)) {
            return DefaultConverter.DATETIME_TO_BOOLEAN;
        }
        return null;
    }

    public static byte safeToByte(long x) {
        if (x > 127L || x < -128L) {
            throw new QlIllegalArgumentException("[" + x + "] out of [byte] range");
        }
        return (byte)x;
    }

    public static short safeToShort(long x) {
        if (x > 32767L || x < -32768L) {
            throw new QlIllegalArgumentException("[" + x + "] out of [short] range");
        }
        return (short)x;
    }

    public static int safeToInt(long x) {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw new QlIllegalArgumentException("[" + x + "] out of [integer] range");
        }
        return (int)x;
    }

    public static long safeDoubleToLong(double x) {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw new QlIllegalArgumentException("[" + x + "] out of [long] range");
        }
        return Math.round(x);
    }

    public static Long safeToLong(Number x) {
        try {
            if (x instanceof BigInteger) {
                return ((BigInteger)x).longValueExact();
            }
            if (x instanceof Double || x instanceof Float) {
                return DataTypeConverter.safeDoubleToLong(x.doubleValue());
            }
            return x.longValue();
        }
        catch (ArithmeticException ae) {
            throw new QlIllegalArgumentException("[" + x + "] out of [long] range", ae);
        }
    }

    public static BigInteger safeToUnsignedLong(Double x) {
        if (!NumericUtils.inUnsignedLongRange(x)) {
            throw new QlIllegalArgumentException("[" + x + "] out of [unsigned_long] range");
        }
        return BigDecimal.valueOf(x).toBigInteger();
    }

    public static BigInteger safeToUnsignedLong(Long x) {
        if (x < 0L) {
            throw new QlIllegalArgumentException("[" + x + "] out of [unsigned_long] range");
        }
        return BigInteger.valueOf(x);
    }

    public static BigInteger safeToUnsignedLong(String x) {
        BigInteger bi = new BigDecimal(x).toBigInteger();
        if (!NumericUtils.isUnsignedLong(bi)) {
            throw new QlIllegalArgumentException("[" + x + "] out of [unsigned_long] range");
        }
        return bi;
    }

    public static BigInteger toUnsignedLong(Number number) {
        BigInteger bi = BigInteger.valueOf(number.longValue());
        return bi.signum() < 0 ? bi.and(NumericUtils.UNSIGNED_LONG_MAX) : bi;
    }

    public static Number toInteger(double x, DataType dataType) {
        long l = DataTypeConverter.safeDoubleToLong(x);
        if (dataType == DataTypes.BYTE) {
            return DataTypeConverter.safeToByte(l);
        }
        if (dataType == DataTypes.SHORT) {
            return DataTypeConverter.safeToShort(l);
        }
        if (dataType == DataTypes.INTEGER) {
            return DataTypeConverter.safeToInt(l);
        }
        return l;
    }

    public static boolean convertToBoolean(String val) {
        String lowVal = val.toLowerCase(Locale.ROOT);
        if (!Booleans.isBoolean((String)lowVal)) {
            throw new QlIllegalArgumentException("cannot cast [" + val + "] to [boolean]");
        }
        return Booleans.parseBoolean((String)lowVal);
    }

    public static Object convert(Object value, DataType dataType) {
        DataType detectedType = DataTypes.fromJava(value);
        if (detectedType == dataType || value == null) {
            return value;
        }
        Converter converter = DataTypeConverter.converterFor(detectedType, dataType);
        if (converter == null) {
            throw new QlIllegalArgumentException("cannot convert from [{}], type [{}] to [{}]", value, detectedType.typeName(), dataType.typeName());
        }
        return converter.convert(value);
    }

    public static DataType asInteger(DataType dataType) {
        if (!dataType.isNumeric()) {
            return dataType;
        }
        return dataType.isInteger() ? dataType : DataTypes.LONG;
    }

    public static enum DefaultConverter implements Converter
    {
        IDENTITY(Function.identity()),
        TO_NULL(value -> null),
        DATETIME_TO_STRING(o -> DateUtils.toString((ZonedDateTime)o)),
        OTHER_TO_STRING(String::valueOf),
        RATIONAL_TO_UNSIGNED_LONG(DefaultConverter.fromDouble(DataTypeConverter::safeToUnsignedLong)),
        INTEGER_TO_UNSIGNED_LONG(DefaultConverter.fromNumber(value -> DataTypeConverter.safeToUnsignedLong(value.longValue()))),
        STRING_TO_UNSIGNED_LONG(DefaultConverter.fromString(DataTypeConverter::safeToUnsignedLong, "unsigned_long")),
        DATETIME_TO_UNSIGNED_LONG(DefaultConverter.fromDateTime(DataTypeConverter::safeToUnsignedLong)),
        RATIONAL_TO_LONG(DefaultConverter.fromDouble(DataTypeConverter::safeDoubleToLong)),
        INTEGER_TO_LONG(DefaultConverter.fromNumber(DataTypeConverter::safeToLong)),
        STRING_TO_LONG(DefaultConverter.fromString(Long::valueOf, "long")),
        DATETIME_TO_LONG(DefaultConverter.fromDateTime(value -> value)),
        RATIONAL_TO_INT(DefaultConverter.fromDouble(value -> DataTypeConverter.safeToInt(DataTypeConverter.safeDoubleToLong(value)))),
        INTEGER_TO_INT(DefaultConverter.fromNumber(value -> DataTypeConverter.safeToInt(DataTypeConverter.safeToLong(value)))),
        BOOL_TO_INT(DefaultConverter.fromBool(value -> value != false ? 1 : 0)),
        STRING_TO_INT(DefaultConverter.fromString(Integer::valueOf, "integer")),
        DATETIME_TO_INT(DefaultConverter.fromDateTime(DataTypeConverter::safeToInt)),
        RATIONAL_TO_SHORT(DefaultConverter.fromDouble(value -> DataTypeConverter.safeToShort(DataTypeConverter.safeDoubleToLong(value)))),
        INTEGER_TO_SHORT(DefaultConverter.fromNumber(value -> DataTypeConverter.safeToShort(DataTypeConverter.safeToLong(value)))),
        BOOL_TO_SHORT(DefaultConverter.fromBool(value -> value != false ? (short)1 : (short)0)),
        STRING_TO_SHORT(DefaultConverter.fromString(Short::valueOf, "short")),
        DATETIME_TO_SHORT(DefaultConverter.fromDateTime(DataTypeConverter::safeToShort)),
        RATIONAL_TO_BYTE(DefaultConverter.fromDouble(value -> DataTypeConverter.safeToByte(DataTypeConverter.safeDoubleToLong(value)))),
        INTEGER_TO_BYTE(DefaultConverter.fromNumber(value -> DataTypeConverter.safeToByte(DataTypeConverter.safeToLong(value)))),
        BOOL_TO_BYTE(DefaultConverter.fromBool(value -> value != false ? (byte)1 : (byte)0)),
        STRING_TO_BYTE(DefaultConverter.fromString(Byte::valueOf, "byte")),
        DATETIME_TO_BYTE(DefaultConverter.fromDateTime(DataTypeConverter::safeToByte)),
        RATIONAL_TO_FLOAT(DefaultConverter.fromDouble(value -> Float.valueOf((float)value))),
        INTEGER_TO_FLOAT(DefaultConverter.fromNumber(Number::floatValue)),
        BOOL_TO_FLOAT(DefaultConverter.fromBool(value -> Float.valueOf(value != false ? 1.0f : 0.0f))),
        STRING_TO_FLOAT(DefaultConverter.fromString(Float::valueOf, "float")),
        DATETIME_TO_FLOAT(DefaultConverter.fromDateTime(value -> Float.valueOf(value.longValue()))),
        RATIONAL_TO_DOUBLE(DefaultConverter.fromDouble(Double::valueOf)),
        INTEGER_TO_DOUBLE(DefaultConverter.fromNumber(Number::doubleValue)),
        BOOL_TO_DOUBLE(DefaultConverter.fromBool(value -> value != false ? 1.0 : 0.0)),
        STRING_TO_DOUBLE(DefaultConverter.fromString(Double::valueOf, "double")),
        DATETIME_TO_DOUBLE(DefaultConverter.fromDateTime(Double::valueOf)),
        RATIONAL_TO_DATETIME(DefaultConverter.toDateTime(RATIONAL_TO_LONG)),
        INTEGER_TO_DATETIME(DefaultConverter.toDateTime(INTEGER_TO_LONG)),
        BOOL_TO_DATETIME(DefaultConverter.toDateTime(BOOL_TO_INT)),
        STRING_TO_DATETIME(DefaultConverter.fromString(DateUtils::asDateTime, "datetime")),
        NUMERIC_TO_BOOLEAN(DefaultConverter.fromDouble(value -> value != 0.0)),
        STRING_TO_BOOLEAN(DefaultConverter.fromString(DataTypeConverter::convertToBoolean, "boolean")),
        DATETIME_TO_BOOLEAN(DefaultConverter.fromDateTime(value -> value != 0L)),
        BOOL_TO_UNSIGNED_LONG(DefaultConverter.fromBool(value -> value != false ? BigInteger.ONE : BigInteger.ZERO)),
        BOOL_TO_LONG(DefaultConverter.fromBool(value -> value != false ? 1L : 0L)),
        STRING_TO_IP(o -> {
            if (!InetAddresses.isInetAddress((String)o.toString())) {
                throw new QlIllegalArgumentException("[" + o + "] is not a valid IPv4 or IPv6 address");
            }
            return o;
        }),
        STRING_TO_VERSION(o -> new Version(o.toString()));

        public static final String NAME = "dtc-def";
        private final Function<Object, Object> converter;

        private DefaultConverter(Function<Object, Object> converter) {
            this.converter = converter;
        }

        private static Function<Object, Object> fromDouble(DoubleFunction<Object> converter) {
            return l -> converter.apply(((Number)l).doubleValue());
        }

        private static Function<Object, Object> fromNumber(Function<Number, Object> converter) {
            return l -> converter.apply((Number)l);
        }

        public static Function<Object, Object> fromString(Function<String, Object> converter, String to) {
            return value -> {
                try {
                    return converter.apply(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new QlIllegalArgumentException(e, "cannot cast [{}] to [{}]", value, to);
                }
                catch (IllegalArgumentException | DateTimeParseException e) {
                    throw new QlIllegalArgumentException(e, "cannot cast [{}] to [{}]: {}", value, to, e.getMessage());
                }
            };
        }

        private static Function<Object, Object> fromBool(Function<Boolean, Object> converter) {
            return l -> converter.apply((Boolean)l);
        }

        private static Function<Object, Object> fromDateTime(Function<Long, Object> converter) {
            return l -> converter.apply(((ZonedDateTime)l).toInstant().toEpochMilli());
        }

        private static Function<Object, Object> toDateTime(Converter conversion) {
            return l -> DateUtils.asDateTime(((Number)conversion.convert(l)).longValue());
        }

        @Override
        public Object convert(Object l) {
            if (l == null) {
                return null;
            }
            return this.converter.apply(l);
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public static Converter read(StreamInput in) throws IOException {
            return (Converter)((Object)in.readEnum(DefaultConverter.class));
        }
    }
}

