/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.index;

import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.index.VersionCompatibilityChecks;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.Types;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;

public final class IndexCompatibility {
    public static Map<String, EsField> compatible(Map<String, EsField> mapping, Version version) {
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            EsField esField = entry.getValue();
            DataType dataType = esField.getDataType();
            if (!DataTypes.isPrimitive(dataType)) {
                IndexCompatibility.compatible(esField.getProperties(), version);
                continue;
            }
            if (VersionCompatibilityChecks.isTypeSupportedInVersion(dataType, version)) continue;
            UnsupportedEsField field = new UnsupportedEsField(entry.getKey(), dataType.name(), null, esField.getProperties());
            entry.setValue(field);
            Types.propagateUnsupportedType(entry.getKey(), dataType.name(), esField.getProperties());
        }
        return mapping;
    }

    public static EsIndex compatible(EsIndex esIndex, Version version) {
        IndexCompatibility.compatible(esIndex.mapping(), version);
        return esIndex;
    }

    public static IndexResolution compatible(IndexResolution indexResolution, Version version) {
        if (indexResolution.isValid()) {
            IndexCompatibility.compatible(indexResolution.get(), version);
        }
        return indexResolution;
    }
}

