/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Map;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypedAttribute;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class MetadataAttribute
extends TypedAttribute {
    private static final Map<String, Tuple<DataType, Boolean>> ATTRIBUTES_MAP = Map.of("_version", Tuple.tuple((Object)DataTypes.LONG, (Object)false), "_index", Tuple.tuple((Object)DataTypes.KEYWORD, (Object)true), "_id", Tuple.tuple((Object)DataTypes.KEYWORD, (Object)false));
    private final boolean searchable;

    public MetadataAttribute(Source source, String name, DataType dataType, String qualifier, Nullability nullability, NameId id, boolean synthetic, boolean searchable) {
        super(source, name, dataType, qualifier, nullability, id, synthetic);
        this.searchable = searchable;
    }

    public MetadataAttribute(Source source, String name, DataType dataType, boolean searchable) {
        this(source, name, dataType, null, Nullability.TRUE, null, false, searchable);
    }

    @Override
    protected MetadataAttribute clone(Source source, String name, DataType type, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        return new MetadataAttribute(source, name, type, qualifier, nullability, id, synthetic, this.searchable);
    }

    @Override
    protected String label() {
        return "m";
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, MetadataAttribute::new, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.searchable);
    }

    public boolean searchable() {
        return this.searchable;
    }

    private MetadataAttribute withSource(Source source) {
        return new MetadataAttribute(source, this.name(), this.dataType(), this.qualifier(), this.nullable(), this.id(), this.synthetic(), this.searchable());
    }

    public static MetadataAttribute create(Source source, String name) {
        Tuple<DataType, Boolean> t = ATTRIBUTES_MAP.get(name);
        return t != null ? new MetadataAttribute(source, name, (DataType)t.v1(), (Boolean)t.v2()) : null;
    }

    public static DataType dataType(String name) {
        Tuple<DataType, Boolean> t = ATTRIBUTES_MAP.get(name);
        return t != null ? (DataType)t.v1() : null;
    }

    public static boolean isSupported(String name) {
        return ATTRIBUTES_MAP.containsKey(name);
    }
}

