/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.execution.search.extractor;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.ConstantExtractor;

public class TotalHitsExtractor
extends ConstantExtractor {
    public TotalHitsExtractor(Long constant) {
        super(constant);
    }

    TotalHitsExtractor(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        return this.validate(super.extract(bucket));
    }

    @Override
    public Object extract(SearchHit hit) {
        return this.validate(super.extract(hit));
    }

    private Object validate(Object value) {
        if (!Number.class.isInstance(value)) {
            throw new QlIllegalArgumentException("Inconsistent total hits count handling, expected a numeric value but found a {}: {}", value == null ? null : value.getClass().getSimpleName(), value);
        }
        if (((Number)value).longValue() < 0L) {
            throw new QlIllegalArgumentException("Inconsistent total hits count handling, expected a non-negative value but found {}", value);
        }
        return value;
    }
}

