/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TopNOperatorStatus
implements Operator.Status {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "topn", TopNOperatorStatus::new);
    private final int occupiedRows;
    private final long ramBytesUsed;

    public TopNOperatorStatus(int occupiedRows, long ramBytesUsed) {
        this.occupiedRows = occupiedRows;
        this.ramBytesUsed = ramBytesUsed;
    }

    TopNOperatorStatus(StreamInput in) throws IOException {
        this.occupiedRows = in.readVInt();
        this.ramBytesUsed = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.occupiedRows);
        out.writeVLong(this.ramBytesUsed);
    }

    public String getWriteableName() {
        return TopNOperatorStatus.ENTRY.name;
    }

    public int occupiedRows() {
        return this.occupiedRows;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("occupied_rows", this.occupiedRows);
        builder.field("ram_bytes_used", this.ramBytesUsed);
        builder.field("ram_used", (ToXContent)ByteSizeValue.ofBytes((long)this.ramBytesUsed));
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopNOperatorStatus that = (TopNOperatorStatus)o;
        return this.occupiedRows == that.occupiedRows && this.ramBytesUsed == that.ramBytesUsed;
    }

    public int hashCode() {
        return Objects.hash(this.occupiedRows, this.ramBytesUsed);
    }
}

