/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class ResultBuilderForInt
implements ResultBuilder {
    private final IntBlock.Builder builder;
    private final boolean inKey;
    private int key;

    ResultBuilderForInt(BlockFactory blockFactory, TopNEncoder encoder, boolean inKey, int initialSize) {
        assert (encoder == TopNEncoder.DEFAULT_UNSORTABLE) : encoder.toString();
        this.inKey = inKey;
        this.builder = IntBlock.newBlockBuilder(initialSize, blockFactory);
    }

    @Override
    public void decodeKey(BytesRef keys) {
        assert (this.inKey);
        this.key = TopNEncoder.DEFAULT_SORTABLE.decodeInt(keys);
    }

    @Override
    public void decodeValue(BytesRef values) {
        int count = TopNEncoder.DEFAULT_UNSORTABLE.decodeVInt(values);
        switch (count) {
            case 0: {
                this.builder.appendNull();
                break;
            }
            case 1: {
                this.builder.appendInt(this.inKey ? this.key : this.readValueFromValues(values));
                break;
            }
            default: {
                this.builder.beginPositionEntry();
                for (int i = 0; i < count; ++i) {
                    this.builder.appendInt(this.readValueFromValues(values));
                }
                this.builder.endPositionEntry();
            }
        }
    }

    private int readValueFromValues(BytesRef values) {
        return TopNEncoder.DEFAULT_UNSORTABLE.decodeInt(values);
    }

    @Override
    public IntBlock build() {
        return this.builder.build();
    }

    public String toString() {
        return "ResultBuilderForInt[inKey=" + this.inKey + "]";
    }

    public void close() {
        this.builder.close();
    }
}

