/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.TransportResponse;

public final class ExchangeResponse
extends TransportResponse
implements Releasable {
    private final RefCounted counted = AbstractRefCounted.of(this::close);
    private final Page page;
    private final boolean finished;
    private boolean pageTaken;

    public ExchangeResponse(Page page, boolean finished) {
        this.page = page;
        this.finished = finished;
    }

    public ExchangeResponse(BlockStreamInput in) throws IOException {
        super((StreamInput)in);
        this.page = (Page)in.readOptionalWriteable(Page::new);
        this.finished = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.page);
        out.writeBoolean(this.finished);
    }

    @Nullable
    public Page takePage() {
        if (this.pageTaken) {
            assert (false) : "Page was taken already";
            throw new IllegalStateException("Page was taken already");
        }
        this.pageTaken = true;
        return this.page;
    }

    public boolean finished() {
        return this.finished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExchangeResponse response = (ExchangeResponse)((Object)o);
        return this.finished == response.finished && Objects.equals(this.page, response.page);
    }

    public int hashCode() {
        return Objects.hash(this.page, this.finished);
    }

    public void incRef() {
        this.counted.incRef();
    }

    public boolean tryIncRef() {
        return this.counted.tryIncRef();
    }

    public boolean decRef() {
        return this.counted.decRef();
    }

    public boolean hasReferences() {
        return this.counted.hasReferences();
    }

    public void close() {
        if (!this.pageTaken && this.page != null) {
            this.page.releaseBlocks();
        }
    }
}

