/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SinkOperator;

public class OutputOperator
extends SinkOperator {
    private final List<String> columns;
    private final Consumer<Page> pageConsumer;
    private final Function<Page, Page> mapper;
    boolean finished = false;

    public OutputOperator(List<String> columns, Function<Page, Page> mapper, Consumer<Page> pageConsumer) {
        this.columns = columns;
        this.mapper = mapper;
        this.pageConsumer = pageConsumer;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        this.pageConsumer.accept(this.mapper.apply(page));
    }

    @Override
    public void close() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("columns=").append(this.columns).append(", ");
        sb.append("pageConsumer=").append(this.pageConsumer);
        sb.append("]");
        return sb.toString();
    }

    public record OutputOperatorFactory(List<String> columns, Function<Page, Page> mapper, Consumer<Page> pageConsumer) implements SinkOperator.SinkOperatorFactory
    {
        @Override
        public SinkOperator get(DriverContext driverContext) {
            return new OutputOperator(this.columns, this.mapper, this.pageConsumer);
        }

        @Override
        public String describe() {
            return "OutputOperator[columns = " + this.columns.stream().collect(Collectors.joining(", ")) + "]";
        }
    }
}

