/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.BatchEncoder;
import org.elasticsearch.compute.operator.MultivalueDedupe;

public class MultivalueDedupeInt {
    private static final int ALWAYS_COPY_MISSING = 300;
    private final Block.Ref ref;
    private final IntBlock block;
    private int[] work = new int[ArrayUtil.oversize((int)2, (int)4)];
    private int w;

    public MultivalueDedupeInt(Block.Ref ref) {
        this.ref = ref;
        this.block = (IntBlock)ref.block();
    }

    public Block.Ref dedupeToBlockAdaptive(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            return this.ref;
        }
        try (Block.Ref ref = this.ref;){
            Block.Ref ref2;
            block19: {
                IntBlock.Builder builder = IntBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);
                try {
                    block14: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                        int count = this.block.getValueCount(p);
                        int first = this.block.getFirstValueIndex(p);
                        switch (count) {
                            case 0: {
                                builder.appendNull();
                                continue block14;
                            }
                            case 1: {
                                builder.appendInt(this.block.getInt(first));
                                continue block14;
                            }
                            default: {
                                if (count < 300) {
                                    this.copyMissing(first, count);
                                    this.writeUniquedWork(builder);
                                    continue block14;
                                }
                                this.copyAndSort(first, count);
                                this.writeSortedWork(builder);
                            }
                        }
                    }
                    ref2 = Block.Ref.floating(builder.build());
                    if (builder == null) break block19;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref2;
        }
    }

    public Block.Ref dedupeToBlockUsingCopyAndSort(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            return this.ref;
        }
        try (Block.Ref ref = this.ref;){
            Block.Ref ref2;
            block18: {
                IntBlock.Builder builder = IntBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);
                try {
                    block14: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                        int count = this.block.getValueCount(p);
                        int first = this.block.getFirstValueIndex(p);
                        switch (count) {
                            case 0: {
                                builder.appendNull();
                                continue block14;
                            }
                            case 1: {
                                builder.appendInt(this.block.getInt(first));
                                continue block14;
                            }
                            default: {
                                this.copyAndSort(first, count);
                                this.writeSortedWork(builder);
                            }
                        }
                    }
                    ref2 = Block.Ref.floating(builder.build());
                    if (builder == null) break block18;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref2;
        }
    }

    public Block.Ref dedupeToBlockUsingCopyMissing(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            return this.ref;
        }
        try (Block.Ref ref = this.ref;){
            Block.Ref ref2;
            block18: {
                IntBlock.Builder builder = IntBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);
                try {
                    block14: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                        int count = this.block.getValueCount(p);
                        int first = this.block.getFirstValueIndex(p);
                        switch (count) {
                            case 0: {
                                builder.appendNull();
                                continue block14;
                            }
                            case 1: {
                                builder.appendInt(this.block.getInt(first));
                                continue block14;
                            }
                            default: {
                                this.copyMissing(first, count);
                                this.writeUniquedWork(builder);
                            }
                        }
                    }
                    ref2 = Block.Ref.floating(builder.build());
                    if (builder == null) break block18;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref2;
        }
    }

    public MultivalueDedupe.HashResult hash(LongHash hash) {
        try (IntBlock.Builder builder = IntBlock.newBlockBuilder(this.block.getPositionCount());){
            boolean sawNull = false;
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        sawNull = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        int v = this.block.getInt(first);
                        this.hash(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 300) {
                            this.copyMissing(first, count);
                            this.hashUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashSortedWork(hash, builder);
                    }
                }
            }
            MultivalueDedupe.HashResult hashResult = new MultivalueDedupe.HashResult(builder.build(), sawNull);
            return hashResult;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        return new BatchEncoder.Ints(batchSize){

            @Override
            protected void readNextBatch() {
                int position = this.firstPosition();
                if (MultivalueDedupeInt.this.w > 0) {
                    this.ensureCapacity(MultivalueDedupeInt.this.w);
                    this.startPosition();
                    MultivalueDedupeInt.this.encodeUniquedWork(this);
                    this.endPosition();
                    ++position;
                }
                while (position < MultivalueDedupeInt.this.block.getPositionCount()) {
                    int count = MultivalueDedupeInt.this.block.getValueCount(position);
                    int first = MultivalueDedupeInt.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            break;
                        }
                        case 1: {
                            int v = MultivalueDedupeInt.this.block.getInt(first);
                            if (this.hasCapacity(1)) {
                                this.startPosition();
                                this.encode(v);
                                this.endPosition();
                                break;
                            }
                            MultivalueDedupeInt.this.work[0] = v;
                            MultivalueDedupeInt.this.w = 1;
                            return;
                        }
                        default: {
                            if (count < 300) {
                                MultivalueDedupeInt.this.copyMissing(first, count);
                            } else {
                                MultivalueDedupeInt.this.copyAndSort(first, count);
                                MultivalueDedupeInt.this.convertSortedWorkToUnique();
                            }
                            if (this.hasCapacity(MultivalueDedupeInt.this.w)) {
                                this.startPosition();
                                MultivalueDedupeInt.this.encodeUniquedWork(this);
                                this.endPosition();
                                break;
                            }
                            return;
                        }
                    }
                    ++position;
                }
            }
        };
    }

    private void copyAndSort(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.w = 0;
        for (int i = first; i < end; ++i) {
            this.work[this.w++] = this.block.getInt(i);
        }
        Arrays.sort(this.work, 0, this.w);
    }

    private void copyMissing(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.work[0] = this.block.getInt(first);
        this.w = 1;
        block0: for (int i = first + 1; i < end; ++i) {
            int v = this.block.getInt(i);
            for (int j = 0; j < this.w; ++j) {
                if (v == this.work[j]) continue block0;
            }
            this.work[this.w++] = v;
        }
    }

    private void writeUniquedWork(IntBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendInt(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            builder.appendInt(this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void writeSortedWork(IntBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendInt(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        int prev = this.work[0];
        builder.appendInt(prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            builder.appendInt(prev);
        }
        builder.endPositionEntry();
    }

    private void hashUniquedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hash(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            this.hash(builder, hash, this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void hashSortedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hash(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        int prev = this.work[0];
        this.hash(builder, hash, prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            this.hash(builder, hash, prev);
        }
        builder.endPositionEntry();
    }

    private void encodeUniquedWork(BatchEncoder.Ints encoder) {
        for (int i = 0; i < this.w; ++i) {
            encoder.encode(this.work[i]);
        }
    }

    private void convertSortedWorkToUnique() {
        int prev = this.work[0];
        int end = this.w;
        this.w = 1;
        for (int i = 1; i < end; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            this.work[this.w++] = prev;
        }
    }

    private void grow(int size) {
        this.work = ArrayUtil.grow((int[])this.work, (int)size);
    }

    private void hash(IntBlock.Builder builder, LongHash hash, int v) {
        builder.appendInt(Math.toIntExact(BlockHash.hashOrdToGroupNullReserved(hash.add((long)v))));
    }
}

