/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.BatchEncoder;

public class MultivalueDedupeBoolean {
    public static final int NULL_ORD = 0;
    public static final int FALSE_ORD = 1;
    public static final int TRUE_ORD = 2;
    private final Block.Ref ref;
    private final BooleanBlock block;
    private boolean seenTrue;
    private boolean seenFalse;

    public MultivalueDedupeBoolean(Block.Ref ref) {
        this.ref = ref;
        this.block = (BooleanBlock)ref.block();
    }

    public Block.Ref dedupeToBlock(BlockFactory blockFactory) {
        if (!this.block.mayHaveMultivaluedFields()) {
            return this.ref;
        }
        try (Block.Ref ref = this.ref;){
            Block.Ref ref2;
            block18: {
                BooleanBlock.Builder builder = BooleanBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);
                try {
                    block14: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                        int count = this.block.getValueCount(p);
                        int first = this.block.getFirstValueIndex(p);
                        switch (count) {
                            case 0: {
                                builder.appendNull();
                                continue block14;
                            }
                            case 1: {
                                builder.appendBoolean(this.block.getBoolean(first));
                                continue block14;
                            }
                            default: {
                                this.readValues(first, count);
                                this.writeValues(builder);
                            }
                        }
                    }
                    ref2 = Block.Ref.floating(builder.build());
                    if (builder == null) break block18;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return ref2;
        }
    }

    public IntBlock hash(boolean[] everSeen) {
        try (IntBlock.Builder builder = IntBlock.newBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        everSeen[0] = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, this.block.getBoolean(first)));
                        continue block9;
                    }
                    default: {
                        this.readValues(first, count);
                        this.hashValues(everSeen, builder);
                    }
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        return new BatchEncoder.Booleans(Math.max(2, batchSize)){

            @Override
            protected void readNextBatch() {
                block4: for (int position = this.firstPosition(); position < MultivalueDedupeBoolean.this.block.getPositionCount(); ++position) {
                    if (!this.hasCapacity(2)) {
                        return;
                    }
                    int count = MultivalueDedupeBoolean.this.block.getValueCount(position);
                    int first = MultivalueDedupeBoolean.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            continue block4;
                        }
                        case 1: {
                            boolean v = MultivalueDedupeBoolean.this.block.getBoolean(first);
                            this.startPosition();
                            this.encode(v);
                            this.endPosition();
                            continue block4;
                        }
                        default: {
                            MultivalueDedupeBoolean.this.readValues(first, count);
                            this.startPosition();
                            MultivalueDedupeBoolean.this.encodeUniquedWork(this);
                            this.endPosition();
                        }
                    }
                }
            }
        };
    }

    private void readValues(int first, int count) {
        int end = first + count;
        this.seenFalse = false;
        this.seenTrue = false;
        for (int i = first; i < end; ++i) {
            if (this.block.getBoolean(i)) {
                this.seenTrue = true;
                if (!this.seenFalse) continue;
                break;
            }
            this.seenFalse = true;
            if (this.seenTrue) break;
        }
    }

    private void writeValues(BooleanBlock.Builder builder) {
        if (this.seenFalse) {
            if (this.seenTrue) {
                builder.beginPositionEntry();
                builder.appendBoolean(false);
                builder.appendBoolean(true);
                builder.endPositionEntry();
            } else {
                builder.appendBoolean(false);
            }
        } else if (this.seenTrue) {
            builder.appendBoolean(true);
        } else {
            throw new IllegalStateException("didn't see true of false but counted values");
        }
    }

    private void hashValues(boolean[] everSeen, IntBlock.Builder builder) {
        if (this.seenFalse) {
            if (this.seenTrue) {
                builder.beginPositionEntry();
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, false));
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, true));
                builder.endPositionEntry();
            } else {
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, false));
            }
        } else if (this.seenTrue) {
            builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, true));
        } else {
            throw new IllegalStateException("didn't see true of false but counted values");
        }
    }

    private void encodeUniquedWork(BatchEncoder.Booleans encoder) {
        if (this.seenFalse) {
            encoder.encode(false);
        }
        if (this.seenTrue) {
            encoder.encode(true);
        }
    }

    public static int hashOrd(boolean[] everSeen, boolean b) {
        if (b) {
            everSeen[2] = true;
            return 2;
        }
        everSeen[1] = true;
        return 1;
    }
}

