/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BatchEncoder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.MultivalueDedupeBoolean;
import org.elasticsearch.compute.operator.MultivalueDedupeBytesRef;
import org.elasticsearch.compute.operator.MultivalueDedupeDouble;
import org.elasticsearch.compute.operator.MultivalueDedupeInt;
import org.elasticsearch.compute.operator.MultivalueDedupeLong;

public final class MultivalueDedupe {
    public static Block.Ref dedupeToBlockAdaptive(Block.Ref ref, BlockFactory blockFactory) {
        return switch (ref.block().elementType()) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean(ref).dedupeToBlock(blockFactory);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef(ref).dedupeToBlockAdaptive(blockFactory);
            case ElementType.INT -> new MultivalueDedupeInt(ref).dedupeToBlockAdaptive(blockFactory);
            case ElementType.LONG -> new MultivalueDedupeLong(ref).dedupeToBlockAdaptive(blockFactory);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble(ref).dedupeToBlockAdaptive(blockFactory);
            default -> throw new IllegalArgumentException();
        };
    }

    public static Block.Ref dedupeToBlockUsingCopyMissing(Block.Ref ref, BlockFactory blockFactory) {
        return switch (ref.block().elementType()) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean(ref).dedupeToBlock(blockFactory);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef(ref).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.INT -> new MultivalueDedupeInt(ref).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.LONG -> new MultivalueDedupeLong(ref).dedupeToBlockUsingCopyMissing(blockFactory);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble(ref).dedupeToBlockUsingCopyMissing(blockFactory);
            default -> throw new IllegalArgumentException();
        };
    }

    public static Block.Ref dedupeToBlockUsingCopyAndSort(Block.Ref ref, BlockFactory blockFactory) {
        return switch (ref.block().elementType()) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean(ref).dedupeToBlock(blockFactory);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef(ref).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.INT -> new MultivalueDedupeInt(ref).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.LONG -> new MultivalueDedupeLong(ref).dedupeToBlockUsingCopyAndSort(blockFactory);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble(ref).dedupeToBlockUsingCopyAndSort(blockFactory);
            default -> throw new IllegalArgumentException();
        };
    }

    public static EvalOperator.ExpressionEvaluator.Factory evaluator(ElementType elementType, EvalOperator.ExpressionEvaluator.Factory nextSupplier) {
        return switch (elementType) {
            case ElementType.BOOLEAN -> dvrCtx -> new MvDedupeEvaluator(nextSupplier.get(dvrCtx)){

                @Override
                public Block.Ref eval(Page page) {
                    return new MultivalueDedupeBoolean(this.field.eval(page)).dedupeToBlock(dvrCtx.blockFactory());
                }
            };
            case ElementType.BYTES_REF -> dvrCtx -> new MvDedupeEvaluator(nextSupplier.get(dvrCtx)){

                @Override
                public Block.Ref eval(Page page) {
                    return new MultivalueDedupeBytesRef(this.field.eval(page)).dedupeToBlockAdaptive(dvrCtx.blockFactory());
                }
            };
            case ElementType.INT -> dvrCtx -> new MvDedupeEvaluator(nextSupplier.get(dvrCtx)){

                @Override
                public Block.Ref eval(Page page) {
                    return new MultivalueDedupeInt(this.field.eval(page)).dedupeToBlockAdaptive(dvrCtx.blockFactory());
                }
            };
            case ElementType.LONG -> dvrCtx -> new MvDedupeEvaluator(nextSupplier.get(dvrCtx)){

                @Override
                public Block.Ref eval(Page page) {
                    return new MultivalueDedupeLong(this.field.eval(page)).dedupeToBlockAdaptive(dvrCtx.blockFactory());
                }
            };
            case ElementType.DOUBLE -> dvrCtx -> new MvDedupeEvaluator(nextSupplier.get(dvrCtx)){

                @Override
                public Block.Ref eval(Page page) {
                    return new MultivalueDedupeDouble(this.field.eval(page)).dedupeToBlockAdaptive(dvrCtx.blockFactory());
                }
            };
            case ElementType.NULL -> dvrCtx -> new MvDedupeEvaluator(nextSupplier.get(dvrCtx)){

                @Override
                public Block.Ref eval(Page page) {
                    return this.field.eval(page);
                }
            };
            default -> throw new IllegalArgumentException("unsupported type [" + elementType + "]");
        };
    }

    public static BatchEncoder batchEncoder(Block.Ref ref, int batchSize, boolean allowDirectEncoder) {
        if (ref.block().areAllValuesNull()) {
            return new BatchEncoder.DirectNulls(ref.block());
        }
        ElementType elementType = ref.block().elementType();
        if (allowDirectEncoder && ref.block().mvDeduplicated()) {
            Block block = ref.block();
            return switch (elementType) {
                case ElementType.BOOLEAN -> new BatchEncoder.DirectBooleans((BooleanBlock)block);
                case ElementType.BYTES_REF -> new BatchEncoder.DirectBytesRefs((BytesRefBlock)block);
                case ElementType.INT -> new BatchEncoder.DirectInts((IntBlock)block);
                case ElementType.LONG -> new BatchEncoder.DirectLongs((LongBlock)block);
                case ElementType.DOUBLE -> new BatchEncoder.DirectDoubles((DoubleBlock)block);
                default -> throw new IllegalArgumentException("Unknown [" + elementType + "]");
            };
        }
        return switch (elementType) {
            case ElementType.BOOLEAN -> new MultivalueDedupeBoolean(ref).batchEncoder(batchSize);
            case ElementType.BYTES_REF -> new MultivalueDedupeBytesRef(ref).batchEncoder(batchSize);
            case ElementType.INT -> new MultivalueDedupeInt(ref).batchEncoder(batchSize);
            case ElementType.LONG -> new MultivalueDedupeLong(ref).batchEncoder(batchSize);
            case ElementType.DOUBLE -> new MultivalueDedupeDouble(ref).batchEncoder(batchSize);
            default -> throw new IllegalArgumentException();
        };
    }

    private MultivalueDedupe() {
    }

    private static abstract class MvDedupeEvaluator
    implements EvalOperator.ExpressionEvaluator {
        protected final EvalOperator.ExpressionEvaluator field;

        private MvDedupeEvaluator(EvalOperator.ExpressionEvaluator field) {
            this.field = field;
        }

        public String toString() {
            return "MvDedupe[field=" + this.field + "]";
        }

        public void close() {
        }
    }

    public record HashResult(IntBlock ords, boolean sawNull) {
    }
}

