/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class LimitOperator
implements Operator {
    private final int limit;
    private int limitRemaining;
    private int pagesProcessed;
    private Page lastInput;
    private boolean finished;

    public LimitOperator(int limit) {
        this.limit = this.limitRemaining = limit;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.lastInput == null;
    }

    @Override
    public void addInput(Page page) {
        assert (this.lastInput == null) : "has pending input page";
        this.lastInput = page;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.lastInput == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getOutput() {
        Page result;
        if (this.lastInput == null) {
            return null;
        }
        if (this.lastInput.getPositionCount() <= this.limitRemaining) {
            result = this.lastInput;
            this.limitRemaining -= this.lastInput.getPositionCount();
        } else {
            int[] filter = new int[this.limitRemaining];
            for (int i = 0; i < this.limitRemaining; ++i) {
                filter[i] = i;
            }
            Releasable[] blocks = new Block[this.lastInput.getBlockCount()];
            boolean success = false;
            try {
                for (int b = 0; b < blocks.length; ++b) {
                    blocks[b] = this.lastInput.getBlock(b).filter(filter);
                }
                success = true;
            }
            finally {
                Releasables.closeExpectNoException(this.lastInput::releaseBlocks);
                this.lastInput = null;
                if (!success) {
                    Releasables.closeExpectNoException((Releasable[])blocks);
                }
            }
            result = new Page((Block[])blocks);
            this.limitRemaining = 0;
        }
        if (this.limitRemaining == 0) {
            this.finished = true;
        }
        this.lastInput = null;
        ++this.pagesProcessed;
        return result;
    }

    @Override
    public Status status() {
        return new Status(this.limit, this.limitRemaining, this.pagesProcessed);
    }

    @Override
    public void close() {
        if (this.lastInput != null) {
            this.lastInput.releaseBlocks();
        }
    }

    public String toString() {
        return "LimitOperator[limit = " + this.limitRemaining + "/" + this.limit + "]";
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "limit", Status::new);
        private final int limit;
        private final int limitRemaining;
        private final int pagesProcessed;

        protected Status(int limit, int limitRemaining, int pagesProcessed) {
            this.limit = limit;
            this.limitRemaining = limitRemaining;
            this.pagesProcessed = pagesProcessed;
        }

        protected Status(StreamInput in) throws IOException {
            this.limit = in.readVInt();
            this.limitRemaining = in.readVInt();
            this.pagesProcessed = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.limit);
            out.writeVInt(this.limitRemaining);
            out.writeVInt(this.pagesProcessed);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int limit() {
            return this.limit;
        }

        public int limitRemaining() {
            return this.limitRemaining;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("limit", this.limit);
            builder.field("limit_remaining", this.limitRemaining);
            builder.field("pages_processed", this.pagesProcessed);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.limit == status.limit && this.limitRemaining == status.limitRemaining && this.pagesProcessed == status.pagesProcessed;
        }

        public int hashCode() {
            return Objects.hash(this.limit, this.limitRemaining, this.pagesProcessed);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record Factory(int limit) implements Operator.OperatorFactory
    {
        @Override
        public LimitOperator get(DriverContext driverContext) {
            return new LimitOperator(this.limit);
        }

        @Override
        public String describe() {
            return "LimitOperator[limit = " + this.limit + "]";
        }
    }
}

