/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class HashAggregationOperator
implements Operator {
    private boolean finished;
    private Page output;
    private final BlockHash blockHash;
    private final List<GroupingAggregator> aggregators;
    private final DriverContext driverContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashAggregationOperator(List<GroupingAggregator.Factory> aggregators, Supplier<BlockHash> blockHash, DriverContext driverContext) {
        this.aggregators = new ArrayList<GroupingAggregator>(aggregators.size());
        this.driverContext = driverContext;
        boolean success = false;
        try {
            this.blockHash = blockHash.get();
            for (GroupingAggregator.Factory a : aggregators) {
                this.aggregators.add((GroupingAggregator)a.apply(driverContext));
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInput(Page page) {
        try {
            HashAggregationOperator.checkState(this.needsInput(), "Operator is already finishing");
            Objects.requireNonNull(page, "page is null");
            final GroupingAggregatorFunction.AddInput[] prepared = new GroupingAggregatorFunction.AddInput[this.aggregators.size()];
            for (int i = 0; i < prepared.length; ++i) {
                prepared[i] = this.aggregators.get(i).prepareProcessPage(this.blockHash, page);
            }
            this.blockHash.add(this.wrapPage(page), new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    IntVector groupIdsVector = groupIds.asVector();
                    if (groupIdsVector != null) {
                        this.add(positionOffset, groupIdsVector);
                    } else {
                        for (GroupingAggregatorFunction.AddInput p : prepared) {
                            p.add(positionOffset, groupIds);
                        }
                    }
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    for (GroupingAggregatorFunction.AddInput p : prepared) {
                        p.add(positionOffset, groupIds);
                    }
                }
            });
        }
        finally {
            page.releaseBlocks();
        }
    }

    @Override
    public Page getOutput() {
        Page p = this.output;
        this.output = null;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        boolean success;
        Releasable[] blocks;
        block7: {
            if (this.finished) {
                return;
            }
            this.finished = true;
            blocks = null;
            IntVector selected = null;
            success = false;
            try {
                selected = this.blockHash.nonEmpty();
                Block[] keys = this.blockHash.getKeys();
                int[] aggBlockCounts = this.aggregators.stream().mapToInt(GroupingAggregator::evaluateBlockCount).toArray();
                blocks = new Block[keys.length + Arrays.stream(aggBlockCounts).sum()];
                System.arraycopy(keys, 0, blocks, 0, keys.length);
                int offset = keys.length;
                for (int i = 0; i < this.aggregators.size(); ++i) {
                    GroupingAggregator aggregator = this.aggregators.get(i);
                    aggregator.evaluate((Block[])blocks, offset, selected, this.driverContext);
                    offset += aggBlockCounts[i];
                }
                this.output = new Page((Block[])blocks);
                success = true;
                if (selected == null) break block7;
            }
            catch (Throwable throwable) {
                if (selected != null) {
                    Releasables.closeExpectNoException((Releasable)selected.asBlock());
                }
                if (!success && blocks != null) {
                    Releasables.closeExpectNoException(blocks);
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable)selected.asBlock());
        }
        if (!success && blocks != null) {
            Releasables.closeExpectNoException((Releasable[])blocks);
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.output == null;
    }

    @Override
    public void close() {
        if (this.output != null) {
            this.output.releaseBlocks();
        }
        Releasables.close((Releasable[])new Releasable[]{this.blockHash, () -> Releasables.close(this.aggregators)});
    }

    protected static void checkState(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    protected Page wrapPage(Page page) {
        return page;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("blockHash=").append(this.blockHash).append(", ");
        sb.append("aggregators=").append(this.aggregators);
        sb.append("]");
        return sb.toString();
    }

    public record HashAggregationOperatorFactory(List<GroupSpec> groups, List<GroupingAggregator.Factory> aggregators, int maxPageSize, BigArrays bigArrays) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new HashAggregationOperator(this.aggregators, () -> BlockHash.build(this.groups, driverContext, this.maxPageSize, false), driverContext);
        }

        @Override
        public String describe() {
            return "HashAggregationOperator[mode = <not-needed>, aggs = " + this.aggregators.stream().map(Describable::describe).collect(Collectors.joining(", ")) + "]";
        }
    }

    public record GroupSpec(int channel, ElementType elementType) {
    }
}

