/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract class DriverRunner {
    private final ThreadContext threadContext;

    public DriverRunner(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    protected abstract void start(Driver var1, ActionListener<Void> var2);

    public void runToCompletion(final List<Driver> drivers, final ActionListener<Void> listener) {
        final AtomicReference failure = new AtomicReference();
        final AtomicArray responseHeaders = new AtomicArray(drivers.size());
        final CountDown counter = new CountDown(drivers.size());
        int i = 0;
        while (i < drivers.size()) {
            final Driver driver = drivers.get(i);
            final int driverIndex = i++;
            ActionListener<Void> driverListener = new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    this.done();
                }

                public void onFailure(Exception e) {
                    failure.getAndUpdate(first -> {
                        if (first == null) {
                            return e;
                        }
                        if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                            return first;
                        }
                        if (ExceptionsHelper.unwrap((Throwable)first, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                            return e;
                        }
                        if (first != e) {
                            first.addSuppressed(e);
                        }
                        return first;
                    });
                    for (Driver d : drivers) {
                        if (driver == d) continue;
                        d.cancel("Driver [" + driver.sessionId() + "] was cancelled or failed");
                    }
                    this.done();
                }

                private void done() {
                    responseHeaders.setOnce(driverIndex, (Object)DriverRunner.this.threadContext.getResponseHeaders());
                    if (counter.countDown()) {
                        DriverRunner.this.mergeResponseHeaders((AtomicArray<Map<String, List<String>>>)responseHeaders);
                        Exception error = (Exception)failure.get();
                        if (error != null) {
                            listener.onFailure(error);
                        } else {
                            listener.onResponse(null);
                        }
                    }
                }
            };
            this.start(driver, driverListener);
        }
    }

    private void mergeResponseHeaders(AtomicArray<Map<String, List<String>>> responseHeaders) {
        HashMap<String, Set> merged = new HashMap<String, Set>();
        for (int i = 0; i < responseHeaders.length(); ++i) {
            Map resp = (Map)responseHeaders.get(i);
            if (resp == null || resp.isEmpty()) continue;
            for (Map.Entry e : resp.entrySet()) {
                merged.computeIfAbsent((String)e.getKey(), k -> new LinkedHashSet(((List)e.getValue()).size())).addAll((Collection)e.getValue());
            }
        }
        for (Map.Entry e : merged.entrySet()) {
            for (String v : (Set)e.getValue()) {
                this.threadContext.addResponseHeader((String)e.getKey(), v);
            }
        }
    }
}

