/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class DriverContext {
    Set<Releasable> workingSet = Collections.newSetFromMap(new IdentityHashMap());
    private final AtomicReference<Snapshot> snapshot = new AtomicReference();
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;

    public DriverContext(BigArrays bigArrays, BlockFactory blockFactory) {
        Objects.requireNonNull(bigArrays);
        Objects.requireNonNull(blockFactory);
        this.bigArrays = bigArrays;
        this.blockFactory = blockFactory;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public CircuitBreaker breaker() {
        return this.blockFactory.breaker();
    }

    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    public boolean addReleasable(Releasable releasable) {
        return this.workingSet.add(releasable);
    }

    public boolean removeReleasable(Releasable releasable) {
        return this.workingSet.remove(releasable);
    }

    public Snapshot getSnapshot() {
        this.ensureFinished();
        return this.snapshot.get();
    }

    public boolean isFinished() {
        return this.snapshot.get() != null;
    }

    public void finish() {
        if (this.isFinished()) {
            return;
        }
        Iterator<Releasable> itr = this.workingSet.iterator();
        this.workingSet = null;
        Set<Releasable> releasableSet = Collections.newSetFromMap(new IdentityHashMap());
        while (itr.hasNext()) {
            Releasable r = itr.next();
            releasableSet.add(r);
            itr.remove();
        }
        this.snapshot.compareAndSet(null, new Snapshot(releasableSet));
    }

    private void ensureFinished() {
        if (!this.isFinished()) {
            throw new IllegalStateException("not finished");
        }
    }

    public record Snapshot(Set<Releasable> releasables) implements Releasable
    {
        public void close() {
            Releasables.close(this.releasables);
        }
    }
}

