/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.TaskCancelledException;

public class Driver
implements Releasable,
Describable {
    public static final TimeValue DEFAULT_TIME_BEFORE_YIELDING = TimeValue.timeValueMinutes((long)5L);
    public static final int DEFAULT_MAX_ITERATIONS = 10000;
    public static final TimeValue DEFAULT_STATUS_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    private final String sessionId;
    private final DriverContext driverContext;
    private final Supplier<String> description;
    private final List<Operator> activeOperators;
    private final Releasable releasable;
    private final long statusNanos;
    private final AtomicReference<String> cancelReason = new AtomicReference();
    private final AtomicReference<SubscribableListener<Void>> blocked = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean();
    private final SubscribableListener<Void> completionListener = new SubscribableListener();
    private final AtomicReference<DriverStatus> status;

    public Driver(String sessionId, DriverContext driverContext, Supplier<String> description, SourceOperator source, List<Operator> intermediateOperators, SinkOperator sink, TimeValue statusInterval, Releasable releasable) {
        this.sessionId = sessionId;
        this.driverContext = driverContext;
        this.description = description;
        this.activeOperators = new ArrayList<Operator>();
        this.activeOperators.add(source);
        this.activeOperators.addAll(intermediateOperators);
        this.activeOperators.add(sink);
        this.statusNanos = statusInterval.nanos();
        this.releasable = releasable;
        this.status = new AtomicReference<DriverStatus>(new DriverStatus(sessionId, System.currentTimeMillis(), DriverStatus.Status.QUEUED, List.of()));
    }

    public Driver(DriverContext driverContext, SourceOperator source, List<Operator> intermediateOperators, SinkOperator sink, Releasable releasable) {
        this("unset", driverContext, () -> null, source, intermediateOperators, sink, DEFAULT_STATUS_INTERVAL, releasable);
    }

    public DriverContext driverContext() {
        return this.driverContext;
    }

    private SubscribableListener<Void> run(TimeValue maxTime, int maxIterations) {
        long maxTimeNanos = maxTime.nanos();
        long startTime = System.nanoTime();
        long nextStatus = startTime + this.statusNanos;
        int iter = 0;
        while (!this.isFinished()) {
            SubscribableListener<Void> fut = this.runSingleLoopIteration();
            if (!fut.isDone()) {
                this.status.set(this.updateStatus(DriverStatus.Status.ASYNC));
                return fut;
            }
            if (iter >= maxIterations) break;
            long now = System.nanoTime();
            if (now > nextStatus) {
                this.status.set(this.updateStatus(DriverStatus.Status.RUNNING));
                nextStatus = now + this.statusNanos;
            }
            ++iter;
            if (now - startTime <= maxTimeNanos) continue;
            break;
        }
        if (this.isFinished()) {
            this.status.set(this.updateStatus(DriverStatus.Status.DONE));
            this.driverContext.finish();
            Releasables.close((Releasable[])new Releasable[]{this.releasable, this.driverContext.getSnapshot()});
        } else {
            this.status.set(this.updateStatus(DriverStatus.Status.WAITING));
        }
        return Operator.NOT_BLOCKED;
    }

    private boolean isFinished() {
        return this.activeOperators.isEmpty();
    }

    public void close() {
        this.drainAndCloseOperators(null);
    }

    public void abort(Exception reason, ActionListener<Void> listener) {
        this.completionListener.addListener(listener);
        if (this.started.compareAndSet(false, true)) {
            this.drainAndCloseOperators(reason);
            this.completionListener.onFailure(reason);
        } else {
            this.cancel(reason.getMessage());
        }
    }

    private SubscribableListener<Void> runSingleLoopIteration() {
        this.ensureNotCancelled();
        boolean movedPage = false;
        for (int i = 0; i < this.activeOperators.size() - 1; ++i) {
            Page page;
            Operator op = this.activeOperators.get(i);
            Operator nextOp = this.activeOperators.get(i + 1);
            if (!op.isBlocked().isDone()) continue;
            if (!op.isFinished() && nextOp.needsInput() && (page = op.getOutput()) != null) {
                if (page.getPositionCount() == 0) {
                    page.releaseBlocks();
                } else {
                    nextOp.addInput(page);
                    movedPage = true;
                }
            }
            if (!op.isFinished()) continue;
            nextOp.finish();
        }
        for (int index = this.activeOperators.size() - 1; index >= 0; --index) {
            if (!this.activeOperators.get(index).isFinished()) continue;
            List<Operator> finishedOperators = this.activeOperators.subList(0, index + 1);
            Iterator<Operator> itr = finishedOperators.iterator();
            while (itr.hasNext()) {
                itr.next().close();
                itr.remove();
            }
            if (this.activeOperators.isEmpty()) break;
            Operator newRootOperator = this.activeOperators.get(0);
            newRootOperator.finish();
            break;
        }
        if (!movedPage) {
            return Driver.oneOf(this.activeOperators.stream().map(Operator::isBlocked).filter(laf -> !laf.isDone()).collect(Collectors.toList()));
        }
        return Operator.NOT_BLOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String reason) {
        if (this.cancelReason.compareAndSet(null, reason)) {
            Driver driver = this;
            synchronized (driver) {
                SubscribableListener<Void> fut = this.blocked.get();
                if (fut != null) {
                    fut.onFailure((Exception)new TaskCancelledException(reason));
                }
            }
        }
    }

    private boolean isCancelled() {
        return this.cancelReason.get() != null;
    }

    private void ensureNotCancelled() {
        String reason = this.cancelReason.get();
        if (reason != null) {
            throw new TaskCancelledException(reason);
        }
    }

    public static void start(ThreadContext threadContext, Executor executor, Driver driver, int maxIterations, ActionListener<Void> listener) {
        driver.completionListener.addListener(listener);
        if (driver.started.compareAndSet(false, true)) {
            driver.status.set(driver.updateStatus(DriverStatus.Status.STARTING));
            Driver.schedule(DEFAULT_TIME_BEFORE_YIELDING, maxIterations, threadContext, executor, driver, driver.completionListener);
        }
    }

    private void drainAndCloseOperators(@Nullable Exception e) {
        Iterator<Operator> itr = this.activeOperators.iterator();
        while (itr.hasNext()) {
            block3: {
                try {
                    Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{itr.next()});
                }
                catch (Exception x) {
                    if (e == null) break block3;
                    e.addSuppressed(x);
                }
            }
            itr.remove();
        }
        this.driverContext.finish();
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.releasable, this.driverContext.getSnapshot()});
    }

    private static void schedule(final TimeValue maxTime, final int maxIterations, final ThreadContext threadContext, final Executor executor, final Driver driver, final ActionListener<Void> listener) {
        executor.execute((Runnable)new AbstractRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doRun() {
                if (driver.isFinished()) {
                    listener.onResponse(null);
                    return;
                }
                SubscribableListener<Void> fut = driver.run(maxTime, maxIterations);
                if (fut.isDone()) {
                    Driver.schedule(maxTime, maxIterations, threadContext, executor, driver, (ActionListener<Void>)listener);
                } else {
                    Driver driver2 = driver;
                    synchronized (driver2) {
                        if (!driver.isCancelled()) {
                            driver.blocked.set(fut);
                        }
                    }
                    ActionListener readyListener = ActionListener.wrap(ignored -> Driver.schedule(maxTime, maxIterations, threadContext, executor, driver, (ActionListener<Void>)listener), this::onFailure);
                    fut.addListener((ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)readyListener, (ThreadContext)threadContext));
                }
            }

            public void onFailure(Exception e) {
                driver.drainAndCloseOperators(e);
                listener.onFailure(e);
            }
        });
    }

    private static SubscribableListener<Void> oneOf(List<SubscribableListener<Void>> futures) {
        if (futures.isEmpty()) {
            return Operator.NOT_BLOCKED;
        }
        if (futures.size() == 1) {
            return futures.get(0);
        }
        SubscribableListener oneOf = new SubscribableListener();
        for (SubscribableListener<Void> fut : futures) {
            fut.addListener((ActionListener)oneOf);
        }
        return oneOf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[activeOperators=" + this.activeOperators + "]";
    }

    @Override
    public String describe() {
        return this.description.get();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public DriverStatus status() {
        return this.status.get();
    }

    private DriverStatus updateStatus(DriverStatus.Status status) {
        return new DriverStatus(this.sessionId, System.currentTimeMillis(), status, this.activeOperators.stream().map(o -> new DriverStatus.OperatorStatus(o.toString(), o.status())).toList());
    }
}

