/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;

public abstract class BatchEncoder
implements Accountable {
    private static final VarHandle intHandle = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private static final VarHandle longHandle = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
    private static final VarHandle doubleHandle = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.nativeOrder());

    public static Decoder decoder(ElementType elementType) {
        return switch (elementType) {
            case ElementType.INT -> new IntsDecoder();
            case ElementType.LONG -> new LongsDecoder();
            case ElementType.DOUBLE -> new DoublesDecoder();
            case ElementType.BYTES_REF -> new BytesRefsDecoder();
            case ElementType.BOOLEAN -> new BooleansDecoder();
            default -> throw new IllegalArgumentException("can't encode " + elementType);
        };
    }

    public abstract int positionCount();

    public abstract int valueCount(int var1);

    public abstract int read(int var1, BytesRefBuilder var2);

    public abstract void encodeNextBatch();

    private static class IntsDecoder
    implements Decoder {
        private IntsDecoder() {
        }

        @Override
        public void decode(Block.Builder builder, IsNull isNull, BytesRef[] encoded, int count) {
            IntBlock.Builder b = (IntBlock.Builder)builder;
            for (int i = 0; i < count; ++i) {
                if (isNull.isNull(i)) {
                    b.appendNull();
                    continue;
                }
                BytesRef e = encoded[i];
                b.appendInt(intHandle.get(e.bytes, e.offset));
                e.offset += 4;
                e.length -= 4;
            }
        }
    }

    private static class LongsDecoder
    implements Decoder {
        private LongsDecoder() {
        }

        @Override
        public void decode(Block.Builder builder, IsNull isNull, BytesRef[] encoded, int count) {
            LongBlock.Builder b = (LongBlock.Builder)builder;
            for (int i = 0; i < count; ++i) {
                if (isNull.isNull(i)) {
                    b.appendNull();
                    continue;
                }
                BytesRef e = encoded[i];
                b.appendLong(longHandle.get(e.bytes, e.offset));
                e.offset += 8;
                e.length -= 8;
            }
        }
    }

    private static class DoublesDecoder
    implements Decoder {
        private DoublesDecoder() {
        }

        @Override
        public void decode(Block.Builder builder, IsNull isNull, BytesRef[] encoded, int count) {
            DoubleBlock.Builder b = (DoubleBlock.Builder)builder;
            for (int i = 0; i < count; ++i) {
                if (isNull.isNull(i)) {
                    b.appendNull();
                    continue;
                }
                BytesRef e = encoded[i];
                b.appendDouble(doubleHandle.get(e.bytes, e.offset));
                e.offset += 8;
                e.length -= 8;
            }
        }
    }

    private static class BytesRefsDecoder
    implements Decoder {
        private BytesRefsDecoder() {
        }

        @Override
        public void decode(Block.Builder builder, IsNull isNull, BytesRef[] encoded, int count) {
            BytesRef scratch = new BytesRef();
            BytesRefBlock.Builder b = (BytesRefBlock.Builder)builder;
            for (int i = 0; i < count; ++i) {
                if (isNull.isNull(i)) {
                    b.appendNull();
                    continue;
                }
                BytesRef e = encoded[i];
                scratch.bytes = e.bytes;
                scratch.length = intHandle.get(e.bytes, e.offset);
                e.offset += 4;
                e.length -= 4;
                scratch.offset = e.offset;
                b.appendBytesRef(scratch);
                e.offset += scratch.length;
                e.length -= scratch.length;
            }
        }
    }

    private static class BooleansDecoder
    implements Decoder {
        private BooleansDecoder() {
        }

        @Override
        public void decode(Block.Builder builder, IsNull isNull, BytesRef[] encoded, int count) {
            BooleanBlock.Builder b = (BooleanBlock.Builder)builder;
            for (int i = 0; i < count; ++i) {
                if (isNull.isNull(i)) {
                    b.appendNull();
                    continue;
                }
                BytesRef e = encoded[i];
                b.appendBoolean(e.bytes[e.offset] == 1);
                ++e.offset;
                --e.length;
            }
        }
    }

    protected static final class DirectNulls
    extends DirectEncoder {
        DirectNulls(Block block) {
            super(block);
            assert (block.areAllValuesNull()) : block;
        }

        @Override
        protected int readValueAtBlockIndex(int valueIndex, BytesRefBuilder dst) {
            assert (false) : "all positions all nulls";
            throw new IllegalStateException("all positions all nulls");
        }
    }

    protected static final class DirectBytesRefs
    extends DirectEncoder {
        private final BytesRef scratch = new BytesRef();

        DirectBytesRefs(BytesRefBlock block) {
            super(block);
        }

        @Override
        protected int readValueAtBlockIndex(int valueIndex, BytesRefBuilder dst) {
            BytesRef v = ((BytesRefBlock)this.block).getBytesRef(valueIndex, this.scratch);
            int start = dst.length();
            dst.grow(start + 4 + v.length);
            intHandle.set(dst.bytes(), start, v.length);
            dst.setLength(start + 4);
            dst.append(v);
            return 4 + v.length;
        }
    }

    protected static abstract class BytesRefs
    extends MVEncoder {
        protected BytesRefs(int batchSize) {
            super(batchSize);
        }

        protected final boolean hasCapacity(int totalBytes, int count) {
            return this.bytes.length() + totalBytes + count * 4 <= this.bytesCapacity();
        }

        protected final void ensureCapacity(int totalBytes, int count) {
            this.bytes.grow(totalBytes + count * 4);
        }

        protected final void encode(BytesRef v) {
            this.addingValue();
            intHandle.set(this.bytes.bytes(), this.bytes.length(), v.length);
            this.bytes.setLength(this.bytes.length() + 4);
            this.bytes.append(v);
        }
    }

    protected static final class DirectBooleans
    extends DirectEncoder {
        DirectBooleans(BooleanBlock block) {
            super(block);
        }

        @Override
        protected int readValueAtBlockIndex(int valueIndex, BytesRefBuilder dst) {
            boolean v = ((BooleanBlock)this.block).getBoolean(valueIndex);
            dst.append((byte)(v ? 1 : 0));
            return 1;
        }
    }

    protected static abstract class Booleans
    extends MVEncoder {
        protected Booleans(int batchSize) {
            super(batchSize);
        }

        protected final boolean hasCapacity(int count) {
            return this.bytes.length() + count <= this.bytesCapacity();
        }

        protected final void encode(boolean v) {
            this.addingValue();
            this.bytes.bytes()[this.bytes.length()] = (byte)(v ? 1 : 0);
            this.bytes.setLength(this.bytes.length() + 1);
        }
    }

    protected static final class DirectDoubles
    extends DirectEncoder {
        DirectDoubles(DoubleBlock block) {
            super(block);
        }

        @Override
        protected int readValueAtBlockIndex(int valueIndex, BytesRefBuilder dst) {
            int before = dst.length();
            int after = before + 8;
            dst.grow(after);
            double v = ((DoubleBlock)this.block).getDouble(valueIndex);
            doubleHandle.set(dst.bytes(), before, v);
            dst.setLength(after);
            return 8;
        }
    }

    protected static abstract class Doubles
    extends MVEncoder {
        protected Doubles(int batchSize) {
            super(batchSize);
        }

        protected final boolean hasCapacity(int count) {
            return this.bytes.length() + count * 8 <= this.bytesCapacity();
        }

        protected final void ensureCapacity(int count) {
            this.bytes.grow(count * 8);
        }

        protected final void encode(double v) {
            this.addingValue();
            doubleHandle.set(this.bytes.bytes(), this.bytes.length(), v);
            this.bytes.setLength(this.bytes.length() + 8);
        }
    }

    protected static final class DirectLongs
    extends DirectEncoder {
        DirectLongs(LongBlock block) {
            super(block);
        }

        @Override
        protected int readValueAtBlockIndex(int valueIndex, BytesRefBuilder dst) {
            int before = dst.length();
            int after = before + 8;
            dst.grow(after);
            long v = ((LongBlock)this.block).getLong(valueIndex);
            longHandle.set(dst.bytes(), before, v);
            dst.setLength(after);
            return 8;
        }
    }

    protected static abstract class Longs
    extends MVEncoder {
        protected Longs(int batchSize) {
            super(batchSize);
        }

        protected final boolean hasCapacity(int count) {
            return this.bytes.length() + count * 8 <= this.bytesCapacity();
        }

        protected final void ensureCapacity(int count) {
            this.bytes.grow(count * 8);
        }

        protected final void encode(long v) {
            this.addingValue();
            longHandle.set(this.bytes.bytes(), this.bytes.length(), v);
            this.bytes.setLength(this.bytes.length() + 8);
        }
    }

    protected static final class DirectInts
    extends DirectEncoder {
        DirectInts(IntBlock block) {
            super(block);
        }

        @Override
        protected int readValueAtBlockIndex(int valueIndex, BytesRefBuilder dst) {
            int before = dst.length();
            int after = before + 4;
            dst.grow(after);
            int v = ((IntBlock)this.block).getInt(valueIndex);
            intHandle.set(dst.bytes(), before, v);
            dst.setLength(after);
            return 4;
        }
    }

    protected static abstract class Ints
    extends MVEncoder {
        protected Ints(int batchSize) {
            super(batchSize);
        }

        protected final boolean hasCapacity(int count) {
            return this.bytes.length() + count * 4 <= this.bytesCapacity();
        }

        protected final void ensureCapacity(int count) {
            this.bytes.grow(count * 4);
        }

        protected final void encode(int v) {
            this.addingValue();
            intHandle.set(this.bytes.bytes(), this.bytes.length(), v);
            this.bytes.setLength(this.bytes.length() + 4);
        }
    }

    protected static abstract class DirectEncoder
    extends BatchEncoder {
        protected static final long BASE_RAM_USAGE = RamUsageEstimator.shallowSizeOfInstance(DirectEncoder.class);
        protected final Block block;
        private int blockPosition = -1;
        private int valueCount;

        DirectEncoder(Block block) {
            this.block = block;
        }

        @Override
        public final void encodeNextBatch() {
            this.valueCount = this.block.getValueCount(++this.blockPosition);
        }

        @Override
        public final int positionCount() {
            return Math.max(this.valueCount, 1);
        }

        @Override
        public final int valueCount(int positionOffset) {
            assert (positionOffset == 0) : positionOffset;
            return this.positionCount();
        }

        @Override
        public int read(int index, BytesRefBuilder dst) {
            if (this.valueCount == 0) {
                assert (index == 0) : index;
                return 0;
            }
            assert (index < this.valueCount) : index + " > " + this.valueCount;
            return this.readValueAtBlockIndex(this.block.getFirstValueIndex(this.blockPosition) + index, dst);
        }

        protected abstract int readValueAtBlockIndex(int var1, BytesRefBuilder var2);

        public final long ramBytesUsed() {
            return BASE_RAM_USAGE;
        }
    }

    protected static abstract class MVEncoder
    extends BatchEncoder {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(MVEncoder.class);
        protected final BytesRefBuilder bytes = new BytesRefBuilder();
        private int[] counts = new int[ArrayUtil.oversize((int)10, (int)4)];
        private int[] valueOffsets = new int[ArrayUtil.oversize((int)10, (int)4)];
        private int firstPosition;
        private int positionCount;
        private int currentValue;

        MVEncoder(int batchSize) {
            this.bytes.grow(batchSize);
        }

        protected final int firstPosition() {
            return this.firstPosition;
        }

        @Override
        public final int positionCount() {
            return this.positionCount;
        }

        @Override
        public final int valueCount(int positionOffset) {
            if (positionOffset >= this.positionCount) {
                throw new IllegalArgumentException("wanted " + positionOffset + " but only have " + this.positionCount);
            }
            return this.counts[positionOffset];
        }

        @Override
        public final int read(int index, BytesRefBuilder dst) {
            int start = this.valueOffsets[index];
            int length = this.valueOffsets[index + 1] - start;
            if (length > 0) {
                dst.append(this.bytes.bytes(), start, length);
            }
            return length;
        }

        @Override
        public final void encodeNextBatch() {
            this.bytes.clear();
            this.firstPosition += this.positionCount;
            this.positionCount = 0;
            this.currentValue = 0;
            this.readNextBatch();
        }

        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf((int[])this.counts) + RamUsageEstimator.sizeOf((int[])this.valueOffsets);
        }

        protected abstract void readNextBatch();

        protected final void startPosition() {
            this.counts = ArrayUtil.grow((int[])this.counts, (int)(this.positionCount + 1));
            this.counts[this.positionCount] = 0;
        }

        protected final void addingValue() {
            int n = this.positionCount;
            this.counts[n] = this.counts[n] + 1;
            this.valueOffsets = ArrayUtil.grow((int[])this.valueOffsets, (int)(this.currentValue + 1));
            this.valueOffsets[this.currentValue++] = this.bytes.length();
        }

        protected final void endPosition() {
            this.valueOffsets = ArrayUtil.grow((int[])this.valueOffsets, (int)(this.currentValue + 1));
            this.valueOffsets[this.currentValue] = this.bytes.length();
            ++this.positionCount;
        }

        protected final void encodeNull() {
            this.startPosition();
            this.addingValue();
            this.endPosition();
        }

        final int bytesLength() {
            return this.bytes.length();
        }

        final int bytesCapacity() {
            return this.bytes.bytes().length;
        }
    }

    public static interface Decoder {
        public void decode(Block.Builder var1, IsNull var2, BytesRef[] var3, int var4);
    }

    public static interface IsNull {
        public boolean isNull(int var1);
    }
}

