/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.tasks.TaskCancelledException;

public abstract class AsyncOperator
implements Operator {
    private volatile SubscribableListener<Void> blockedFuture;
    private final Map<Long, Page> buffers = ConcurrentCollections.newConcurrentMap();
    private final AtomicReference<Exception> failure = new AtomicReference();
    private final int maxOutstandingRequests;
    private boolean finished = false;
    private final LocalCheckpointTracker checkpoint = new LocalCheckpointTracker(-1L, -1L);

    public AsyncOperator(int maxOutstandingRequests) {
        this.maxOutstandingRequests = maxOutstandingRequests;
    }

    @Override
    public boolean needsInput() {
        long outstandingPages = this.checkpoint.getMaxSeqNo() - this.checkpoint.getPersistedCheckpoint();
        return outstandingPages < (long)this.maxOutstandingRequests;
    }

    @Override
    public void addInput(Page input) {
        this.checkFailure();
        long seqNo = this.checkpoint.generateSeqNo();
        this.performAsync(input, (ActionListener<Page>)ActionListener.wrap(output -> {
            this.buffers.put(seqNo, (Page)output);
            this.onSeqNoCompleted(seqNo);
        }, e -> {
            this.onFailure((Exception)e);
            this.onSeqNoCompleted(seqNo);
        }));
    }

    protected abstract void performAsync(Page var1, ActionListener<Page> var2);

    private void onFailure(Exception e) {
        this.failure.getAndUpdate(first -> {
            if (first == null) {
                return e;
            }
            if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                return first;
            }
            if (ExceptionsHelper.unwrap((Throwable)first, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                return e;
            }
            if (ExceptionsHelper.unwrapCause((Throwable)first) != ExceptionsHelper.unwrapCause((Throwable)e)) {
                first.addSuppressed(e);
            }
            return first;
        });
    }

    private void onSeqNoCompleted(long seqNo) {
        this.checkpoint.markSeqNoAsProcessed(seqNo);
        if (this.checkpoint.getPersistedCheckpoint() < this.checkpoint.getProcessedCheckpoint()) {
            this.notifyIfBlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfBlocked() {
        if (this.blockedFuture != null) {
            SubscribableListener<Void> future;
            AsyncOperator asyncOperator = this;
            synchronized (asyncOperator) {
                future = this.blockedFuture;
                this.blockedFuture = null;
            }
            if (future != null) {
                future.onResponse(null);
            }
        }
    }

    private void checkFailure() {
        Exception e = this.failure.get();
        if (e != null) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        this.checkFailure();
        return this.finished && this.checkpoint.getPersistedCheckpoint() == this.checkpoint.getMaxSeqNo();
    }

    @Override
    public Page getOutput() {
        this.checkFailure();
        long persistedCheckpoint = this.checkpoint.getPersistedCheckpoint();
        if (persistedCheckpoint < this.checkpoint.getProcessedCheckpoint()) {
            Page page = this.buffers.remove(++persistedCheckpoint);
            this.checkpoint.markSeqNoAsPersisted(persistedCheckpoint);
            return page;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribableListener<Void> isBlocked() {
        if (this.finished) {
            return Operator.NOT_BLOCKED;
        }
        long persistedCheckpoint = this.checkpoint.getPersistedCheckpoint();
        if (persistedCheckpoint == this.checkpoint.getMaxSeqNo() || persistedCheckpoint < this.checkpoint.getProcessedCheckpoint()) {
            return Operator.NOT_BLOCKED;
        }
        AsyncOperator asyncOperator = this;
        synchronized (asyncOperator) {
            persistedCheckpoint = this.checkpoint.getPersistedCheckpoint();
            if (persistedCheckpoint == this.checkpoint.getMaxSeqNo() || persistedCheckpoint < this.checkpoint.getProcessedCheckpoint()) {
                return Operator.NOT_BLOCKED;
            }
            if (this.blockedFuture == null) {
                this.blockedFuture = new SubscribableListener();
            }
            return this.blockedFuture;
        }
    }
}

