/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractPageMappingOperator
implements Operator {
    private Page prev;
    private boolean finished = false;
    private int pagesProcessed;

    protected abstract Page process(Page var1);

    public abstract String toString();

    @Override
    public final boolean needsInput() {
        return this.prev == null && !this.finished;
    }

    @Override
    public final void addInput(Page page) {
        assert (this.prev == null) : "has pending input page";
        this.prev = page;
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && this.prev == null;
    }

    @Override
    public final Page getOutput() {
        if (this.prev == null) {
            return null;
        }
        if (this.prev.getPositionCount() == 0) {
            return this.prev;
        }
        ++this.pagesProcessed;
        Page p = this.process(this.prev);
        this.prev = null;
        return p;
    }

    @Override
    public final Status status() {
        return this.status(this.pagesProcessed);
    }

    protected Status status(int pagesProcessed) {
        return new Status(pagesProcessed);
    }

    @Override
    public void close() {
        if (this.prev != null) {
            Releasables.closeExpectNoException(() -> this.prev.releaseBlocks());
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "page_mapping", Status::new);
        private final int pagesProcessed;

        protected Status(int pagesProcessed) {
            this.pagesProcessed = pagesProcessed;
        }

        protected Status(StreamInput in) throws IOException {
            this.pagesProcessed = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.pagesProcessed);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("pages_processed", this.pagesProcessed);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.pagesProcessed == status.pagesProcessed;
        }

        public int hashCode() {
            return Objects.hash(this.pagesProcessed);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

