/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.BlockDocValuesReader;
import org.elasticsearch.compute.lucene.ValueSourceInfo;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ValuesSourceReaderOperator
extends AbstractPageMappingOperator {
    private final List<ValueSourceInfo> sources;
    private final int docChannel;
    private final String field;
    private BlockDocValuesReader lastReader;
    private int lastShard = -1;
    private int lastSegment = -1;
    private final Map<String, Integer> readersBuilt = new TreeMap<String, Integer>();

    public ValuesSourceReaderOperator(List<ValueSourceInfo> sources, int docChannel, String field) {
        this.sources = sources;
        this.docChannel = docChannel;
        this.field = field;
    }

    @Override
    protected Page process(Page page) {
        DocVector docVector = ((DocBlock)page.getBlock(this.docChannel)).asVector();
        try {
            if (docVector.singleSegmentNonDecreasing()) {
                return page.appendBlock(this.loadFromSingleLeaf(docVector));
            }
            return page.appendBlock(this.loadFromManyLeaves(docVector));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Block loadFromSingleLeaf(DocVector docVector) throws IOException {
        this.setupReader(docVector.shards().getInt(0), docVector.segments().getInt(0), docVector.docs().getInt(0));
        return this.lastReader.readValues(docVector.docs());
    }

    private Block loadFromManyLeaves(DocVector docVector) throws IOException {
        int[] forwards = docVector.shardSegmentDocMapForwards();
        int doc = docVector.docs().getInt(forwards[0]);
        this.setupReader(docVector.shards().getInt(forwards[0]), docVector.segments().getInt(forwards[0]), doc);
        Block.Builder builder = this.lastReader.builder(forwards.length);
        this.lastReader.readValuesFromSingleDoc(doc, builder);
        for (int i = 1; i < forwards.length; ++i) {
            int shard = docVector.shards().getInt(forwards[i]);
            int segment = docVector.segments().getInt(forwards[i]);
            doc = docVector.docs().getInt(forwards[i]);
            if (segment != this.lastSegment || shard != this.lastShard) {
                this.setupReader(shard, segment, doc);
            }
            this.lastReader.readValuesFromSingleDoc(doc, builder);
        }
        return builder.build().filter(docVector.shardSegmentDocMapBackwards());
    }

    private void setupReader(int shard, int segment, int doc) throws IOException {
        if (this.lastSegment == segment && this.lastShard == shard && BlockDocValuesReader.canReuse(this.lastReader, doc)) {
            return;
        }
        ValueSourceInfo info = this.sources.get(shard);
        LeafReaderContext leafReaderContext = (LeafReaderContext)info.reader().leaves().get(segment);
        this.lastReader = BlockDocValuesReader.createBlockReader(info.source(), info.type(), info.elementType(), leafReaderContext);
        this.lastShard = shard;
        this.lastSegment = segment;
        this.readersBuilt.compute(this.lastReader.toString(), (k, v) -> v == null ? 1 : v + 1);
    }

    @Override
    public String toString() {
        return "ValuesSourceReaderOperator[field = " + this.field + "]";
    }

    @Override
    protected Status status(int pagesProcessed) {
        return new Status(new TreeMap<String, Integer>(this.readersBuilt), pagesProcessed);
    }

    public static class Status
    extends AbstractPageMappingOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "values_source_reader", Status::new);
        private final Map<String, Integer> readersBuilt;

        Status(Map<String, Integer> readersBuilt, int pagesProcessed) {
            super(pagesProcessed);
            this.readersBuilt = readersBuilt;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.readersBuilt = in.readOrderedMap(StreamInput::readString, StreamInput::readVInt);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.readersBuilt, StreamOutput::writeVInt);
        }

        @Override
        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public Map<String, Integer> readersBuilt() {
            return this.readersBuilt;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("readers_built");
            for (Map.Entry<String, Integer> e : this.readersBuilt.entrySet()) {
                builder.field(e.getKey(), e.getValue());
            }
            builder.endObject();
            builder.field("pages_processed", this.pagesProcessed());
            return builder.endObject();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.pagesProcessed() == status.pagesProcessed() && this.readersBuilt.equals(status.readersBuilt);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.readersBuilt, this.pagesProcessed());
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record ValuesSourceReaderOperatorFactory(Supplier<List<ValueSourceInfo>> sources, int docChannel, String field) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ValuesSourceReaderOperator(this.sources.get(), this.docChannel, this.field);
        }

        @Override
        public String describe() {
            return "ValuesSourceReaderOperator[field = " + this.field + "]";
        }
    }
}

