/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.lucene.IdFieldIndexFieldData;
import org.elasticsearch.compute.lucene.IdValueSource;
import org.elasticsearch.compute.lucene.NullValueSource;
import org.elasticsearch.compute.lucene.NullValueSourceType;
import org.elasticsearch.compute.lucene.TextValueSource;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.compute.lucene.UnsupportedValueSourceType;
import org.elasticsearch.compute.lucene.ValueSourceInfo;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SourceProvider;

public final class ValueSources {
    public static final String MATCH_ONLY_TEXT = "match_only_text";

    private ValueSources() {
    }

    public static List<ValueSourceInfo> sources(List<SearchContext> searchContexts, String fieldName, boolean asUnsupportedSource, ElementType elementType) {
        ArrayList<ValueSourceInfo> sources = new ArrayList<ValueSourceInfo>(searchContexts.size());
        for (SearchContext searchContext : searchContexts) {
            IndexFieldData fieldData;
            ShardSearchRequest shardRequest = searchContext.request();
            SearchExecutionContext ctx = searchContext.readerContext().indexService().newSearchExecutionContext(shardRequest.shardId().id(), shardRequest.shardRequestIndex(), (IndexSearcher)searchContext.searcher(), () -> ((ShardSearchRequest)shardRequest).nowInMillis(), shardRequest.getClusterAlias(), shardRequest.getRuntimeMappings());
            MappedFieldType fieldType = ctx.getFieldType(fieldName);
            if (fieldType == null) {
                sources.add(new ValueSourceInfo(new NullValueSourceType(), new NullValueSource(), elementType, ctx.getIndexReader()));
                continue;
            }
            if (asUnsupportedSource) {
                sources.add(new ValueSourceInfo(new UnsupportedValueSourceType(fieldType.typeName()), new UnsupportedValueSource(null), elementType, ctx.getIndexReader()));
                HeaderWarning.addWarning((String)"Field [{}] cannot be retrieved, it is unsupported or not indexed; returning null", (Object[])new Object[]{fieldName});
                continue;
            }
            if (!fieldType.hasDocValues()) {
                TextFieldMapper.TextFieldType tft;
                if (fieldType instanceof KeywordFieldMapper.KeywordFieldType || fieldType instanceof TextFieldMapper.TextFieldType && (!(tft = (TextFieldMapper.TextFieldType)fieldType).isSyntheticSource() || tft.isStored()) || MATCH_ONLY_TEXT.equals(fieldType.typeName())) {
                    TextValueSource vs = ValueSources.textValueSource(ctx, fieldType);
                    sources.add(new ValueSourceInfo((ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValuesSource)vs, elementType, ctx.getIndexReader()));
                    continue;
                }
                if ("_id".equals(fieldType.name())) {
                    IdValueSource vs = new IdValueSource(new IdFieldIndexFieldData((ValuesSourceType)CoreValuesSourceType.KEYWORD));
                    sources.add(new ValueSourceInfo((ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValuesSource)vs, elementType, ctx.getIndexReader()));
                    continue;
                }
            }
            try {
                fieldData = ctx.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH);
            }
            catch (IllegalArgumentException e) {
                sources.add(ValueSources.unsupportedValueSource(elementType, ctx, fieldType, e));
                HeaderWarning.addWarning((String)"Field [{}] cannot be retrieved, it is unsupported or not indexed; returning null", (Object[])new Object[]{fieldName});
                continue;
            }
            FieldContext fieldContext = new FieldContext(fieldName, fieldData, fieldType);
            ValuesSourceType vsType = fieldData.getValuesSourceType();
            ValuesSource vs = vsType.getField(fieldContext, null);
            sources.add(new ValueSourceInfo(vsType, vs, elementType, ctx.getIndexReader()));
        }
        return sources;
    }

    private static ValueSourceInfo unsupportedValueSource(ElementType elementType, SearchExecutionContext ctx, MappedFieldType fieldType, IllegalArgumentException e) {
        return switch (elementType) {
            case ElementType.BYTES_REF -> new ValueSourceInfo(new UnsupportedValueSourceType(fieldType.typeName()), new UnsupportedValueSource(null), elementType, ctx.getIndexReader());
            case ElementType.LONG, ElementType.INT -> new ValueSourceInfo((ValuesSourceType)CoreValuesSourceType.NUMERIC, (ValuesSource)ValuesSource.Numeric.EMPTY, elementType, ctx.getIndexReader());
            case ElementType.BOOLEAN -> new ValueSourceInfo((ValuesSourceType)CoreValuesSourceType.BOOLEAN, (ValuesSource)ValuesSource.Numeric.EMPTY, elementType, ctx.getIndexReader());
            case ElementType.DOUBLE -> new ValueSourceInfo((ValuesSourceType)CoreValuesSourceType.NUMERIC, (ValuesSource)new ValuesSource.Numeric(){

                public boolean isFloatingPoint() {
                    return true;
                }

                public SortedNumericDocValues longValues(LeafReaderContext context) {
                    return DocValues.emptySortedNumeric();
                }

                public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
                    return FieldData.emptySortedNumericDoubles();
                }

                public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                    return FieldData.emptySortedBinary();
                }
            }, elementType, ctx.getIndexReader());
            default -> throw e;
        };
    }

    private static TextValueSource textValueSource(SearchExecutionContext ctx, MappedFieldType fieldType) {
        if (fieldType.isStored()) {
            StoredFieldSortedBinaryIndexFieldData fieldData = new StoredFieldSortedBinaryIndexFieldData(fieldType.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, TextValueSource.TextDocValuesFieldWrapper::new){

                protected BytesRef storedToBytesRef(Object stored) {
                    return new BytesRef((CharSequence)((String)stored));
                }
            };
            return new TextValueSource((IndexFieldData<?>)fieldData);
        }
        FieldDataContext fieldDataContext = new FieldDataContext(ctx.getFullyQualifiedIndex().getName(), () -> ctx.lookup().forkAndTrackFieldReferences(fieldType.name()), arg_0 -> ((SearchExecutionContext)ctx).sourcePath(arg_0), MappedFieldType.FielddataOperation.SEARCH);
        SourceValueFetcherSortedBinaryIndexFieldData fieldData = new SourceValueFetcherSortedBinaryIndexFieldData.Builder(fieldType.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)SourceValueFetcher.toString((Set)((Set)fieldDataContext.sourcePathsLookup().apply(fieldType.name()))), (SourceProvider)fieldDataContext.lookupSupplier().get(), TextValueSource.TextDocValuesFieldWrapper::new).build(null, null);
        return new TextValueSource((IndexFieldData<?>)fieldData);
    }
}

