/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.Strings;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;

public final class LuceneTopNSourceOperator
extends LuceneOperator {
    private ScoreDoc[] scoreDocs;
    private int offset = 0;
    private PerShardCollector perShardCollector;
    private final List<SortBuilder<?>> sorts;
    private final int limit;

    public LuceneTopNSourceOperator(int maxPageSize, List<SortBuilder<?>> sorts, int limit, LuceneSliceQueue sliceQueue) {
        super(maxPageSize, sliceQueue);
        this.sorts = sorts;
        this.limit = limit;
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting && !this.isEmitting();
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
        this.scoreDocs = null;
        assert (this.isFinished());
    }

    @Override
    public Page getOutput() {
        if (this.isFinished()) {
            return null;
        }
        if (this.isEmitting()) {
            return this.emit(false);
        }
        return this.collect();
    }

    private Page collect() {
        LuceneOperator.LuceneScorer nextScorer;
        assert (!this.doneCollecting);
        LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
        if (scorer == null) {
            this.doneCollecting = true;
            return this.emit(true);
        }
        try {
            if (this.perShardCollector == null || this.perShardCollector.shardIndex != scorer.shardIndex()) {
                this.perShardCollector = new PerShardCollector(scorer.shardIndex(), scorer.searchContext(), this.sorts, this.limit);
            }
            LeafCollector leafCollector = this.perShardCollector.getLeafCollector(scorer.leafReaderContext());
            scorer.scoreNextRange(leafCollector, scorer.leafReaderContext().reader().getLiveDocs(), this.maxPageSize);
        }
        catch (CollectionTerminatedException cte) {
            scorer.markAsDone();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (scorer.isDone() && ((nextScorer = this.getCurrentOrLoadNextScorer()) == null || nextScorer.shardIndex() != scorer.shardIndex())) {
            return this.emit(true);
        }
        return null;
    }

    private boolean isEmitting() {
        return this.scoreDocs != null && this.offset < this.scoreDocs.length;
    }

    private Page emit(boolean startEmitting) {
        if (startEmitting) {
            assert (!this.isEmitting()) : "offset=" + this.offset + " score_docs=" + Arrays.toString(this.scoreDocs);
            this.offset = 0;
            this.scoreDocs = this.perShardCollector != null ? this.perShardCollector.topFieldCollector.topDocs().scoreDocs : new ScoreDoc[0];
        }
        if (this.offset >= this.scoreDocs.length) {
            return null;
        }
        int size = Math.min(this.maxPageSize, this.scoreDocs.length - this.offset);
        IntVector.Builder currentSegmentBuilder = IntVector.newVectorBuilder(size);
        IntVector.Builder currentDocsBuilder = IntVector.newVectorBuilder(size);
        int start = this.offset;
        this.offset += size;
        List leafContexts = this.perShardCollector.searchContext.searcher().getLeafContexts();
        for (int i = start; i < this.offset; ++i) {
            int doc = this.scoreDocs[i].doc;
            int segment = ReaderUtil.subIndex((int)doc, (List)leafContexts);
            currentSegmentBuilder.appendInt(segment);
            currentDocsBuilder.appendInt(doc - ((LeafReaderContext)leafContexts.get((int)segment)).docBase);
        }
        ++this.pagesEmitted;
        return new Page(size, new DocVector(IntBlock.newConstantBlockWith(this.perShardCollector.shardIndex, size).asVector(), currentSegmentBuilder.build(), currentDocsBuilder.build(), null).asBlock());
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", limit=").append(this.limit);
        sb.append(", sorts=").append(this.sorts);
    }

    static final class PerShardCollector {
        private final int shardIndex;
        private final SearchContext searchContext;
        private final TopFieldCollector topFieldCollector;
        private int leafIndex;
        private LeafCollector leafCollector;
        private Thread currentThread;

        PerShardCollector(int shardIndex, SearchContext searchContext, List<SortBuilder<?>> sorts, int limit) throws IOException {
            this.shardIndex = shardIndex;
            this.searchContext = searchContext;
            Optional sortAndFormats = SortBuilder.buildSort(sorts, (SearchExecutionContext)searchContext.getSearchExecutionContext());
            if (sortAndFormats.isEmpty()) {
                throw new IllegalStateException("sorts must not be disabled in TopN");
            }
            this.topFieldCollector = TopFieldCollector.create((Sort)((SortAndFormats)sortAndFormats.get()).sort, (int)limit, (int)0);
        }

        LeafCollector getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            if (this.currentThread != Thread.currentThread() || this.leafIndex != leafReaderContext.ord) {
                this.leafCollector = this.topFieldCollector.getLeafCollector(leafReaderContext);
                this.leafIndex = leafReaderContext.ord;
                this.currentThread = Thread.currentThread();
            }
            return this.leafCollector;
        }
    }

    public static final class Factory
    implements LuceneOperator.Factory {
        private final int taskConcurrency;
        private final int maxPageSize;
        private final List<SortBuilder<?>> sorts;
        private final int limit;
        private final DataPartitioning dataPartitioning;
        private final LuceneSliceQueue sliceQueue;

        public Factory(List<SearchContext> searchContexts, Function<SearchContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int maxPageSize, int limit, List<SortBuilder<?>> sorts) {
            this.maxPageSize = maxPageSize;
            this.sorts = sorts;
            this.limit = limit;
            this.dataPartitioning = dataPartitioning;
            Function<SearchContext, Weight> weightFunction = LuceneOperator.weightFunction(queryFunction, ScoreMode.TOP_DOCS);
            this.sliceQueue = LuceneSliceQueue.create(searchContexts, weightFunction, dataPartitioning, taskConcurrency);
            this.taskConcurrency = Math.min(this.sliceQueue.totalSlices(), taskConcurrency);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneTopNSourceOperator(this.maxPageSize, this.sorts, this.limit, this.sliceQueue);
        }

        @Override
        public int taskConcurrency() {
            return this.taskConcurrency;
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        public int limit() {
            return this.limit;
        }

        @Override
        public String describe() {
            String notPrettySorts = this.sorts.stream().map(Strings::toString).collect(Collectors.joining(","));
            return "LuceneTopNSourceOperator[dataPartitioning = " + this.dataPartitioning + ", maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + ", sorts = [" + notPrettySorts + "]]";
        }
    }
}

