/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.search.internal.SearchContext;

public class LuceneSourceOperator
extends LuceneOperator {
    private int currentPagePos = 0;
    private int remainingDocs;
    private IntVector.Builder docsBuilder;
    private final LeafCollector leafCollector;
    private final int minPageSize;

    public LuceneSourceOperator(int maxPageSize, LuceneSliceQueue sliceQueue, int limit) {
        super(maxPageSize, sliceQueue);
        this.minPageSize = Math.max(1, maxPageSize / 2);
        this.remainingDocs = limit;
        this.docsBuilder = IntVector.newVectorBuilder(Math.min(limit, maxPageSize));
        this.leafCollector = new LeafCollector(){

            public void setScorer(Scorable scorer) {
            }

            public void collect(int doc) {
                if (LuceneSourceOperator.this.remainingDocs > 0) {
                    --LuceneSourceOperator.this.remainingDocs;
                    LuceneSourceOperator.this.docsBuilder.appendInt(doc);
                    ++LuceneSourceOperator.this.currentPagePos;
                }
            }
        };
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    @Override
    public Page getOutput() {
        if (this.isFinished()) {
            assert (this.currentPagePos == 0) : this.currentPagePos;
            return null;
        }
        try {
            LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
            if (scorer == null) {
                return null;
            }
            scorer.scoreNextRange(this.leafCollector, scorer.leafReaderContext().reader().getLiveDocs(), this.maxPageSize - this.currentPagePos);
            Page page = null;
            if (this.currentPagePos >= this.minPageSize || this.remainingDocs <= 0 || scorer.isDone()) {
                ++this.pagesEmitted;
                page = new Page(this.currentPagePos, new DocVector(IntBlock.newConstantBlockWith(scorer.shardIndex(), this.currentPagePos).asVector(), IntBlock.newConstantBlockWith(scorer.leafReaderContext().ord, this.currentPagePos).asVector(), this.docsBuilder.build(), true).asBlock());
                this.docsBuilder = IntVector.newVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                this.currentPagePos = 0;
            }
            return page;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs=").append(this.remainingDocs);
    }

    public static class Factory
    implements LuceneOperator.Factory {
        private final DataPartitioning dataPartitioning;
        private final int taskConcurrency;
        private final int maxPageSize;
        private final int limit;
        private final LuceneSliceQueue sliceQueue;

        public Factory(List<SearchContext> searchContexts, Function<SearchContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int maxPageSize, int limit) {
            this.maxPageSize = maxPageSize;
            this.limit = limit;
            this.dataPartitioning = dataPartitioning;
            Function<SearchContext, Weight> weightFunction = LuceneOperator.weightFunction(queryFunction, ScoreMode.COMPLETE_NO_SCORES);
            this.sliceQueue = LuceneSliceQueue.create(searchContexts, weightFunction, dataPartitioning, taskConcurrency);
            this.taskConcurrency = Math.min(this.sliceQueue.totalSlices(), taskConcurrency);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneSourceOperator(this.maxPageSize, this.sliceQueue, this.limit);
        }

        @Override
        public int taskConcurrency() {
            return this.taskConcurrency;
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        public int limit() {
            return this.limit;
        }

        @Override
        public String describe() {
            return "LuceneSourceOperator[dataPartitioning = " + this.dataPartitioning + ", maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + "]";
        }
    }
}

