/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.search.internal.SearchContext;

public class LuceneCountOperator
extends LuceneOperator {
    private static final int PAGE_SIZE = 1;
    private int totalHits = 0;
    private int remainingDocs;
    private final LeafCollector leafCollector;

    public LuceneCountOperator(LuceneSliceQueue sliceQueue, int limit) {
        super(1, sliceQueue);
        this.remainingDocs = limit;
        this.leafCollector = new LeafCollector(){

            public void setScorer(Scorable scorer) {
            }

            public void collect(DocIdStream stream) throws IOException {
                if (LuceneCountOperator.this.remainingDocs > 0) {
                    int count = Math.min(stream.count(), LuceneCountOperator.this.remainingDocs);
                    LuceneCountOperator.this.totalHits += count;
                    LuceneCountOperator.this.remainingDocs -= count;
                }
            }

            public void collect(int doc) {
                if (LuceneCountOperator.this.remainingDocs > 0) {
                    --LuceneCountOperator.this.remainingDocs;
                    ++LuceneCountOperator.this.totalHits;
                }
            }
        };
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting || this.remainingDocs == 0;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    @Override
    public Page getOutput() {
        if (this.isFinished()) {
            assert (this.remainingDocs <= 0) : this.remainingDocs;
            return null;
        }
        try {
            LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
            if (scorer == null) {
                this.remainingDocs = 0;
            } else {
                LeafReaderContext leafReaderContext;
                Weight weight = scorer.weight();
                int leafCount = weight.count(leafReaderContext = scorer.leafReaderContext());
                if (leafCount != -1) {
                    if (scorer.position() == 0) {
                        int count = Math.min(leafCount, this.remainingDocs);
                        this.totalHits += count;
                        this.remainingDocs -= count;
                    }
                    scorer.markAsDone();
                } else {
                    scorer.scoreNextRange(this.leafCollector, leafReaderContext.reader().getLiveDocs(), this.remainingDocs);
                }
            }
            Page page = null;
            if (this.remainingDocs <= 0 && this.pagesEmitted == 0) {
                ++this.pagesEmitted;
                page = new Page(1, LongBlock.newConstantBlockWith(this.totalHits, 1), BooleanBlock.newConstantBlockWith(true, 1));
            }
            return page;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs=").append(this.remainingDocs);
    }

    public static class Factory
    implements LuceneOperator.Factory {
        private final DataPartitioning dataPartitioning;
        private final int taskConcurrency;
        private final int limit;
        private final LuceneSliceQueue sliceQueue;

        public Factory(List<SearchContext> searchContexts, Function<SearchContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int limit) {
            this.limit = limit;
            this.dataPartitioning = dataPartitioning;
            Function<SearchContext, Weight> weightFunction = LuceneOperator.weightFunction(queryFunction, ScoreMode.COMPLETE_NO_SCORES);
            this.sliceQueue = LuceneSliceQueue.create(searchContexts, weightFunction, dataPartitioning, taskConcurrency);
            this.taskConcurrency = Math.min(this.sliceQueue.totalSlices(), taskConcurrency);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneCountOperator(this.sliceQueue, this.limit);
        }

        @Override
        public int taskConcurrency() {
            return this.taskConcurrency;
        }

        public int limit() {
            return this.limit;
        }

        @Override
        public String describe() {
            return "LuceneCountOperator[dataPartitioning = " + this.dataPartitioning + ", limit = " + this.limit + "]";
        }
    }
}

