/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.lucene.NullValueSourceType;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.compute.lucene.UnsupportedValueSourceType;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public abstract class BlockDocValuesReader {
    protected final Thread creationThread = Thread.currentThread();

    public abstract int docID();

    public abstract Block.Builder builder(int var1);

    public abstract Block readValues(IntVector var1) throws IOException;

    public abstract void readValuesFromSingleDoc(int var1, Block.Builder var2) throws IOException;

    public static boolean canReuse(BlockDocValuesReader reader, int startingDocID) {
        return reader != null && reader.creationThread == Thread.currentThread() && reader.docID() <= startingDocID;
    }

    public static BlockDocValuesReader createBlockReader(ValuesSource valuesSource, ValuesSourceType valuesSourceType, ElementType elementType, LeafReaderContext leafReaderContext) throws IOException {
        if (valuesSourceType instanceof UnsupportedValueSourceType) {
            UnsupportedValueSource bytesVS = (UnsupportedValueSource)valuesSource;
            SortedBinaryDocValues bytesValues = bytesVS.bytesValues(leafReaderContext);
            return new BytesValuesReader(bytesValues);
        }
        if (CoreValuesSourceType.NUMERIC.equals((Object)valuesSourceType) || CoreValuesSourceType.DATE.equals((Object)valuesSourceType)) {
            ValuesSource.Numeric numericVS = (ValuesSource.Numeric)valuesSource;
            if (numericVS.isFloatingPoint()) {
                if (elementType != ElementType.DOUBLE) {
                    throw new UnsupportedOperationException("can't extract [" + elementType + "] from floating point fields");
                }
                SortedNumericDoubleValues doubleValues = numericVS.doubleValues(leafReaderContext);
                NumericDoubleValues singleton = FieldData.unwrapSingleton((SortedNumericDoubleValues)doubleValues);
                if (singleton != null) {
                    return new DoubleSingletonValuesReader(singleton);
                }
                return new DoubleValuesReader(doubleValues);
            }
            SortedNumericDocValues longValues = numericVS.longValues(leafReaderContext);
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)longValues);
            if (singleton != null) {
                return switch (elementType) {
                    case ElementType.LONG -> new LongSingletonValuesReader(singleton);
                    case ElementType.INT -> new IntSingletonValuesReader(singleton);
                    default -> throw new UnsupportedOperationException("can't extract [" + elementType + "] from integer fields");
                };
            }
            return switch (elementType) {
                case ElementType.LONG -> new LongValuesReader(longValues);
                case ElementType.INT -> new IntValuesReader(longValues);
                default -> throw new UnsupportedOperationException("can't extract [" + elementType + "] from integer fields");
            };
        }
        if (CoreValuesSourceType.KEYWORD.equals((Object)valuesSourceType) || CoreValuesSourceType.IP.equals((Object)valuesSourceType)) {
            if (elementType != ElementType.BYTES_REF) {
                throw new UnsupportedOperationException("can't extract [" + elementType + "] from keywords");
            }
            ValuesSource.Bytes bytesVS = (ValuesSource.Bytes)valuesSource;
            SortedBinaryDocValues bytesValues = bytesVS.bytesValues(leafReaderContext);
            return new BytesValuesReader(bytesValues);
        }
        if (CoreValuesSourceType.BOOLEAN.equals((Object)valuesSourceType)) {
            if (elementType != ElementType.BOOLEAN) {
                throw new UnsupportedOperationException("can't extract [" + elementType + "] from booleans");
            }
            ValuesSource.Numeric numericVS = (ValuesSource.Numeric)valuesSource;
            SortedNumericDocValues longValues = numericVS.longValues(leafReaderContext);
            NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)longValues);
            if (singleton != null) {
                return new BooleanSingletonValuesReader(singleton);
            }
            return new BooleanValuesReader(longValues);
        }
        if (valuesSourceType instanceof NullValueSourceType) {
            return new NullValuesReader();
        }
        throw new IllegalArgumentException("Field type [" + valuesSourceType.typeName() + "] is not supported");
    }

    private static class BytesValuesReader
    extends BlockDocValuesReader {
        private final SortedBinaryDocValues binaryDV;
        private int docID = -1;

        BytesValuesReader(SortedBinaryDocValues binaryDV) {
            this.binaryDV = binaryDV;
        }

        @Override
        public BytesRefBlock.Builder builder(int positionCount) {
            return BytesRefBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public BytesRefBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            BytesRefBlock.Builder blockBuilder = this.builder(positionCount);
            for (int i = 0; i < docs.getPositionCount(); ++i) {
                int doc = docs.getInt(i);
                if (doc < this.docID) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                this.read(doc, blockBuilder);
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            this.read(docId, (BytesRefBlock.Builder)builder);
        }

        private void read(int doc, BytesRefBlock.Builder builder) throws IOException {
            this.docID = doc;
            if (!this.binaryDV.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.binaryDV.docValueCount();
            if (count == 1) {
                builder.appendBytesRef(this.binaryDV.nextValue());
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBytesRef(this.binaryDV.nextValue());
            }
            builder.endPositionEntry();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return "BytesValuesReader";
        }
    }

    private static class DoubleSingletonValuesReader
    extends BlockDocValuesReader {
        private final NumericDoubleValues numericDocValues;
        private int docID = -1;

        DoubleSingletonValuesReader(NumericDoubleValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public DoubleBlock.Builder builder(int positionCount) {
            return DoubleBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public DoubleBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            DoubleBlock.Builder blockBuilder = this.builder(positionCount);
            int lastDoc = -1;
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < lastDoc) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                if (this.numericDocValues.advanceExact(doc)) {
                    blockBuilder.appendDouble(this.numericDocValues.doubleValue());
                } else {
                    blockBuilder.appendNull();
                }
                lastDoc = doc;
                this.docID = doc;
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            this.docID = docId;
            DoubleBlock.Builder blockBuilder = (DoubleBlock.Builder)builder;
            if (this.numericDocValues.advanceExact(this.docID)) {
                blockBuilder.appendDouble(this.numericDocValues.doubleValue());
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return "DoubleSingletonValuesReader";
        }
    }

    private static class DoubleValuesReader
    extends BlockDocValuesReader {
        private final SortedNumericDoubleValues numericDocValues;
        private int docID = -1;

        DoubleValuesReader(SortedNumericDoubleValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public DoubleBlock.Builder builder(int positionCount) {
            return DoubleBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public DoubleBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            DoubleBlock.Builder blockBuilder = this.builder(positionCount);
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < this.docID) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                this.read(doc, blockBuilder);
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            this.read(docId, (DoubleBlock.Builder)builder);
        }

        private void read(int doc, DoubleBlock.Builder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendDouble(this.numericDocValues.nextValue());
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendDouble(this.numericDocValues.nextValue());
            }
            builder.endPositionEntry();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return "DoubleValuesReader";
        }
    }

    private static class LongSingletonValuesReader
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        LongSingletonValuesReader(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public LongBlock.Builder builder(int positionCount) {
            return LongBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public LongBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            LongBlock.Builder blockBuilder = this.builder(positionCount);
            int lastDoc = -1;
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < lastDoc) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                if (this.numericDocValues.advanceExact(doc)) {
                    blockBuilder.appendLong(this.numericDocValues.longValue());
                } else {
                    blockBuilder.appendNull();
                }
                lastDoc = doc;
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            LongBlock.Builder blockBuilder = (LongBlock.Builder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendLong(this.numericDocValues.longValue());
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docID() {
            return this.numericDocValues.docID();
        }

        public String toString() {
            return "LongSingletonValuesReader";
        }
    }

    private static class IntSingletonValuesReader
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        IntSingletonValuesReader(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public IntBlock.Builder builder(int positionCount) {
            return IntBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public IntBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            IntBlock.Builder blockBuilder = this.builder(positionCount);
            int lastDoc = -1;
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < lastDoc) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                if (this.numericDocValues.advanceExact(doc)) {
                    blockBuilder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
                } else {
                    blockBuilder.appendNull();
                }
                lastDoc = doc;
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            IntBlock.Builder blockBuilder = (IntBlock.Builder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendInt(Math.toIntExact(this.numericDocValues.longValue()));
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docID() {
            return this.numericDocValues.docID();
        }

        public String toString() {
            return "LongSingletonValuesReader";
        }
    }

    private static class LongValuesReader
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private int docID = -1;

        LongValuesReader(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public LongBlock.Builder builder(int positionCount) {
            return LongBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public LongBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            LongBlock.Builder blockBuilder = this.builder(positionCount);
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < this.docID) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                this.read(doc, blockBuilder);
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            this.read(docId, (LongBlock.Builder)builder);
        }

        private void read(int doc, LongBlock.Builder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendLong(this.numericDocValues.nextValue());
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendLong(this.numericDocValues.nextValue());
            }
            builder.endPositionEntry();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return "LongValuesReader";
        }
    }

    private static class IntValuesReader
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private int docID = -1;

        IntValuesReader(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public IntBlock.Builder builder(int positionCount) {
            return IntBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public IntBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            IntBlock.Builder blockBuilder = this.builder(positionCount);
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < this.docID) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                this.read(doc, blockBuilder);
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            this.read(docId, (IntBlock.Builder)builder);
        }

        private void read(int doc, IntBlock.Builder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendInt(Math.toIntExact(this.numericDocValues.nextValue()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return "LongValuesReader";
        }
    }

    private static class BooleanSingletonValuesReader
    extends BlockDocValuesReader {
        private final NumericDocValues numericDocValues;

        BooleanSingletonValuesReader(NumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BooleanBlock.Builder builder(int positionCount) {
            return BooleanBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public BooleanBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            BooleanBlock.Builder blockBuilder = this.builder(positionCount);
            int lastDoc = -1;
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < lastDoc) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                if (this.numericDocValues.advanceExact(doc)) {
                    blockBuilder.appendBoolean(this.numericDocValues.longValue() != 0L);
                } else {
                    blockBuilder.appendNull();
                }
                lastDoc = doc;
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            BooleanBlock.Builder blockBuilder = (BooleanBlock.Builder)builder;
            if (this.numericDocValues.advanceExact(docId)) {
                blockBuilder.appendBoolean(this.numericDocValues.longValue() != 0L);
            } else {
                blockBuilder.appendNull();
            }
        }

        @Override
        public int docID() {
            return this.numericDocValues.docID();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class BooleanValuesReader
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private int docID = -1;

        BooleanValuesReader(SortedNumericDocValues numericDocValues) {
            this.numericDocValues = numericDocValues;
        }

        @Override
        public BooleanBlock.Builder builder(int positionCount) {
            return BooleanBlock.newBlockBuilder(positionCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        @Override
        public BooleanBlock readValues(IntVector docs) throws IOException {
            int positionCount = docs.getPositionCount();
            BooleanBlock.Builder blockBuilder = this.builder(positionCount);
            for (int i = 0; i < positionCount; ++i) {
                int doc = docs.getInt(i);
                if (doc < this.docID) {
                    throw new IllegalStateException("docs within same block must be in order");
                }
                this.read(doc, blockBuilder);
            }
            return blockBuilder.build();
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) throws IOException {
            this.read(docId, (BooleanBlock.Builder)builder);
        }

        private void read(int doc, BooleanBlock.Builder builder) throws IOException {
            this.docID = doc;
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            int count = this.numericDocValues.docValueCount();
            if (count == 1) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBoolean(this.numericDocValues.nextValue() != 0L);
            }
            builder.endPositionEntry();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class NullValuesReader
    extends BlockDocValuesReader {
        private int docID = -1;

        private NullValuesReader() {
        }

        @Override
        public Block.Builder builder(int positionCount) {
            return ElementType.NULL.newBlockBuilder(positionCount);
        }

        @Override
        public Block readValues(IntVector docs) throws IOException {
            return Block.constantNullBlock(docs.getPositionCount());
        }

        @Override
        public void readValuesFromSingleDoc(int docId, Block.Builder builder) {
            this.docID = docId;
            builder.appendNull();
        }

        @Override
        public int docID() {
            return this.docID;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

