/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class Page
implements Writeable {
    private final Block[] blocks;
    private final int positionCount;
    private boolean blocksReleased = false;

    public Page(Block ... blocks) {
        this(true, Page.determinePositionCount(blocks), blocks);
    }

    public Page(int positionCount, Block ... blocks) {
        this(true, positionCount, blocks);
    }

    private Page(boolean copyBlocks, int positionCount, Block[] blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        this.positionCount = positionCount;
        this.blocks = copyBlocks ? (Block[])blocks.clone() : blocks;
        for (Block b : blocks) {
            assert (b.getPositionCount() == positionCount) : "expected positionCount=" + positionCount + " but was " + b;
            if (!b.isReleased()) continue;
            throw new IllegalArgumentException("can't build page out of released blocks but [" + b + "] was released");
        }
    }

    private Page(Page prev, Block[] toAdd) {
        for (Block block : toAdd) {
            if (prev.positionCount == block.getPositionCount()) continue;
            throw new IllegalArgumentException("Block does not have same position count");
        }
        this.positionCount = prev.positionCount;
        this.blocks = Arrays.copyOf(prev.blocks, prev.blocks.length + toAdd.length);
        System.arraycopy(toAdd, 0, this.blocks, prev.blocks.length, toAdd.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page(StreamInput in) throws IOException {
        int positionCount = in.readVInt();
        int blockPositions = in.readVInt();
        Releasable[] blocks = new Block[blockPositions];
        boolean success = false;
        try {
            for (int blockIndex = 0; blockIndex < blockPositions; ++blockIndex) {
                blocks[blockIndex] = (Block)in.readNamedWriteable(Block.class);
            }
            success = true;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
        this.positionCount = positionCount;
        this.blocks = blocks;
    }

    private static int determinePositionCount(Block ... blocks) {
        Objects.requireNonNull(blocks, "blocks is null");
        if (blocks.length == 0) {
            throw new IllegalArgumentException("blocks is empty");
        }
        return blocks[0].getPositionCount();
    }

    public <B extends Block> B getBlock(int blockIndex) {
        if (this.blocksReleased) {
            throw new IllegalStateException("can't read released page");
        }
        Block block = this.blocks[blockIndex];
        if (block.isReleased()) {
            throw new IllegalStateException("can't read released block [" + block + "]");
        }
        return (B)block;
    }

    public Page appendBlock(Block block) {
        return new Page(this, new Block[]{block});
    }

    public Page appendBlocks(Block[] toAdd) {
        return new Page(this, toAdd);
    }

    public Page appendPage(Page toAdd) {
        return this.appendBlocks(toAdd.blocks);
    }

    public int hashCode() {
        int result = Objects.hash(this.positionCount);
        for (Block block : this.blocks) {
            result = 31 * result + Objects.hashCode(block);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return this.positionCount == page.positionCount && (this.positionCount == 0 || Arrays.equals(this.blocks, 0, this.blocks.length, page.blocks, 0, page.blocks.length));
    }

    public String toString() {
        return "Page{blocks=" + Arrays.toString(this.blocks) + "}";
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getBlockCount() {
        return this.blocks.length;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.positionCount);
        out.writeVInt(this.getBlockCount());
        for (Block block : this.blocks) {
            out.writeNamedWriteable((NamedWriteable)block);
        }
    }

    public void releaseBlocks() {
        if (this.blocksReleased) {
            return;
        }
        this.blocksReleased = true;
        IdentityHashMap<Block, Boolean> map = new IdentityHashMap<Block, Boolean>(Page.mapSize(this.blocks.length));
        for (Block b : this.blocks) {
            if (map.putIfAbsent(b, Boolean.TRUE) != null) continue;
            Releasables.closeExpectNoException((Releasable)b);
        }
    }

    public Page newPageAndRelease(Block ... keep) {
        if (this.blocksReleased) {
            throw new IllegalStateException("can't create new page from already released page");
        }
        this.blocksReleased = true;
        Page newPage = new Page(this.positionCount, keep);
        Set set = Collections.newSetFromMap(new IdentityHashMap(Page.mapSize(keep.length)));
        set.addAll(Arrays.asList(keep));
        for (Block b : this.blocks) {
            if (set.contains(b)) continue;
            Releasables.closeExpectNoException((Releasable)b);
        }
        return newPage;
    }

    static int mapSize(int expectedSize) {
        return expectedSize < 2 ? expectedSize + 1 : (int)((double)expectedSize / 0.75 + 1.0);
    }
}

