/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ConstantLongVector;
import org.elasticsearch.compute.data.LongArrayVector;
import org.elasticsearch.compute.data.LongVector;

final class LongVectorFixedBuilder
implements LongVector.FixedBuilder {
    private final BlockFactory blockFactory;
    private final long[] values;
    private final long preAdjustedBytes;
    private int nextIndex;

    LongVectorFixedBuilder(int size, BlockFactory blockFactory) {
        this.preAdjustedBytes = LongVectorFixedBuilder.ramBytesUsed(size);
        blockFactory.adjustBreaker(this.preAdjustedBytes, false);
        this.blockFactory = blockFactory;
        this.values = new long[size];
    }

    @Override
    public LongVectorFixedBuilder appendLong(long value) {
        this.values[this.nextIndex++] = value;
        return this;
    }

    private static long ramBytesUsed(int size) {
        return size == 1 ? ConstantLongVector.RAM_BYTES_USED : LongArrayVector.BASE_RAM_BYTES_USED + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)(size * 8)));
    }

    @Override
    public LongVector build() {
        if (this.nextIndex < 0) {
            throw new IllegalStateException("already closed");
        }
        if (this.nextIndex != this.values.length) {
            throw new IllegalStateException("expected to write [" + this.values.length + "] entries but wrote [" + this.nextIndex + "]");
        }
        this.nextIndex = -1;
        LongVector vector = this.values.length == 1 ? this.blockFactory.newConstantLongBlockWith(this.values[0], 1, this.preAdjustedBytes).asVector() : this.blockFactory.newLongArrayVector(this.values, this.values.length, this.preAdjustedBytes);
        assert (vector.ramBytesUsed() == this.preAdjustedBytes) : "fixed Builders should estimate the exact ram bytes used";
        return vector;
    }

    public void close() {
        if (this.nextIndex >= 0) {
            this.nextIndex = -1;
            this.blockFactory.adjustBreaker(-this.preAdjustedBytes, false);
        }
    }

    boolean isReleased() {
        return this.nextIndex < 0;
    }
}

