/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.LongVectorBlock;

public final class LongArrayVector
extends AbstractVector
implements LongVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongArrayVector.class);
    private final long[] values;
    private final LongBlock block;

    public LongArrayVector(long[] values, int positionCount) {
        this(values, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public LongArrayVector(long[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
        this.block = new LongVectorBlock(this);
    }

    @Override
    public LongBlock asBlock() {
        return this.block;
    }

    @Override
    public long getLong(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public LongVector filter(int ... positions) {
        try (LongVector.Builder builder = this.blockFactory.newLongVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendLong(this.values[pos]);
            }
            LongVector longVector = builder.build();
            return longVector;
        }
    }

    public static long ramBytesEstimated(long[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((long[])values);
    }

    public long ramBytesUsed() {
        return LongArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongVector) {
            LongVector that = (LongVector)obj;
            return LongVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + Arrays.toString(this.values) + "]";
    }
}

