/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;

final class IntBlockBuilder
extends AbstractBlockBuilder
implements IntBlock.Builder {
    private int[] values;

    IntBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + initialSize * this.elementSize());
        this.values = new int[initialSize];
    }

    @Override
    public IntBlockBuilder appendInt(int value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 4;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public IntBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public IntBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public IntBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public IntBlockBuilder appendAllValuesToCurrentPosition(Block block) {
        if (block.areAllValuesNull()) {
            return this.appendNull();
        }
        return this.appendAllValuesToCurrentPosition((IntBlock)block);
    }

    @Override
    public IntBlockBuilder appendAllValuesToCurrentPosition(IntBlock block) {
        IntVector vector;
        int positionCount = block.getPositionCount();
        if (positionCount == 0) {
            return this.appendNull();
        }
        int totalValueCount = block.getTotalValueCount();
        if (totalValueCount == 0) {
            return this.appendNull();
        }
        if (totalValueCount > 1) {
            this.beginPositionEntry();
        }
        if ((vector = block.asVector()) != null) {
            for (int p = 0; p < positionCount; ++p) {
                this.appendInt(vector.getInt(p));
            }
        } else {
            for (int p = 0; p < positionCount; ++p) {
                int count = block.getValueCount(p);
                int i = block.getFirstValueIndex(p);
                for (int v = 0; v < count; ++v) {
                    this.appendInt(block.getInt(i++));
                }
            }
        }
        if (totalValueCount > 1) {
            this.endPositionEntry();
        }
        return this;
    }

    @Override
    public IntBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((IntBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public IntBlockBuilder copyFrom(IntBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        IntVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(IntBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            if (block.isNull(p)) {
                this.appendNull();
                continue;
            }
            int count = block.getValueCount(p);
            if (count > 1) {
                this.beginPositionEntry();
            }
            int i = block.getFirstValueIndex(p);
            for (int v = 0; v < count; ++v) {
                this.appendInt(block.getInt(i++));
            }
            if (count <= 1) continue;
            this.endPositionEntry();
        }
    }

    private void copyFromVector(IntVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendInt(vector.getInt(p));
        }
    }

    @Override
    public IntBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    @Override
    public IntBlock build() {
        try {
            IntBlock theBlock;
            this.finish();
            if (this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1) {
                theBlock = this.blockFactory.newConstantIntBlockWith(this.values[0], 1, this.estimatedBytes);
            } else {
                if (this.values.length - this.valueCount > 1024 || this.valueCount < this.values.length / 2) {
                    this.values = Arrays.copyOf(this.values, this.valueCount);
                }
                theBlock = this.isDense() && this.singleValued() ? this.blockFactory.newIntArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newIntArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes);
            }
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

