/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;

public final class IntArrayBlock
extends AbstractArrayBlock
implements IntBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntArrayBlock.class);
    private final int[] values;

    public IntArrayBlock(int[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        this(values, positionCount, firstValueIndexes, nulls, mvOrdering, BlockFactory.getNonBreakingInstance());
    }

    public IntArrayBlock(int[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering, blockFactory);
        this.values = values;
    }

    @Override
    public IntVector asVector() {
        return null;
    }

    @Override
    public int getInt(int valueIndex) {
        return this.values[valueIndex];
    }

    @Override
    public IntBlock filter(int ... positions) {
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendInt(this.getInt(this.getFirstValueIndex(pos)));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendInt(this.getInt(first + c));
                }
                builder.endPositionEntry();
            }
            IntBlock intBlock = builder.mvOrdering(this.mvOrdering()).build();
            return intBlock;
        }
    }

    @Override
    public ElementType elementType() {
        return ElementType.INT;
    }

    @Override
    public IntBlock expand() {
        if (this.firstValueIndexes == null) {
            return this;
        }
        try (IntBlock.Builder builder = this.blockFactory.newIntBlockBuilder(this.firstValueIndexes[this.getPositionCount()]);){
            for (int pos = 0; pos < this.getPositionCount(); ++pos) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int first = this.getFirstValueIndex(pos);
                int end = first + this.getValueCount(pos);
                for (int i = first; i < end; ++i) {
                    builder.appendInt(this.getInt(i));
                }
            }
            IntBlock intBlock = builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING).build();
            return intBlock;
        }
    }

    public static long ramBytesEstimated(int[] values, int[] firstValueIndexes, BitSet nullsMask) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((int[])values) + BlockRamUsageEstimator.sizeOf(firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(nullsMask);
    }

    public long ramBytesUsed() {
        return IntArrayBlock.ramBytesEstimated(this.values, this.firstValueIndexes, this.nullsMask);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntBlock) {
            IntBlock that = (IntBlock)obj;
            return IntBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return IntBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + this.mvOrdering() + ", values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released block [" + this + "]");
        }
        this.released = true;
        this.blockFactory.adjustBreaker(-this.ramBytesUsed(), true);
    }
}

