/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;

public enum ElementType {
    BOOLEAN(BooleanBlock::newBlockBuilder),
    INT(IntBlock::newBlockBuilder),
    LONG(LongBlock::newBlockBuilder),
    DOUBLE(DoubleBlock::newBlockBuilder),
    NULL((estimatedSize, blockFactory) -> new ConstantNullBlock.Builder(blockFactory)),
    BYTES_REF(BytesRefBlock::newBlockBuilder),
    DOC(DocBlock::newBlockBuilder),
    UNKNOWN((estimatedSize, blockFactory) -> {
        throw new UnsupportedOperationException("can't build null blocks");
    });

    private final BuilderSupplier builder;

    private ElementType(BuilderSupplier builder) {
        this.builder = builder;
    }

    @Deprecated
    public Block.Builder newBlockBuilder(int estimatedSize) {
        return this.builder.newBlockBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    public Block.Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return this.builder.newBlockBuilder(estimatedSize, blockFactory);
    }

    public static ElementType fromJava(Class<?> type) {
        ElementType elementType;
        if (type == Integer.class) {
            elementType = INT;
        } else if (type == Long.class) {
            elementType = LONG;
        } else if (type == Double.class) {
            elementType = DOUBLE;
        } else if (type == String.class || type == BytesRef.class) {
            elementType = BYTES_REF;
        } else if (type == Boolean.class) {
            elementType = BOOLEAN;
        } else if (type == null || type == Void.class) {
            elementType = NULL;
        } else {
            throw new IllegalArgumentException("Unrecognized class type " + type);
        }
        return elementType;
    }

    static interface BuilderSupplier {
        public Block.Builder newBlockBuilder(int var1, BlockFactory var2);
    }
}

